/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.controller;

import eu.dnetlib.common.controller.AbstractDnetController;
import eu.dnetlib.organizations.controller.SuggestionInfo;
import eu.dnetlib.organizations.controller.UserInfo;
import eu.dnetlib.organizations.model.JournalEntry;
import eu.dnetlib.organizations.model.Note;
import eu.dnetlib.organizations.model.OpenaireDuplicate;
import eu.dnetlib.organizations.model.OrganizationSearchEntry;
import eu.dnetlib.organizations.model.Relationship;
import eu.dnetlib.organizations.model.utils.BrowseEntry;
import eu.dnetlib.organizations.model.utils.OrganizationConflict;
import eu.dnetlib.organizations.model.utils.OrganizationSearchEntrySpecification;
import eu.dnetlib.organizations.model.view.ConflictGroupView;
import eu.dnetlib.organizations.model.view.DuplicateGroupView;
import eu.dnetlib.organizations.model.view.OpenaireDuplicateView;
import eu.dnetlib.organizations.model.view.OrganizationInfoView;
import eu.dnetlib.organizations.model.view.OrganizationView;
import eu.dnetlib.organizations.model.view.RelationGroupView;
import eu.dnetlib.organizations.model.view.RelationshipView;
import eu.dnetlib.organizations.repository.JournalEntryRepository;
import eu.dnetlib.organizations.repository.NoteRepository;
import eu.dnetlib.organizations.repository.OrganizationSearchEntryRepository;
import eu.dnetlib.organizations.repository.UserCountryRepository;
import eu.dnetlib.organizations.repository.readonly.ConflictGroupViewRepository;
import eu.dnetlib.organizations.repository.readonly.DuplicateGroupViewRepository;
import eu.dnetlib.organizations.repository.readonly.OpenaireDuplicateViewRepository;
import eu.dnetlib.organizations.repository.readonly.OrganizationInfoViewRepository;
import eu.dnetlib.organizations.repository.readonly.OrganizationViewRepository;
import eu.dnetlib.organizations.repository.readonly.RelationGroupViewRepository;
import eu.dnetlib.organizations.repository.readonly.RelationshipViewRepository;
import eu.dnetlib.organizations.repository.readonly.SuggestionInfoViewByCountryRepository;
import eu.dnetlib.organizations.utils.CSVConverter;
import eu.dnetlib.organizations.utils.DatabaseUtils;
import eu.dnetlib.organizations.utils.OrganizationStatus;
import eu.dnetlib.organizations.utils.RelationType;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.StringArrayPropertyEditor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/organizations"})
public class OrganizationController
extends AbstractDnetController {
    private static final String SPECIAL_STATUS_FOR_CANDIDATE_DUP = "candidate_dup";
    @Autowired
    private OrganizationViewRepository organizationViewRepository;
    @Autowired
    private OrganizationInfoViewRepository organizationInfoViewRepository;
    @Autowired
    private OrganizationSearchEntryRepository organizationSearchEntryRepository;
    @Autowired
    private OpenaireDuplicateViewRepository openaireDuplicateViewRepository;
    @Autowired
    private ConflictGroupViewRepository conflictGroupViewRepository;
    @Autowired
    private RelationshipViewRepository relationshipViewRepository;
    @Autowired
    private RelationGroupViewRepository relationGroupViewRepository;
    @Autowired
    private SuggestionInfoViewByCountryRepository suggestionInfoViewByCountryRepository;
    @Autowired
    private UserCountryRepository userCountryRepository;
    @Autowired
    private DuplicateGroupViewRepository duplicateGroupViewRepository;
    @Autowired
    private NoteRepository noteRepository;
    @Autowired
    private JournalEntryRepository journalEntryRepository;
    @Autowired
    private DatabaseUtils databaseUtils;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String[].class, (PropertyEditor)new StringArrayPropertyEditor(null));
    }

    @PostMapping(value={"/save"})
    public List<String> save(@RequestBody OrganizationView org, Authentication authentication) {
        if (StringUtils.isBlank((CharSequence)org.getName())) {
            throw new RuntimeException("Missing field: name");
        }
        if (StringUtils.isBlank((CharSequence)org.getCountry())) {
            throw new RuntimeException("Missing field: country");
        }
        if (StringUtils.isBlank((CharSequence)org.getType())) {
            throw new RuntimeException("Missing field: type");
        }
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForCountry(org.getCountry(), UserInfo.getEmail((Authentication)authentication))) {
            String orgId = this.databaseUtils.insertOrUpdateOrganization(org, UserInfo.getEmail((Authentication)authentication), UserInfo.isSimpleUser((Authentication)authentication));
            return Arrays.asList(orgId);
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/info"})
    public OrganizationInfoView infoById(@RequestParam String id, Authentication authentication) {
        return (OrganizationInfoView)this.organizationInfoViewRepository.findById((Object)id).get();
    }

    @GetMapping(value={"/suggestionsInfo"})
    public SuggestionInfo suggestionsInfo(Authentication authentication) {
        SuggestionInfo info;
        block3: {
            block4: {
                block2: {
                    info = new SuggestionInfo();
                    if (!UserInfo.isSuperAdmin((Authentication)authentication)) break block2;
                    this.suggestionInfoViewByCountryRepository.findAll().forEach(arg_0 -> ((SuggestionInfo)info).add(arg_0));
                    break block3;
                }
                if (UserInfo.isSimpleUser((Authentication)authentication)) break block4;
                if (!UserInfo.isNationalAdmin((Authentication)authentication)) break block3;
            }
            this.userCountryRepository.getCountriesForUser(UserInfo.getEmail((Authentication)authentication)).stream().map(arg_0 -> ((SuggestionInfoViewByCountryRepository)this.suggestionInfoViewByCountryRepository).findById(arg_0)).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((SuggestionInfo)info).add(arg_0));
        }
        return info;
    }

    @GetMapping(value={"/get"})
    public OrganizationView findById(@RequestParam String id, Authentication authentication) {
        OrganizationView org = (OrganizationView)this.organizationViewRepository.findById((Object)id).get();
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForCountry(org.getCountry(), UserInfo.getEmail((Authentication)authentication))) {
            return org;
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/conflicts"})
    public List<OrganizationConflict> conflicts(@RequestParam String id, Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForId(id, UserInfo.getEmail((Authentication)authentication))) {
            return this.databaseUtils.listConflictsForId(id);
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/duplicates"})
    public List<OpenaireDuplicateView> duplicates(@RequestParam String id, Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForId(id, UserInfo.getEmail((Authentication)authentication))) {
            return this.listDuplicates(id);
        }
        throw new RuntimeException("User not authorized");
    }

    private List<OpenaireDuplicateView> listDuplicates(String id) {
        return this.openaireDuplicateViewRepository.findByLocalId(id);
    }

    @GetMapping(value={"/conflicts/byCountry/{country}"})
    public Collection<Set<OrganizationConflict>> findConflictsByCountry(@PathVariable String country, Authentication authentication) {
        block5: {
            block4: {
                if (UserInfo.isSuperAdmin((Authentication)authentication)) {
                    return this.groupConflicts(this.conflictGroupViewRepository.findByCountry1OrCountry2(country, country).stream());
                }
                if (UserInfo.isSimpleUser((Authentication)authentication)) break block4;
                if (!UserInfo.isNationalAdmin((Authentication)authentication)) break block5;
            }
            Stream list = this.userCountryRepository.getCountriesForUser(UserInfo.getEmail((Authentication)authentication)).stream().filter(country::equalsIgnoreCase).map(c -> this.conflictGroupViewRepository.findByCountry1OrCountry2(c, c).stream()).findFirst().orElse(Stream.empty());
            return this.groupConflicts(list);
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/duplicates/byCountry/{country}"})
    public Iterable<DuplicateGroupView> findDuplicatesByCountry(@PathVariable String country, @RequestParam(required=false, defaultValue="0") int page, @RequestParam(required=false, defaultValue="${openorgs.findDuplicatesByCountry.limit.default}") int size, Authentication authentication) {
        block5: {
            block4: {
                if (UserInfo.isSuperAdmin((Authentication)authentication)) {
                    return this.duplicateGroupViewRepository.findByCountry(country, (Pageable)PageRequest.of((int)page, (int)size));
                }
                if (UserInfo.isSimpleUser((Authentication)authentication)) break block4;
                if (!UserInfo.isNationalAdmin((Authentication)authentication)) break block5;
            }
            return this.userCountryRepository.getCountriesForUser(UserInfo.getEmail((Authentication)authentication)).stream().filter(country::equalsIgnoreCase).map(c -> this.duplicateGroupViewRepository.findByCountry(c, (Pageable)PageRequest.of((int)page, (int)size))).findFirst().orElse(new ArrayList());
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/duplicates/byCountry/{country}/csv"}, produces={"text/csv"})
    public void findDuplicatesByCountryCSV(@PathVariable String country, HttpServletResponse res, Authentication authentication) throws IOException {
        Iterable list = this.findDuplicatesByCountry(country, 0, Integer.MAX_VALUE, authentication);
        CSVConverter.writeCSV((OutputStream)res.getOutputStream(), (Iterable)list, DuplicateGroupView.class, (String[])new String[]{"id", "name", "city", "country", "numberOfDuplicates"});
    }

    private Collection<Set<OrganizationConflict>> groupConflicts(Stream<ConflictGroupView> stream) {
        TreeMap map = new TreeMap();
        stream.forEach(c -> {
            if (!map.containsKey(c.getGroup())) {
                map.put(c.getGroup(), new TreeSet());
            }
            ((Set)map.get(c.getGroup())).add(new OrganizationConflict(c.getId1(), c.getName1(), c.getType1(), c.getCity1(), c.getCountry1()));
            ((Set)map.get(c.getGroup())).add(new OrganizationConflict(c.getId2(), c.getName2(), c.getType2(), c.getCity2(), c.getCountry2()));
        });
        return map.values();
    }

    @GetMapping(value={"/relations"})
    public List<RelationshipView> relations(@RequestParam String id, Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForId(id, UserInfo.getEmail((Authentication)authentication))) {
            return this.listRelations(id);
        }
        throw new RuntimeException("User not authorized");
    }

    private List<RelationshipView> listRelations(String id) {
        return this.relationshipViewRepository.findById1(id);
    }

    @GetMapping(value={"/relations/byCountry/{country}"})
    public Iterable<RelationGroupView> findRelationsByCountry(@PathVariable String country, @RequestParam(required=false, defaultValue="0") int page, @RequestParam(required=false, defaultValue="${openorgs.findRelationsByCountry.limit.default}") int size, Authentication authentication) {
        block5: {
            block4: {
                if (UserInfo.isSuperAdmin((Authentication)authentication)) {
                    return this.relationGroupViewRepository.findByCountry(country, (Pageable)PageRequest.of((int)page, (int)size));
                }
                if (UserInfo.isSimpleUser((Authentication)authentication)) break block4;
                if (!UserInfo.isNationalAdmin((Authentication)authentication)) break block5;
            }
            return this.userCountryRepository.getCountriesForUser(UserInfo.getEmail((Authentication)authentication)).stream().filter(country::equalsIgnoreCase).map(c -> this.relationGroupViewRepository.findByCountry(c, (Pageable)PageRequest.of((int)page, (int)size))).findFirst().orElse(new ArrayList());
        }
        throw new RuntimeException("User not authorized");
    }

    @PostMapping(value={"/duplicates"})
    public List<OpenaireDuplicateView> duplicates(@RequestBody List<OpenaireDuplicate> simrels, Authentication authentication) {
        boolean b;
        if (simrels.isEmpty()) {
            return new ArrayList<OpenaireDuplicateView>();
        }
        boolean bl = b = UserInfo.isSuperAdmin((Authentication)authentication) || simrels.stream().map(OpenaireDuplicate::getLocalId).distinct().allMatch(id -> this.userCountryRepository.verifyAuthorizationForId(id, UserInfo.getEmail((Authentication)authentication)));
        if (b) {
            this.databaseUtils.saveDuplicates(simrels, UserInfo.getEmail((Authentication)authentication));
            return this.listDuplicates(simrels.get(0).getLocalId());
        }
        throw new RuntimeException("User not authorized");
    }

    @PostMapping(value={"/relations"})
    public List<RelationshipView> relation(@RequestBody List<RelationshipView> rels, Authentication authentication) {
        boolean b;
        if (rels.isEmpty()) {
            return new ArrayList<RelationshipView>();
        }
        String orgId = rels.get(0).getId1();
        boolean bl = b = UserInfo.isSuperAdmin((Authentication)authentication) || rels.stream().map(r -> Arrays.asList(r.getId1(), r.getId2())).flatMap(Collection::stream).distinct().allMatch(id -> this.userCountryRepository.verifyAuthorizationForId(id, UserInfo.getEmail((Authentication)authentication)));
        if (b) {
            List toSave = rels.stream().map(rv -> {
                Relationship r1 = new Relationship();
                r1.setId1(rv.getId1());
                r1.setId2(rv.getId2());
                r1.setRelType(rv.getRelType());
                r1.setStatus(rv.getStatus());
                Relationship r2 = new Relationship();
                r2.setId1(rv.getId2());
                r2.setId2(rv.getId1());
                r2.setRelType(RelationType.valueOf((String)rv.getRelType()).getInverse().toString());
                r2.setStatus(rv.getStatus());
                return Arrays.asList(r1, r2);
            }).flatMap(Collection::stream).collect(Collectors.toList());
            this.databaseUtils.saveRelations(orgId, toSave, UserInfo.getEmail((Authentication)authentication));
            return this.listRelations(orgId);
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/search/{page}/{size}"})
    public Page<OrganizationSearchEntry> search(@PathVariable int page, @PathVariable int size, @RequestParam(required=false, defaultValue="") String status, @RequestParam(required=false, defaultValue="name") String orderBy, @RequestParam(required=false, defaultValue="false") boolean reverse, @RequestParam(required=true) String q, Authentication authentication) throws IOException {
        PageRequest pageRequest = PageRequest.of((int)page, (int)size, (Sort)this.prepareOrderBySort(orderBy, true, reverse));
        if (SPECIAL_STATUS_FOR_CANDIDATE_DUP.equals(status)) {
            return UserInfo.isSuperAdmin((Authentication)authentication) ? this.organizationSearchEntryRepository.searchCandidateDuplicates(q, (Pageable)pageRequest) : this.organizationSearchEntryRepository.searchCandidateDuplicatesForUser(q, UserInfo.getEmail((Authentication)authentication), (Pageable)pageRequest);
        }
        List<String> statuses = StringUtils.isNotBlank((CharSequence)status) ? Arrays.asList(status.split(",")) : (UserInfo.isSimpleUser((Authentication)authentication) ? Arrays.asList(OrganizationStatus.approved.toString()) : Arrays.asList(OrganizationStatus.approved.toString(), OrganizationStatus.suggested.toString()));
        return UserInfo.isSuperAdmin((Authentication)authentication) ? this.organizationSearchEntryRepository.search(q, statuses, (Pageable)pageRequest) : this.organizationSearchEntryRepository.searchForUser(q, UserInfo.getEmail((Authentication)authentication), statuses, (Pageable)pageRequest);
    }

    @GetMapping(value={"/advSearch/{page}/{size}"})
    public Page<OrganizationSearchEntry> advSearch(@PathVariable int page, @PathVariable int size, @RequestParam(required=false, defaultValue="name") String orderBy, @RequestParam(required=false, defaultValue="false") boolean reverse, @RequestParam(required=false) String[] all, @RequestParam(required=false) String[] id, @RequestParam(required=false) String[] openaireId, @RequestParam(required=false) String[] name, @RequestParam(required=false) String[] othername, @RequestParam(required=false) String[] acronym, @RequestParam(required=false) String[] type, @RequestParam(required=false) String[] city, @RequestParam(required=false) String[] country, @RequestParam(required=false) String[] pid, @RequestParam(required=false) String[] status, Authentication authentication) throws IOException {
        if (!UserInfo.isSuperAdmin((Authentication)authentication)) {
            throw new RuntimeException("User not authorized");
        }
        PageRequest pageRequest = PageRequest.of((int)page, (int)size, (Sort)this.prepareOrderBySort(orderBy, false, reverse));
        OrganizationSearchEntrySpecification spec = new OrganizationSearchEntrySpecification();
        spec.addTermConditions(OrganizationSearchEntrySpecification.SearchableField.all, all);
        spec.addTermConditions(OrganizationSearchEntrySpecification.SearchableField.id, id);
        spec.addTermConditions(OrganizationSearchEntrySpecification.SearchableField.openaireId, openaireId);
        spec.addTermConditions(OrganizationSearchEntrySpecification.SearchableField.name, name);
        spec.addTermConditions(OrganizationSearchEntrySpecification.SearchableField.othername, othername);
        spec.addTermConditions(OrganizationSearchEntrySpecification.SearchableField.acronym, acronym);
        spec.addTermConditions(OrganizationSearchEntrySpecification.SearchableField.type, type);
        spec.addTermConditions(OrganizationSearchEntrySpecification.SearchableField.city, city);
        spec.addTermConditions(OrganizationSearchEntrySpecification.SearchableField.country, country);
        spec.addTermConditions(OrganizationSearchEntrySpecification.SearchableField.pid, pid);
        if (status == null || status.length == 0) {
            String[] defaultStatus = new String[]{"!" + OrganizationStatus.raw, "!" + OrganizationStatus.hidden};
            spec.addTermConditions(OrganizationSearchEntrySpecification.SearchableField.status, defaultStatus);
        } else {
            spec.addTermConditions(OrganizationSearchEntrySpecification.SearchableField.status, status);
        }
        return this.organizationSearchEntryRepository.findAll((Specification)spec, (Pageable)pageRequest);
    }

    @GetMapping(value={"/byCountry/{status}/{code}/{page}/{size}"})
    public Page<OrganizationSearchEntry> findByCountry(@PathVariable String status, @PathVariable String code, @PathVariable int page, @PathVariable int size, @RequestParam(required=false, defaultValue="name") String orderBy, @RequestParam(required=false, defaultValue="false") boolean reverse, Authentication authentication) {
        if (!UserInfo.isSuperAdmin((Authentication)authentication) && !this.userCountryRepository.verifyAuthorizationForCountry(code, UserInfo.getEmail((Authentication)authentication))) {
            throw new RuntimeException("User not authorized");
        }
        PageRequest pageRequest = PageRequest.of((int)page, (int)size, (Sort)this.prepareOrderBySort(orderBy, false, reverse));
        if ("all".equalsIgnoreCase(status)) {
            return this.organizationSearchEntryRepository.findByCountry(code, (Pageable)pageRequest);
        }
        return this.organizationSearchEntryRepository.findByCountryAndStatus(code, status, (Pageable)pageRequest);
    }

    @GetMapping(value={"/byCountry/{status}/{code}"})
    public List<OrganizationSearchEntry> findOrgsByStatusAndCountry(@PathVariable String status, @PathVariable String code, @RequestParam(required=false, defaultValue="0") int page, @RequestParam(required=false, defaultValue="${openorgs.findOrgsByStatusAndCountry.limit.default}") int size, @RequestParam(required=false, defaultValue="name") String orderBy, @RequestParam(required=false, defaultValue="false") boolean reverse, Authentication authentication) {
        if (!UserInfo.isSuperAdmin((Authentication)authentication) && !this.userCountryRepository.verifyAuthorizationForCountry(code, UserInfo.getEmail((Authentication)authentication))) {
            throw new RuntimeException("User not authorized");
        }
        PageRequest pageRequest = PageRequest.of((int)page, (int)size, (Sort)this.prepareOrderBySort(orderBy, false, reverse));
        if ("all".equalsIgnoreCase(status)) {
            return this.organizationSearchEntryRepository.findByCountry(code, (Pageable)pageRequest).getContent();
        }
        return this.organizationSearchEntryRepository.findByCountryAndStatus(code, status, (Pageable)pageRequest).getContent();
    }

    @GetMapping(value={"/byCountry/{status}/{code}/csv"}, produces={"text/csv"})
    public void findOrgsByStatusAndCountryCSV(@PathVariable String status, @PathVariable String code, @RequestParam(required=false, defaultValue="name") String orderBy, @RequestParam(required=false, defaultValue="false") boolean reverse, HttpServletResponse res, Authentication authentication) throws IOException {
        List list = this.findOrgsByStatusAndCountry(status, code, 0, Integer.MAX_VALUE, orderBy, reverse, authentication);
        CSVConverter.writeCSV((OutputStream)res.getOutputStream(), (Iterable)list, OrganizationSearchEntry.class, (String[])new String[]{"id", "name", "type", "city", "country", "acronyms", "urls", "status", "nSimilarDups", "nSuggestedDups", "nDifferentDups"});
    }

    @GetMapping(value={"/byType/{status}/{type}/{page}/{size}"})
    public Page<OrganizationSearchEntry> findByType(@PathVariable String status, @PathVariable String type, @PathVariable int page, @PathVariable int size, @RequestParam(required=false, defaultValue="name") String orderBy, @RequestParam(required=false, defaultValue="false") boolean reverse, Authentication authentication) {
        PageRequest pageRequest = PageRequest.of((int)page, (int)size, (Sort)this.prepareOrderBySort(orderBy, false, reverse));
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            if ("all".equalsIgnoreCase(status)) {
                return this.organizationSearchEntryRepository.findByType(type, (Pageable)pageRequest);
            }
            return this.organizationSearchEntryRepository.findByTypeAndStatus(type, status, (Pageable)pageRequest);
        }
        if ("all".equalsIgnoreCase(status)) {
            return this.organizationSearchEntryRepository.findByTypeForUser(type, UserInfo.getEmail((Authentication)authentication), (Pageable)pageRequest);
        }
        return this.organizationSearchEntryRepository.findByTypeAndStatusForUser(type, status, UserInfo.getEmail((Authentication)authentication), (Pageable)pageRequest);
    }

    @GetMapping(value={"/browse/countries"})
    public List<BrowseEntry> browseCountries(Authentication authentication) {
        return UserInfo.isSuperAdmin((Authentication)authentication) ? this.databaseUtils.browseCountries() : this.databaseUtils.browseCountriesForUser(UserInfo.getEmail((Authentication)authentication));
    }

    @GetMapping(value={"/browse/types"})
    public List<BrowseEntry> browseOrganizationTypes(Authentication authentication) {
        return UserInfo.isSuperAdmin((Authentication)authentication) ? this.databaseUtils.browseTypes() : this.databaseUtils.browseTypesForUser(UserInfo.getEmail((Authentication)authentication));
    }

    @PostMapping(value={"/conflicts/fix/similar"})
    public List<String> fixConflictSim(Authentication authentication, @RequestBody List<String> ids) {
        if (ids.size() > 1 && UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForId(ids.get(0), UserInfo.getEmail((Authentication)authentication))) {
            String newOrgId = this.databaseUtils.fixConflictSimilars(ids, UserInfo.getEmail((Authentication)authentication));
            return Arrays.asList(newOrgId);
        }
        return new ArrayList<String>();
    }

    @PostMapping(value={"/conflicts/fix/different"})
    public List<String> fixConflictDiff(Authentication authentication, @RequestBody List<String> ids) {
        if (ids.size() > 1 && UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForId(ids.get(0), UserInfo.getEmail((Authentication)authentication))) {
            this.databaseUtils.fixConflictDifferents(ids, UserInfo.getEmail((Authentication)authentication));
            return ids;
        }
        return new ArrayList<String>();
    }

    @GetMapping(value={"/note"})
    public Note noteById(@RequestParam String id, Authentication authentication) {
        OrganizationView org = (OrganizationView)this.organizationViewRepository.findById((Object)id).get();
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForCountry(org.getCountry(), UserInfo.getEmail((Authentication)authentication))) {
            return this.noteRepository.findById((Object)id).orElse(new Note(id, "", null, null));
        }
        throw new RuntimeException("User not authorized");
    }

    @PostMapping(value={"/note"})
    public Note saveNote(@RequestBody Note note, Authentication authentication) {
        String orgId = note.getOrgId();
        OrganizationView org = (OrganizationView)this.organizationViewRepository.findById((Object)orgId).get();
        if (!UserInfo.isSuperAdmin((Authentication)authentication) && !this.userCountryRepository.verifyAuthorizationForCountry(org.getCountry(), UserInfo.getEmail((Authentication)authentication))) {
            throw new RuntimeException("User not authorized");
        }
        if (StringUtils.isNotBlank((CharSequence)note.getNote())) {
            note.setModifiedBy(UserInfo.getEmail((Authentication)authentication));
            note.setModificationDate(OffsetDateTime.now());
            return (Note)this.noteRepository.save((Object)note);
        }
        this.noteRepository.deleteById((Object)orgId);
        return new Note(orgId, "", null, null);
    }

    @GetMapping(value={"/journal"})
    public List<JournalEntry> journalEntriesById(@RequestParam String id, Authentication authentication) {
        OrganizationView org = (OrganizationView)this.organizationViewRepository.findById((Object)id).get();
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForCountry(org.getCountry(), UserInfo.getEmail((Authentication)authentication))) {
            return this.journalEntryRepository.findByOrgIdOrderByDateDesc(id);
        }
        throw new RuntimeException("User not authorized");
    }

    private Sort prepareOrderBySort(String orderBy, boolean isNative, boolean reverse) {
        String field = StringUtils.isBlank((CharSequence)orderBy) ? "name" : (isNative ? orderBy : ("n_similar_dups".equals(orderBy) ? "nSimilarDups" : ("n_suggested_dups".equals(orderBy) ? "nSuggestedDups" : ("n_different_dups".equals(orderBy) ? "nDifferentDups" : orderBy))));
        return Sort.by((Sort.Order[])new Sort.Order[]{reverse ? Sort.Order.desc((String)field) : Sort.Order.asc((String)field)});
    }
}

