package eu.dnetlib.organizations.utils;

public enum RelationType {

	IsChildOf, IsParentOf, Merged_In, Merges;

	public RelationType getInverse() {
		switch (this) {
		case IsChildOf:
			return IsParentOf;
		case IsParentOf:
			return IsChildOf;
		case Merged_In:
			return Merges;
		case Merges:
			return Merged_In;
		default:
			throw new IllegalArgumentException("No inverse relation for " + this);
		}
	}
}
