/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.repository;

import eu.dnetlib.organizations.model.OrganizationSearchEntry;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface OrganizationSearchEntryRepository
extends JpaRepository<OrganizationSearchEntry, String>,
JpaSpecificationExecutor<OrganizationSearchEntry> {
    @Query(value="SELECT * FROM org_index_search idx WHERE status in :statuses AND (name_norm ilike '%'||:text||'%' OR fulltext_search(txt, :text))", nativeQuery=true)
    public Page<OrganizationSearchEntry> search(@Param(value="text") String var1, @Param(value="statuses") List<String> var2, Pageable var3);

    @Query(value="SELECT idx.* FROM org_index_search idx LEFT OUTER JOIN user_countries uc ON (uc.country = idx.country) WHERE uc.email = :email AND idx.status IN :statuses AND (idx.name_norm ilike '%'||:text||'%' OR fulltext_search(idx.txt, :text))", nativeQuery=true)
    public Page<OrganizationSearchEntry> searchForUser(@Param(value="text") String var1, @Param(value="email") String var2, @Param(value="statuses") List<String> var3, Pageable var4);

    public Page<OrganizationSearchEntry> findByCountry(String var1, Pageable var2);

    public Page<OrganizationSearchEntry> findByCountryAndStatus(String var1, String var2, Pageable var3);

    public Page<OrganizationSearchEntry> findByType(String var1, Pageable var2);

    public Page<OrganizationSearchEntry> findByTypeAndStatus(String var1, String var2, Pageable var3);

    @Query(value="SELECT idx.* FROM org_index_search idx LEFT OUTER JOIN user_countries uc ON (uc.country = idx.country) WHERE idx.type = ?1 AND uc.email = ?2", nativeQuery=true)
    public Page<OrganizationSearchEntry> findByTypeForUser(String var1, String var2, Pageable var3);

    @Query(value="SELECT idx.* FROM org_index_search idx LEFT OUTER JOIN user_countries uc ON (uc.country = idx.country) WHERE idx.type = ?1 AND idx.status = ?2 AND uc.email = ?3", nativeQuery=true)
    public Page<OrganizationSearchEntry> findByTypeAndStatusForUser(String var1, String var2, String var3, Pageable var4);

    @Query(value="SELECT idx.* FROM org_index_search idx\nLEFT OUTER JOIN oa_duplicates d ON (idx.id = d.oa_original_id)\nWHERE idx.status = 'raw' AND (idx.name ilike '%'||:text||'%' OR fulltext_search(idx.txt, :text))GROUP BY idx.id\nHAVING  not('is_similar' = ANY(array_agg(d.status)))", nativeQuery=true)
    public Page<OrganizationSearchEntry> searchCandidateDuplicates(@Param(value="text") String var1, Pageable var2);

    @Query(value="SELECT idx.* FROM org_index_search idx\nLEFT OUTER JOIN oa_duplicates d ON (idx.id = d.oa_original_id)\nLEFT OUTER JOIN user_countries uc ON (uc.country = idx.country)\nWHERE idx.status = 'raw' AND uc.email = :email AND (idx.name ilike '%'||:text||'%' OR fulltext_search(idx.txt, :text))\nGROUP BY idx.id\nHAVING  not('is_similar' = ANY(array_agg(d.status)))", nativeQuery=true)
    public Page<OrganizationSearchEntry> searchCandidateDuplicatesForUser(@Param(value="text") String var1, @Param(value="email") String var2, Pageable var3);
}

