package eu.dnetlib.openaire.exporter.model.community;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonAutoDetect;

import io.swagger.v3.oas.annotations.media.Schema;

@JsonAutoDetect
public class CommunityDatasourceExtended extends CommunityDatasource {

	@NotNull
	@Schema(description = "the community identifier this content provider belongs to", required = true)
	private String communityId;

	@NotNull
	@Schema(description = "content provider name", required = true)
	private String communityName;

	public String getCommunityId() {
		return communityId;
	}

	public void setCommunityId(final String communityId) {
		this.communityId = communityId;
	}

	public String getCommunityName() {
		return communityName;
	}

	public void setCommunityName(final String communityName) {
		this.communityName = communityName;
	}

}
