/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.model.dsm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;

@JsonAutoDetect
public class Header {
    private long total;
    private int page;
    private int size;
    private long time;
    private int statusCode;
    @JsonIgnore
    private Queue<Throwable> exceptions = new LinkedList<Throwable>();

    public static Header newInsance() {
        return new Header();
    }

    public long getTime() {
        return this.time;
    }

    public Header setTime(long time) {
        this.time = time;
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Header setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public long getTotal() {
        return this.total;
    }

    public int getPage() {
        return this.page;
    }

    public int getSize() {
        return this.size;
    }

    public Header setPage(int page) {
        this.page = page;
        return this;
    }

    public Header setSize(int size) {
        this.size = size;
        return this;
    }

    public Header setTotal(long total) {
        this.total = total;
        return this;
    }

    public Queue<Throwable> getExceptions() {
        return this.exceptions;
    }

    public Header setExceptions(Queue<Throwable> exceptions) {
        this.exceptions = exceptions;
        return this;
    }

    public List<String> getErrors() {
        return this.getExceptions().stream().map(Throwable::getMessage).collect(Collectors.toList());
    }

    public String toJson() {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

