/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.model.community;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import eu.dnetlib.openaire.exporter.model.community.CommunityClaimType;
import eu.dnetlib.openaire.exporter.model.community.CommunityMembershipType;
import eu.dnetlib.openaire.exporter.model.community.CommunityPlanType;
import eu.dnetlib.openaire.exporter.model.community.CommunityStatus;
import eu.dnetlib.openaire.exporter.model.community.CommunityType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;

@JsonAutoDetect
public class CommunitySummary {
    @Schema(description="identifies the community")
    protected String id;
    @Schema(description="values for this field reflect the index field _community_ in the index, e.g. 'egi||EGI Federation'")
    protected String queryId;
    @Schema(description="community type")
    protected CommunityType type;
    @Schema(description="community name")
    protected String name;
    @Schema(description="community short name")
    protected String shortName;
    @Schema(description="community name for display")
    protected String displayName;
    @Schema(description="community short name for display")
    protected String displayShortName;
    @Schema(description="community creation date")
    protected LocalDateTime creationDate;
    @Schema(description="community last update date")
    protected LocalDateTime lastUpdateDate;
    @Schema(description="community description")
    protected String description;
    @Schema(description="http url for the community logo")
    protected String logoUrl;
    @Schema(description="status of the community, drives its visibility")
    protected CommunityStatus status;
    @Schema(description="type of claim")
    private CommunityClaimType claim;
    @Schema(description="type of membership")
    private CommunityMembershipType membership;
    @Schema(description="Zenodo community associated to this community")
    protected String zenodoCommunity;
    @Schema(description="community plan")
    protected CommunityPlanType plan;
    @Schema(description="featured")
    protected Boolean featured;

    public CommunitySummary() {
    }

    public CommunitySummary(String id, String queryId, CommunityType type, String name, String shortName, String displayName, String displayShortName, LocalDateTime creationDate, LocalDateTime lastUpdateDate, String description, String logoUrl, CommunityStatus status, String zenodoCommunity, CommunityPlanType plan, Boolean featured) {
        this.id = id;
        this.queryId = queryId;
        this.type = type;
        this.name = name;
        this.shortName = shortName;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.creationDate = creationDate;
        this.lastUpdateDate = lastUpdateDate;
        this.description = description;
        this.logoUrl = logoUrl;
        this.status = status;
        this.zenodoCommunity = zenodoCommunity;
        this.plan = plan;
        this.featured = featured;
    }

    public CommunitySummary(CommunitySummary summary) {
        this(summary.getId(), summary.getQueryId(), summary.getType(), summary.getName(), summary.getShortName(), summary.getDisplayName(), summary.getDisplayShortName(), summary.getCreationDate(), summary.getLastUpdateDate(), summary.getDescription(), summary.getLogoUrl(), summary.getStatus(), summary.getZenodoCommunity(), summary.getPlan(), summary.getFeatured());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public CommunityType getType() {
        return this.type;
    }

    public void setType(CommunityType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayShortName() {
        return this.displayShortName;
    }

    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public LocalDateTime getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(LocalDateTime lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public CommunityStatus getStatus() {
        return this.status;
    }

    public void setStatus(CommunityStatus status) {
        this.status = status;
    }

    public CommunityClaimType getClaim() {
        return this.claim;
    }

    public void setClaim(CommunityClaimType claim) {
        this.claim = claim;
    }

    public CommunityMembershipType getMembership() {
        return this.membership;
    }

    public void setMembership(CommunityMembershipType membership) {
        this.membership = membership;
    }

    public String getZenodoCommunity() {
        return this.zenodoCommunity;
    }

    public void setZenodoCommunity(String zenodoCommunity) {
        this.zenodoCommunity = zenodoCommunity;
    }

    public CommunityPlanType getPlan() {
        return this.plan;
    }

    public void setPlan(CommunityPlanType plan) {
        this.plan = plan;
    }

    public Boolean getFeatured() {
        return this.featured;
    }

    public void setFeatured(Boolean featured) {
        this.featured = featured;
    }
}

