/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.dsm;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.DsmForbiddenException;
import eu.dnetlib.enabling.datasources.common.DsmNotFoundException;
import eu.dnetlib.openaire.common.ISClient;
import eu.dnetlib.openaire.dsm.dao.CountryTermRepository;
import eu.dnetlib.openaire.dsm.dao.DatasourceDao;
import eu.dnetlib.openaire.dsm.dao.MongoLoggerClient;
import eu.dnetlib.openaire.dsm.dao.ResponseUtils;
import eu.dnetlib.openaire.dsm.dao.VocabularyClient;
import eu.dnetlib.openaire.dsm.dao.utils.DsmMappingUtils;
import eu.dnetlib.openaire.dsm.domain.db.ApiDbEntry;
import eu.dnetlib.openaire.dsm.domain.db.DatasourceDbEntry;
import eu.dnetlib.openaire.exporter.exceptions.DsmApiException;
import eu.dnetlib.openaire.exporter.model.dsm.AggregationHistoryResponseV1;
import eu.dnetlib.openaire.exporter.model.dsm.AggregationHistoryResponseV2;
import eu.dnetlib.openaire.exporter.model.dsm.ApiDetails;
import eu.dnetlib.openaire.exporter.model.dsm.ApiDetailsResponse;
import eu.dnetlib.openaire.exporter.model.dsm.DatasourceDetailResponse;
import eu.dnetlib.openaire.exporter.model.dsm.DatasourceDetails;
import eu.dnetlib.openaire.exporter.model.dsm.DatasourceDetailsUpdate;
import eu.dnetlib.openaire.exporter.model.dsm.DatasourceDetailsWithApis;
import eu.dnetlib.openaire.exporter.model.dsm.DatasourceSnippetResponse;
import eu.dnetlib.openaire.exporter.model.dsm.RegisteredDatasourceInfo;
import eu.dnetlib.openaire.exporter.model.dsm.RequestFilter;
import eu.dnetlib.openaire.exporter.model.dsm.RequestSort;
import eu.dnetlib.openaire.exporter.model.dsm.RequestSortOrder;
import eu.dnetlib.openaire.exporter.model.dsm.SimpleDatasourceInfo;
import eu.dnetlib.openaire.exporter.model.dsm.SimpleResponse;
import eu.dnetlib.openaire.exporter.model.vocabularies.Country;
import eu.dnetlib.openaire.exporter.model.vocabularies.Vocabulary;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.transaction.Transactional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"openaire.exporter.enable.dsm"}, havingValue="true")
public class DsmCore {
    private static final Log log = LogFactory.getLog(DsmCore.class);
    @Autowired
    private MongoLoggerClient mongoLoggerClient;
    @Autowired
    private ISClient isClient;
    @Autowired
    private VocabularyClient vocabularyClient;
    @Autowired
    private DatasourceDao<DatasourceDbEntry, ApiDbEntry> dsDao;
    @Autowired
    private CountryTermRepository countryTermRepository;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public List<Country> listCountries() throws DsmApiException {
        ArrayList countries = Lists.newArrayList();
        Vocabulary v = this.vocabularyClient.getCountries();
        countries.addAll(this.countryTermRepository.findAll().stream().filter(Objects::nonNull).map(t -> new Country(t.getTerm(), v.getEnglishName(t.getTerm()))).collect(Collectors.toList()));
        return countries;
    }

    public DatasourceDetailResponse searchDsDetails(RequestSort requestSortBy, RequestSortOrder order, RequestFilter requestFilter, int page, int size) throws DsmApiException {
        try {
            Page dsPage = this.dsDao.search(requestSortBy, order, requestFilter, page, size);
            return ResponseUtils.detailsResponse((List)dsPage.map(DsmMappingUtils::asDetails).getContent(), (long)dsPage.getTotalElements());
        }
        catch (DsmException e) {
            log.error((Object)"error searching datasources", (Throwable)e);
            throw new DsmApiException(e.getCode(), "error searching datasources", (Throwable)e);
        }
    }

    public DatasourceSnippetResponse searchSnippet(RequestSort requestSortBy, RequestSortOrder order, RequestFilter requestFilter, int page, int size) throws DsmApiException {
        try {
            Page dsPage = this.dsDao.search(requestSortBy, order, requestFilter, page, size);
            return ResponseUtils.snippetResponse((List)dsPage.map(DsmMappingUtils::asSnippetExtended).getContent(), (long)dsPage.getTotalElements());
        }
        catch (DsmException e) {
            log.error((Object)"error searching datasources", (Throwable)e);
            throw new DsmApiException(e.getCode(), "error searching datasources", (Throwable)e);
        }
    }

    public DatasourceSnippetResponse searchRegistered(RequestSort requestSortBy, RequestSortOrder order, RequestFilter requestFilter, int page, int size) throws DsmApiException {
        try {
            Page dsPage = this.dsDao.searchRegistered(requestSortBy, order, requestFilter, page, size);
            return ResponseUtils.snippetResponse((List)dsPage.map(DsmMappingUtils::asSnippetExtended).getContent(), (long)dsPage.getTotalElements());
        }
        catch (DsmException e) {
            log.error((Object)"error searching datasources", (Throwable)e);
            throw new DsmApiException(e.getCode(), "error searching datasources", (Throwable)e);
        }
    }

    public List<String> findBaseURLs(RequestFilter requestFilter, int page, int size) throws DsmApiException {
        try {
            return this.dsDao.findApiBaseURLs(requestFilter, page, size);
        }
        catch (DsmException e) {
            log.error((Object)"error searching datasource base urls", (Throwable)e);
            throw new DsmApiException(e.getCode(), "error searching datasource base urls", (Throwable)e);
        }
    }

    public ApiDetailsResponse getApis(String dsId) throws DsmApiException {
        try {
            DatasourceDbEntry ds = (DatasourceDbEntry)this.dsDao.getDs(dsId);
            List apis = this.dsDao.getApis(dsId);
            List api = apis.stream().map(DsmMappingUtils::asDetails).map(a -> a.setEoscDatasourceType(ds.getEoscDatasourceType())).map(a -> a.setTypology(ds.getTypology())).collect(Collectors.toList());
            return ResponseUtils.apiResponse(api, (long)api.size());
        }
        catch (DsmException e) {
            log.error((Object)String.format("error searching datasource api %s", dsId), (Throwable)e);
            throw new DsmApiException(e.getCode(), String.format("error searching datasource api %s", dsId), (Throwable)e);
        }
    }

    public void setManaged(String dsId, boolean managed) throws DsmApiException {
        log.info((Object)String.format("updated ds '%s' managed with '%s'", dsId, managed));
        try {
            this.dsDao.setManaged(dsId, managed);
        }
        catch (DsmException e) {
            throw new DsmApiException(e.getCode(), e.getMessage(), (Throwable)e);
        }
    }

    public boolean isManaged(String dsId) throws DsmApiException {
        try {
            return this.dsDao.isManaged(dsId);
        }
        catch (DsmException e) {
            throw new DsmApiException(e.getCode(), e.getMessage(), (Throwable)e);
        }
    }

    public boolean exist(DatasourceDetails d) throws DsmApiException {
        try {
            return this.dsDao.existDs(d.getId());
        }
        catch (DsmException e) {
            throw new DsmApiException(e.getCode(), e.getMessage(), (Throwable)e);
        }
    }

    public void save(DatasourceDetails d) throws DsmApiException {
        try {
            this.dsDao.saveDs((Datasource)DsmMappingUtils.asDbEntry((DatasourceDetails)d));
            log.info((Object)("DS saved, " + d.getId()));
        }
        catch (DsmException e) {
            log.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new DsmApiException(e.getCode(), e.getMessage(), (Throwable)e);
        }
    }

    @Transactional
    public void save(DatasourceDetailsWithApis d) throws DsmApiException {
        try {
            this.dsDao.saveDs((Datasource)DsmMappingUtils.asDbEntry((DatasourceDetails)d.getDatasource()));
            List apis = d.getApis();
            if (apis != null) {
                for (ApiDetails api : apis) {
                    api.setDatasource(d.getDatasource().getId());
                    this.addApi(api);
                }
            }
        }
        catch (DsmException e) {
            log.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new DsmApiException(e.getCode(), e.getMessage(), (Throwable)e);
        }
    }

    public void updateDatasource(DatasourceDetailsUpdate d) throws DsmApiException {
        try {
            DatasourceDbEntry ds = (DatasourceDbEntry)this.dsDao.getDs(d.getId());
            if (ds == null) {
                throw new DsmNotFoundException(String.format("ds '%s' does not exist", d.getId()));
            }
            DatasourceDbEntry update = DsmMappingUtils.asDbEntry((DatasourceDetailsUpdate)d);
            if (d.getIdentities() != null) {
                HashSet identities = new HashSet(Stream.of(update.getIdentities(), ds.getIdentities()).flatMap(Collection::stream).collect(Collectors.toMap(i -> i.getIssuertype() + i.getPid(), Function.identity(), (i1, i2) -> i1)).values());
                DsmMappingUtils.copyNonNullProperties((Object)update, (Object)ds);
                ds.setIdentities(identities);
            } else {
                DsmMappingUtils.copyNonNullProperties((Object)update, (Object)ds);
            }
            this.dsDao.saveDs((Datasource)ds);
        }
        catch (DsmException e) {
            log.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new DsmApiException(e.getCode(), e.getMessage(), (Throwable)e);
        }
    }

    public void deleteDs(String dsId) throws DsmApiException {
        log.info((Object)String.format("deleted datasource '%s'", dsId));
        try {
            this.dsDao.deleteDs(dsId);
        }
        catch (DsmException e) {
            throw new DsmApiException(e.getCode(), e.getMessage(), (Throwable)e);
        }
    }

    public void updateApiOaiSet(String dsId, String apiId, String oaiSet) throws DsmApiException {
        try {
            this.dsDao.upsertApiOaiSet(apiId, oaiSet);
        }
        catch (DsmException e) {
            throw new DsmApiException(e.getCode(), e.getMessage(), (Throwable)e);
        }
    }

    public void updateApiBaseurl(String dsId, String apiId, String baseUrl) throws DsmApiException {
        log.info((Object)String.format("updated api '%s' baseurl with '%s'", apiId, baseUrl));
        try {
            this.dsDao.updateApiBaseUrl(apiId, baseUrl);
        }
        catch (DsmException e) {
            throw new DsmApiException(e.getCode(), e.getMessage(), (Throwable)e);
        }
    }

    public void updateApiCompatibility(String dsId, String apiId, String compliance, boolean override) throws DsmApiException {
        log.info((Object)String.format("updated api '%s' compliance with '%s'", apiId, compliance));
        try {
            this.dsDao.updateCompliance(null, apiId, compliance, override);
        }
        catch (DsmException e) {
            throw new DsmApiException(e.getCode(), e.getMessage(), (Throwable)e);
        }
    }

    public void addApi(ApiDetails api) throws DsmApiException {
        if (StringUtils.isBlank((CharSequence)api.getId())) {
            api.setId(DsmMappingUtils.createId((ApiDetails)api));
            log.info((Object)String.format("missing api id, created '%s'", api.getId()));
        }
        try {
            this.dsDao.addApi((Api)DsmMappingUtils.asDbEntry((ApiDetails)api));
            log.info((Object)("API saved, id: " + api.getId()));
        }
        catch (DsmException e) {
            throw new DsmApiException(e.getCode(), e.getMessage(), (Throwable)e);
        }
    }

    public void deleteApi(String apiId) throws DsmApiException {
        try {
            this.dsDao.deleteApi(null, apiId);
        }
        catch (DsmForbiddenException e) {
            throw new DsmApiException(e.getCode(), e.getMessage(), (Throwable)e);
        }
        catch (DsmNotFoundException e) {
            throw new DsmApiException(e.getCode(), e.getMessage(), (Throwable)e);
        }
    }

    public void dropCaches() {
        this.mongoLoggerClient.dropCache();
        this.isClient.dropCache();
        this.vocabularyClient.dropCache();
    }

    public SimpleResponse<RegisteredDatasourceInfo> searchRecentRegistered(int size) throws Throwable {
        try {
            String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/openaire/sql/recent_registered_datasources.sql.st"), (Charset)Charset.defaultCharset());
            List list = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(RegisteredDatasourceInfo.class), new Object[]{size});
            return ResponseUtils.simpleResponse((List)list);
        }
        catch (Throwable e) {
            log.error((Object)"error searching recent datasources", e);
            throw e;
        }
    }

    public Long countRegisteredAfter(String fromDate, String typeFilter) throws Throwable {
        try {
            if (StringUtils.isNotBlank((CharSequence)typeFilter)) {
                String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/openaire/sql/recent_registered_datasources_fromDate_typology.st.sql"), (Charset)Charset.defaultCharset());
                return (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{fromDate, typeFilter + "%"});
            }
            String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/openaire/sql/recent_registered_datasources_fromDate.st.sql"), (Charset)Charset.defaultCharset());
            return (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{fromDate});
        }
        catch (Throwable e) {
            log.error((Object)"error searching recent datasources", e);
            throw e;
        }
    }

    @Deprecated
    public AggregationHistoryResponseV1 aggregationhistoryV1(String dsId) throws DsmApiException {
        List history = this.mongoLoggerClient.getAggregationHistoryV1(dsId);
        AggregationHistoryResponseV1 rsp = new AggregationHistoryResponseV1(history);
        rsp.setHeader(ResponseUtils.header((long)history.size()));
        return rsp;
    }

    public AggregationHistoryResponseV2 aggregationhistoryV2(String dsId) throws DsmApiException {
        List history = this.mongoLoggerClient.getAggregationHistoryV2(dsId);
        AggregationHistoryResponseV2 rsp = new AggregationHistoryResponseV2(history);
        rsp.setHeader(ResponseUtils.header((long)history.size()));
        return rsp;
    }

    public SimpleResponse<SimpleDatasourceInfo> searchRecentRegisteredV2(int size) throws Throwable {
        try {
            String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/openaire/sql/recent_registered_datasources_v2.sql.st"), (Charset)Charset.defaultCharset());
            List list = this.jdbcTemplate.query(sql, this.rowMapperForSimpleDatasourceInfo(), new Object[]{size});
            return ResponseUtils.simpleResponse((List)list);
        }
        catch (Throwable e) {
            log.error((Object)"error searching recent datasources", e);
            throw e;
        }
    }

    public Long countFirstCollect(String fromDate, String typeFilter) throws Throwable {
        try {
            if (StringUtils.isNotBlank((CharSequence)typeFilter)) {
                String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/openaire/sql/count_first_collected_datasources_fromDate_typology.st.sql"), (Charset)Charset.defaultCharset());
                return (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{typeFilter + "%", fromDate});
            }
            String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/openaire/sql/count_first_collected_datasources_fromDate.st.sql"), (Charset)Charset.defaultCharset());
            return (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{fromDate});
        }
        catch (Throwable e) {
            log.error((Object)"error searching datasources using the first collection date", e);
            throw e;
        }
    }

    public List<SimpleDatasourceInfo> getFirstCollectedAfter(String fromDate, String typeFilter) throws Throwable {
        try {
            if (StringUtils.isNotBlank((CharSequence)typeFilter)) {
                String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/openaire/sql/first_collected_datasources_fromDate_typology.st.sql"), (Charset)Charset.defaultCharset());
                return this.jdbcTemplate.query(sql, this.rowMapperForSimpleDatasourceInfo(), new Object[]{typeFilter + "%", fromDate});
            }
            String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/openaire/sql/first_collected_datasources_fromDate.st.sql"), (Charset)Charset.defaultCharset());
            return this.jdbcTemplate.query(sql, this.rowMapperForSimpleDatasourceInfo(), new Object[]{fromDate});
        }
        catch (Throwable e) {
            log.error((Object)"error searching datasources using the first collection date", e);
            throw e;
        }
    }

    private RowMapper<SimpleDatasourceInfo> rowMapperForSimpleDatasourceInfo() {
        return (rs, rowNum) -> {
            SimpleDatasourceInfo info = new SimpleDatasourceInfo();
            info.setId(rs.getString("id"));
            info.setOfficialName(rs.getString("officialName"));
            info.setEnglishName(rs.getString("englishName"));
            info.setTypology(rs.getString("typology"));
            info.setEoscType(rs.getString("eoscType"));
            info.setEoscDatasourceType(rs.getString("eoscDatasourceType"));
            info.setRegisteredBy(rs.getString("registeredBy"));
            info.setRegistrationDate(rs.getString("registrationDate"));
            info.setFirstCollectionDate(rs.getString("firstCollectionDate"));
            info.setLastCollectionDate(rs.getString("lastCollectionDate"));
            info.setLastCollectionTotal(rs.getLong("lastCollectionTotal"));
            HashSet compatibilities = new HashSet();
            Collections.addAll(compatibilities, (String[])rs.getArray("compatibilities").getArray());
            if (compatibilities.contains("openaire-cris_1.1")) {
                info.setCompatibility("openaire-cris_1.1");
            } else if (compatibilities.contains("openaire4.0")) {
                info.setCompatibility("openaire4.0");
            } else if (compatibilities.contains("driver") && compatibilities.contains("openaire2.0")) {
                info.setCompatibility("driver-openaire2.0");
            } else if (compatibilities.contains("driver")) {
                info.setCompatibility("driver");
            } else if (compatibilities.contains("openaire2.0")) {
                info.setCompatibility("openaire2.0");
            } else if (compatibilities.contains("openaire3.0")) {
                info.setCompatibility("openaire3.0");
            } else if (compatibilities.contains("openaire2.0_data")) {
                info.setCompatibility("openaire2.0_data");
            } else if (compatibilities.contains("native")) {
                info.setCompatibility("native");
            } else if (compatibilities.contains("hostedBy")) {
                info.setCompatibility("hostedBy");
            } else if (compatibilities.contains("notCompatible")) {
                info.setCompatibility("notCompatible");
            } else {
                info.setCompatibility("UNKNOWN");
            }
            for (String s : (String[])rs.getArray("organizations").getArray()) {
                info.getOrganizations().put(StringUtils.substringBefore((String)s, (String)"@@@").trim(), StringUtils.substringAfter((String)s, (String)"@@@").trim());
            }
            return info;
        };
    }

    public long transformationDateBefore(String api, long timestamp) {
        return this.mongoLoggerClient.findTransformationDateBeforeForApi(api, timestamp);
    }
}

