/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.context;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import eu.dnetlib.openaire.common.ISClient;
import eu.dnetlib.openaire.exporter.exceptions.CommunityException;
import eu.dnetlib.openaire.exporter.model.context.Category;
import eu.dnetlib.openaire.exporter.model.context.CategorySummary;
import eu.dnetlib.openaire.exporter.model.context.Concept;
import eu.dnetlib.openaire.exporter.model.context.ConceptSummary;
import eu.dnetlib.openaire.exporter.model.context.Context;
import eu.dnetlib.openaire.exporter.model.context.ContextSummary;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Deprecated
public class ContextApiCore {
    private static final String SEPARATOR = "::";
    @Autowired
    private ISClient isClient;

    public List<ContextSummary> listContexts(List<String> type) throws CommunityException {
        return this.getContextMap(type).values().stream().map(c -> new ContextSummary().setId(c.getId()).setType(c.getType()).setLabel(c.getLabel()).setStatus(c.getParams().stream().filter(p -> p.getName().equals("status")).map(p -> p.getValue()).findFirst().orElse(""))).collect(Collectors.toList());
    }

    public List<CategorySummary> listCategories(String contextId, Boolean all) throws CommunityException {
        Stream categories = ((Context)this.getContextMap().get(contextId)).getCategories().values().stream();
        return all != false ? this.asCategorySummaries(categories) : this.asCategorySummaries(categories.filter(Category::isClaim));
    }

    private List<CategorySummary> asCategorySummaries(Stream<Category> categories) {
        return categories.map(c -> new CategorySummary().setId(c.getId()).setLabel(c.getLabel()).setHasConcept(c.hasConcepts())).collect(Collectors.toList());
    }

    public List<ConceptSummary> listConcepts(String categoryId, Boolean all) throws CommunityException {
        String contextId = StringUtils.substringBefore((String)categoryId, (String)SEPARATOR);
        Stream concepts = ((Category)((Context)this.getContextMap().get(contextId)).getCategories().get(categoryId)).getConcepts().stream();
        return all != false ? this.asConceptSummaries(concepts) : this.asConceptSummaries(concepts.filter(Concept::isClaim));
    }

    private List<ConceptSummary> asConceptSummaries(Stream<Concept> concepts) {
        return concepts.map(c -> new ConceptSummary().setId(c.getId()).setLabel(c.getLabel()).setHasSubConcept(c.hasSubConcepts())).collect(Collectors.toList());
    }

    public List<ConceptSummary> listSubConcepts(String conceptId, Boolean all) throws CommunityException {
        List ids = Splitter.on((String)SEPARATOR).splitToList((CharSequence)conceptId);
        if (ids.size() < 3) {
            throw new CommunityException("");
        }
        String contextId = (String)ids.get(0);
        String categoryId = contextId + SEPARATOR + (String)ids.get(1);
        Stream<Concept> concepts = ((Category)((Context)this.getContextMap().get(contextId)).getCategories().get(categoryId)).getConcepts().stream().filter(c -> conceptId.equals(c.getId()));
        return all != false ? this.mapConcepts(concepts.filter(Concept::isClaim).collect(Collectors.toList())) : this.mapConcepts(concepts.collect(Collectors.toList()));
    }

    private List<ConceptSummary> mapConcepts(List<Concept> concepts) {
        if (concepts == null || concepts.isEmpty()) {
            return null;
        }
        return concepts.stream().map(c -> new ConceptSummary().setId(c.getId()).setLabel(c.getLabel()).setHasSubConcept(c.hasSubConcepts()).setConcept(this.mapConcepts(c.getConcepts()))).collect(Collectors.toList());
    }

    private Map<String, Context> getContextMap() throws CommunityException {
        return this.getContextMap((List)Lists.newArrayList());
    }

    private Map<String, Context> getContextMap(List<String> type) throws CommunityException {
        try {
            return this.isClient.getContextMap(type);
        }
        catch (IOException e) {
            throw new CommunityException((Throwable)e);
        }
    }
}

