/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.dsm.dao;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import eu.dnetlib.DnetOpenaireExporterProperties;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import eu.dnetlib.openaire.dsm.dao.DatasourceIndexClient;
import eu.dnetlib.openaire.dsm.dao.utils.IndexDsInfo;
import eu.dnetlib.openaire.dsm.dao.utils.IndexRecordsInfo;
import eu.dnetlib.openaire.exporter.exceptions.DsmApiException;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"openaire.exporter.enable.dsm"}, havingValue="true")
public class DatasourceIndexClientImpl
implements DatasourceIndexClient {
    private static final Log log = LogFactory.getLog(DatasourceIndexClientImpl.class);
    public static final String SEPARATOR = "::";
    public static final String DSVERSION = "__dsversion";
    @Autowired
    private DnetOpenaireExporterProperties config;
    private ListeningExecutorService executor;
    private static final Map<String, CloudSolrClient> indexClientMap = new ConcurrentHashMap();

    @PostConstruct
    public void init() {
        this.executor = MoreExecutors.listeningDecorator((ScheduledExecutorService)new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("datasource-index-client-%d").build()));
    }

    @PreDestroy
    public void tearDown() {
        indexClientMap.forEach((name, client) -> {
            try {
                client.close();
            }
            catch (IOException e) {
                log.warn((Object)String.format("unable to gracefully shutdown client for index %s", name));
            }
        });
    }

    public IndexRecordsInfo getIndexInfo(String dsId, IndexDsInfo info, Queue<Throwable> errors) throws DsmApiException {
        try {
            String collectedFrom = StringUtils.substringBefore((String)dsId, (String)SEPARATOR) + SEPARATOR + Hashing.md5((String)StringUtils.substringAfter((String)dsId, (String)SEPARATOR));
            CloudSolrClient indexClient = this.getIndexClient(info);
            CountDownLatch latch = new CountDownLatch(2);
            IndexRecordsInfo indexRecordInfo = new IndexRecordsInfo();
            Futures.addCallback((ListenableFuture)this.executor.submit(() -> this.setDateAndTotal(dsId, collectedFrom, indexClient)), (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)this.executor);
            Futures.addCallback((ListenableFuture)this.executor.submit(() -> this.setFunded(dsId, collectedFrom, indexClient)), (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)this.executor);
            this.waitLatch(latch, errors, this.config.getRequestTimeout());
            return indexRecordInfo;
        }
        catch (Throwable e) {
            throw new DsmApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), String.format("error reading index info", dsId), e);
        }
    }

    public String getLastIndexingDate(IndexDsInfo info) throws DsmApiException {
        try {
            SolrQuery query = new SolrQuery("oaftype:datasource").setRows(Integer.valueOf(1));
            QueryResponse rsp = this.getIndexClient(info).query((SolrParams)query);
            SolrDocument doc = (SolrDocument)Iterables.getFirst((Iterable)rsp.getResults(), null);
            String dsversion = doc.get((Object)DSVERSION).toString();
            return StringUtils.substringBefore((String)dsversion, (String)"T");
        }
        catch (IOException | SolrServerException e) {
            throw new DsmApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), "Error querying index DS profile: " + info, e);
        }
    }

    private Long setFunded(String dsId, String collectedFrom, CloudSolrClient indexClient) throws DsmException {
        String query = String.format("oaftype:result AND deletedbyinference:false AND collectedfromdatasourceid:\"%s\" AND relprojectid:*", collectedFrom);
        log.debug((Object)String.format("query: %s", query));
        try {
            return indexClient.query((SolrParams)new SolrQuery(query).setRows(Integer.valueOf(0))).getResults().getNumFound();
        }
        catch (Throwable e) {
            throw new DsmException(HttpStatus.INTERNAL_SERVER_ERROR.value(), String.format("Error querying index for funded results '%s'", dsId), e);
        }
    }

    private IndexRecordsInfo setDateAndTotal(String dsId, String collectedFrom, CloudSolrClient indexClient) throws DsmException {
        try {
            String query = String.format("oaftype:result AND deletedbyinference:false AND collectedfromdatasourceid:\"%s\"", collectedFrom);
            log.debug((Object)String.format("query: %s", query));
            QueryResponse rsp = indexClient.query((SolrParams)new SolrQuery(query).setRows(Integer.valueOf(1)));
            SolrDocument doc = (SolrDocument)Iterables.getFirst((Iterable)rsp.getResults(), (Object)new SolrDocument());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("got document %s", doc.get((Object)"__indexrecordidentifier")));
            }
            return new IndexRecordsInfo().setDate(this.getDate(doc)).setTotal(rsp.getResults().getNumFound());
        }
        catch (Throwable e) {
            throw new DsmException(HttpStatus.INTERNAL_SERVER_ERROR.value(), String.format("Error querying index for date and total '%s'", dsId), e);
        }
    }

    private String getDate(SolrDocument doc) throws DsmException {
        List dsversion = (List)doc.get((Object)DSVERSION);
        if (dsversion == null || dsversion.isEmpty()) {
            throw new DsmException(HttpStatus.INTERNAL_SERVER_ERROR.value(), String.format("cannot find %s in matched solr document", DSVERSION));
        }
        Date date = (Date)Iterables.getLast((Iterable)dsversion);
        return DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd");
    }

    private synchronized CloudSolrClient getIndexClient(IndexDsInfo info) {
        if (!indexClientMap.containsKey(info.getColl())) {
            CloudSolrClient client = new CloudSolrClient.Builder((List)Lists.newArrayList((Object[])new String[]{info.getIndexBaseUrl()})).build();
            client.setDefaultCollection(info.getColl());
            indexClientMap.put(info.getColl(), client);
        }
        return (CloudSolrClient)indexClientMap.get(info.getColl());
    }

    private void waitLatch(CountDownLatch latch, Queue<Throwable> errors, int waitSeconds) {
        try {
            if (!latch.await(waitSeconds, TimeUnit.SECONDS)) {
                errors.offer(new TimeoutException("Waiting for requests to complete has timed out."));
            }
        }
        catch (InterruptedException e) {
            errors.offer(e);
        }
    }
}

