/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.dsm;

import eu.dnetlib.openaire.common.AbstractExporterController;
import eu.dnetlib.openaire.dsm.DsmCore;
import eu.dnetlib.openaire.dsm.dao.ResponseUtils;
import eu.dnetlib.openaire.exporter.exceptions.DsmApiException;
import eu.dnetlib.openaire.exporter.model.dsm.AggregationHistoryResponseV2;
import eu.dnetlib.openaire.exporter.model.dsm.Response;
import eu.dnetlib.openaire.exporter.model.dsm.SimpleDatasourceInfo;
import eu.dnetlib.openaire.exporter.model.dsm.SimpleResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.commons.lang3.time.StopWatch;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@ConditionalOnProperty(value={"openaire.exporter.enable.dsm"}, havingValue="true")
@Tag(name="OpenAIRE DSM API (version 2.0)", description="the OpenAIRE Datasource Manager API 2.0")
@RequestMapping(value={"/dsm/2.0"})
public class DsmApiControllerV2
extends AbstractExporterController {
    @Autowired
    private DsmCore dsmCore;

    @GetMapping(value={"/recentregistered/{size}"})
    @Operation(summary="return the latest datasources that were registered through Provide (v2)", description="Returns list of Datasource basic info.", tags={"Datasource", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SimpleResponse<SimpleDatasourceInfo> recentRegisteredV2(@PathVariable int size) throws Throwable {
        StopWatch stop = StopWatch.createStarted();
        SimpleResponse rsp = this.dsmCore.searchRecentRegisteredV2(size);
        return (SimpleResponse)this.prepareResponse(1, size, stop, (Response)rsp);
    }

    @GetMapping(value={"/countfirstcollect"})
    @Operation(summary="return the number of datasources registered after the given date", description="Returns a number.", tags={"Datasource", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Long countFirstCollectAfter(@RequestParam String fromDate, @RequestParam(required=false) String typologyFilter) throws Throwable {
        return this.dsmCore.countFirstCollect(fromDate, typologyFilter);
    }

    @GetMapping(value={"/firstCollected"})
    @Operation(summary="return the datasources that were collected for the first time after the specified date", description="Returns list of Datasource basic info.", tags={"Datasource", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SimpleResponse<SimpleDatasourceInfo> firstCollectedAfter(@RequestParam String fromDate, @RequestParam(required=false) String typologyFilter) throws Throwable {
        StopWatch stop = StopWatch.createStarted();
        List list = this.dsmCore.getFirstCollectedAfter(fromDate, typologyFilter);
        SimpleResponse rsp = ResponseUtils.simpleResponse((List)list);
        return (SimpleResponse)this.prepareResponse(1, list.size(), stop, (Response)rsp);
    }

    @GetMapping(value={"/aggregationhistory/{dsId}"}, produces={"application/json"})
    @Operation(summary="Return history", description="Returns the aggregation history of the datasources (it includes also the failures)", tags={"Datasource", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public AggregationHistoryResponseV2 aggregationHistory(@PathVariable String dsId) throws DsmApiException {
        StopWatch stop = StopWatch.createStarted();
        AggregationHistoryResponseV2 rsp = this.dsmCore.aggregationhistoryV2(dsId);
        return (AggregationHistoryResponseV2)this.prepareResponse(0, rsp.getAggregationInfo().size(), stop, (Response)rsp);
    }
}

