/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.controllers;

import eu.dnetlib.app.directindex.clients.HasCache;
import eu.dnetlib.app.directindex.service.DirectIndexService;
import eu.dnetlib.app.directindex.tasks.ScheduledActions;
import io.swagger.v3.oas.annotations.Parameter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin"})
public class AdminController {
    @Autowired
    private ScheduledActions scheduledActions;
    @Autowired
    private DirectIndexService service;
    @Autowired
    private List<HasCache> clients;

    @GetMapping(value={"/info"})
    public Map<String, ?> info() {
        return this.service.getInfo();
    }

    @DeleteMapping(value={"/other-caches"})
    @ResponseStatus(value=HttpStatus.OK)
    public void evictCaches() {
        this.clients.forEach(HasCache::clearCache);
    }

    @GetMapping(value={"/scheduling/{enabled}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void updateScheduling(@PathVariable boolean enabled) {
        this.scheduledActions.setEnabled(enabled);
    }

    @GetMapping(value={"/resetExecutions/all"})
    @ResponseStatus(value=HttpStatus.OK)
    public void resetExecutions() {
        this.service.resetExecutions();
    }

    @GetMapping(value={"/resetExecutions/byCriteria"})
    @ResponseStatus(value=HttpStatus.OK)
    public void resetExecutions(@Parameter(description="The date is expressed as a UNIX timestamp (ie. number of seconds from 1970-01-01)") @RequestParam long byTimestampAfter, @Parameter(description="the ID of the datasource that provided the record") @RequestParam String collectedFromId, @Parameter(description="the type of the record (publication, dataset, software, ...) - optional") @RequestParam(required=false) String type) {
        LocalDateTime dt = LocalDateTime.ofInstant(Instant.ofEpochSecond(byTimestampAfter), TimeZone.getDefault().toZoneId());
        this.service.resetExecutions(dt, collectedFromId, type);
    }

    @GetMapping(value={"/resetExecutions/byId"})
    @ResponseStatus(value=HttpStatus.OK)
    public void resetExecutions(@RequestParam String id) {
        this.service.resetExecutions(id);
    }

    @DeleteMapping(value={"/records-cache/byDateBefore"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteExpiredRecordsByDateBefore(@Parameter(description="The date is expressed as a UNIX timestamp (ie. number of seconds from 1970-01-01)") @RequestParam long timestamp) {
        LocalDateTime dt = LocalDateTime.ofInstant(Instant.ofEpochSecond(timestamp), TimeZone.getDefault().toZoneId());
        this.service.clearDatabase(dt);
    }

    @DeleteMapping(value={"/records-cache/all"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteExpiredRecords() {
        this.service.clearDatabase();
    }

    @DeleteMapping(value={"/records-cache/byId"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteExpiredRecordsById(@RequestParam String id) {
        this.service.clearDatabase(id);
    }
}

