/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.clients;

import eu.dnetlib.app.directindex.clients.HasCache;
import eu.dnetlib.app.directindex.clients.ProjectClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class ProjectClient
implements HasCache {
    private static final Log log = LogFactory.getLog(ProjectClient.class);
    @Value(value="${dnet.directindex.funders.url}")
    private String fundersApiUrl;

    @Cacheable(value={"projects"})
    public ProjectInfo resolveProjectLink(String s) {
        String acronym;
        String[] arr = s.split("/");
        if (arr.length <= 4) {
            return null;
        }
        ProjectInfo info = new ProjectInfo();
        String string = acronym = arr.length > 7 ? arr[7] : "";
        String title = arr.length > 6 ? (StringUtils.isNotBlank((CharSequence)arr[6]) ? arr[6] : acronym) : "";
        String code = arr[4].replace("%2F", "/");
        String jurisdiction = arr.length > 5 ? arr[5] : "";
        String funderShortName = this.fixFunderShortName(arr[2]);
        FunderInfo funder = (FunderInfo)this.findFunders().get(funderShortName.toLowerCase());
        if (funder == null) {
            return null;
        }
        String fundingName = this.fixFundingName(arr[3]);
        String fundingId = StringUtils.isNotBlank((CharSequence)fundingName) ? String.format("%s::%s", funder.getId(), fundingName) : null;
        String projectPrefix = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{(String)funder.getProjectPrefixByFundingName().get(fundingName.toLowerCase()), (String)funder.getProjectPrefixByFundingName().get(""), StringUtils.rightPad((String)funderShortName.toLowerCase(), (int)12, (String)"_")});
        String projectId = String.format("%s::%s", projectPrefix, DigestUtils.md5Hex((String)code));
        info.setId(projectId);
        info.setAcronym(acronym);
        info.setTitle(title);
        info.setCode(code);
        info.setJurisdiction(jurisdiction);
        info.setFunderId(funder.getId());
        info.setFunderShortName(funderShortName);
        info.setFunderName(funder.getName());
        info.setFundingId(fundingId);
        info.setFundingName(fundingName);
        return info;
    }

    @Cacheable(value={"funders"}, key="'all'")
    private Map<String, FunderInfo> findFunders() {
        FunderResponse[] funders;
        HashMap<String, FunderInfo> map = new HashMap<String, FunderInfo>();
        RestTemplate rt = new RestTemplate();
        for (FunderResponse fr : funders = (FunderResponse[])rt.getForObject(this.fundersApiUrl, FunderResponse[].class, new Object[0])) {
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fr.getId(), fr.getLegalName(), fr.getLegalShortName()})) continue;
            FunderInfo info = new FunderInfo(fr.getId(), fr.getLegalName());
            for (FunderDatasourceResponse ds : fr.getDatasources()) {
                String fundingProgram = StringUtils.isNotBlank((CharSequence)ds.getFundingProgram()) ? ds.getFundingProgram().toLowerCase() : "";
                info.getProjectPrefixByFundingName().put(fundingProgram, ds.getNsPrefix());
            }
            log.info((Object)("preparing funder info: " + fr.getId()));
            map.put(fr.getLegalShortName().toLowerCase(), info);
        }
        return map;
    }

    @CacheEvict(value={"projects", "funders"}, allEntries=true)
    public void clearCache() {
    }

    private String fixFunderShortName(String funderShortName) {
        switch (funderShortName.toLowerCase()) {
            case "aff": {
                return "AKA";
            }
            case "rcuK": {
                return "UKRI";
            }
            case "rpf": {
                return "RIF";
            }
        }
        return funderShortName;
    }

    private String fixFundingName(String fundingName) {
        if (fundingName.toLowerCase().startsWith("horizon 2020")) {
            return "H2020";
        }
        if (fundingName.toLowerCase().startsWith("horizon europe")) {
            return "HE";
        }
        return fundingName;
    }

    public String getFundersApiUrl() {
        return this.fundersApiUrl;
    }

    public void setFundersApiUrl(String fundersApiUrl) {
        this.fundersApiUrl = fundersApiUrl;
    }
}

