/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@Profile(value={"http-basic-security"})
public class HttpBasicSecurityConfig {
    @Value(value="${dnet.directindex.auth.client.user}")
    private String clientUser;
    @Value(value="${dnet.directindex.auth.client.password}")
    private String clientPassword;
    @Value(value="${dnet.directindex.auth.admin.user}")
    private String adminUser;
    @Value(value="${dnet.directindex.auth.admin.password}")
    private String adminPassword;

    @Bean
    public InMemoryUserDetailsManager userDetailsService() {
        UserDetails client = User.withUsername((String)this.clientUser).password(this.clientPassword).roles(new String[]{"USER"}).build();
        UserDetails admin = User.withUsername((String)this.adminUser).password(this.adminPassword).roles(new String[]{"USER", "ADMIN"}).build();
        return new InMemoryUserDetailsManager(new UserDetails[]{client, admin});
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.httpBasic().and()).authorizeRequests().antMatchers(new String[]{"/api/results/**"})).hasRole("USER").antMatchers(new String[]{"/api/sword/**"})).hasRole("USER").antMatchers(new String[]{"/api/admin/**"})).hasRole("ADMIN").and()).csrf().disable()).formLogin().disable();
        return (SecurityFilterChain)http.build();
    }
}

