package eu.dnetlib.app.directindex.input;

import java.io.Serializable;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema.RequiredMode;

public class PidEntry implements Serializable {

	private static final long serialVersionUID = -4282430427274772667L;

	@Schema(requiredMode = RequiredMode.REQUIRED, description = "E.g. doi, pmc, urn. See http://api.openaire.eu/vocabularies/dnet:pid_types")
	private String type;

	@Schema(requiredMode = RequiredMode.REQUIRED)
	private String value;

	public PidEntry() {}

	public PidEntry(final String type, final String value) {
		this.type = type;
		this.value = value;
	}

	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public String getValue() {
		return value;
	}

	public void setValue(final String value) {
		this.value = value;
	}
}
