package eu.dnetlib.app.directindex.errors;

import java.time.LocalDateTime;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.exception.ExceptionUtils;

import com.fasterxml.jackson.annotation.JsonProperty;

public class SwordError {

	@JsonProperty("@context")
	private final String context = "https://swordapp.github.io/swordv3/swordv3.jsonld";

	@JsonProperty("@type")
	private final SwordErrorType type;

	private final LocalDateTime timestamp;

	private final String error;

	private final String log;

	public SwordError(final HttpServletRequest req, final Throwable e) {

		if (e instanceof SwordException) {
			type = ((SwordException) e).getError();
		} else {
			type = SwordErrorType.BadRequest;
		}

		error = e.getMessage();

		timestamp = LocalDateTime.now();
		log = ExceptionUtils.getStackTrace(e);

	}

	public String getContext() {
		return context;
	}

	public SwordErrorType getType() {
		return type;
	}

	public LocalDateTime getTimestamp() {
		return timestamp;
	}

	public String getError() {
		return error;
	}

	public String getLog() {
		return log;
	}

// @formatter:off
/*
	{
		  "@context" : "https://swordapp.github.io/swordv3/swordv3.jsonld",

		  "@type" : "BadRequest",

		  "timestamp" : "[timestamp]",
		  "error" : "error summary",
		  "log" : "text log of any debug information for the client"
		}

*/
}
