/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.mapping;

import com.fasterxml.jackson.core.JsonProcessingException;
import eu.dnetlib.app.directindex.clients.CommunityClient;
import eu.dnetlib.app.directindex.clients.DatasourceManagerClient;
import eu.dnetlib.app.directindex.clients.ProjectClient;
import eu.dnetlib.app.directindex.clients.VocabularyClient;
import eu.dnetlib.app.directindex.errors.DirectIndexApiException;
import eu.dnetlib.app.directindex.input.DatasourceEntry;
import eu.dnetlib.app.directindex.input.PidEntry;
import eu.dnetlib.app.directindex.input.ResultEntry;
import eu.dnetlib.app.directindex.mapping.InstanceWithTypeCode;
import eu.dnetlib.app.directindex.mapping.XMLSolrSerializer;
import eu.dnetlib.dhp.schema.solr.AccessRight;
import eu.dnetlib.dhp.schema.solr.Author;
import eu.dnetlib.dhp.schema.solr.BestAccessRight;
import eu.dnetlib.dhp.schema.solr.Category;
import eu.dnetlib.dhp.schema.solr.Concept;
import eu.dnetlib.dhp.schema.solr.Context;
import eu.dnetlib.dhp.schema.solr.Country;
import eu.dnetlib.dhp.schema.solr.Funder;
import eu.dnetlib.dhp.schema.solr.Funding;
import eu.dnetlib.dhp.schema.solr.FundingLevel;
import eu.dnetlib.dhp.schema.solr.Instance;
import eu.dnetlib.dhp.schema.solr.Language;
import eu.dnetlib.dhp.schema.solr.Pid;
import eu.dnetlib.dhp.schema.solr.Provenance;
import eu.dnetlib.dhp.schema.solr.RecordType;
import eu.dnetlib.dhp.schema.solr.RelatedRecord;
import eu.dnetlib.dhp.schema.solr.RelatedRecordHeader;
import eu.dnetlib.dhp.schema.solr.Result;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import eu.dnetlib.dhp.schema.solr.SolrRecordHeader;
import eu.dnetlib.dhp.solr.mapping.SolrInputDocumentMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SolrRecordMapper {
    @Autowired
    private DatasourceManagerClient dsmClient;
    @Autowired
    private VocabularyClient vocClient;
    @Autowired
    private CommunityClient communityClient;
    @Autowired
    private ProjectClient projectClient;
    private static final Log log = LogFactory.getLog(SolrRecordMapper.class);

    public SolrInputDocument toSolrInputRecord(ResultEntry result) throws JsonProcessingException {
        SolrRecord sr = this.toSolrRecord(result);
        return SolrInputDocumentMapper.map((SolrRecord)sr, (String)XMLSolrSerializer.generateXML((SolrRecord)sr));
    }

    public SolrRecord toSolrRecord(ResultEntry result) {
        Provenance collectedFrom = this.prepareProvenance(result.getCollectedFromId());
        Provenance hostedBy = StringUtils.isNotBlank((CharSequence)result.getHostedById()) ? this.prepareProvenance(result.getHostedById()) : collectedFrom;
        List<Pid> pids = result.getPids() == null ? Arrays.asList(new Pid[0]) : result.getPids().stream().map(arg_0 -> this.prepareDnetPid(arg_0)).toList();
        SolrRecord sr = new SolrRecord();
        sr.setHeader(this.prepareDnetHeader(result));
        sr.setResult(this.prepareDnetResult(result, collectedFrom, hostedBy, pids));
        sr.setCollectedfrom(Arrays.asList(collectedFrom));
        if (result.getLinksToProjects() != null) {
            sr.setLinks(result.getLinksToProjects().stream().map(arg_0 -> this.prepareDnetProjectLink(arg_0)).toList());
        }
        sr.setPid(pids);
        if (result.getContexts() != null) {
            sr.setContext(this.prepareDnetContext(result.getContexts()));
        }
        return sr;
    }

    public ResultEntry toResultEntry(SolrRecord r) {
        Instance instance;
        if (r == null) {
            return null;
        }
        Result result = r.getResult();
        if (result == null) {
            return null;
        }
        SolrRecordHeader header = r.getHeader();
        if (header == null) {
            return null;
        }
        ResultEntry re = new ResultEntry();
        if (header.getId() != null) {
            re.setOpenaireId(header.getId());
        }
        if (header.getOriginalId() != null) {
            re.setOriginalId((String)header.getOriginalId().stream().findFirst().orElse(null));
        }
        if (result.getMaintitle() != null) {
            re.setTitle(result.getMaintitle());
        }
        if (result.getAuthor() != null) {
            re.setAuthors(result.getAuthor().stream().map(Author::getFullname).toList());
        }
        if (result.getPublisher() != null) {
            re.setPublisher(result.getPublisher());
        }
        if (result.getDescription() != null) {
            re.setDescription((String)result.getDescription().stream().findFirst().orElse(null));
        }
        if (result.getLanguage() != null) {
            re.setLanguage(result.getLanguage().getCode());
        }
        if (header.getRecordType() != null) {
            re.setType(header.getRecordType().toString());
        }
        if (result.getEmbargoenddate() != null) {
            re.setEmbargoEndDate(result.getEmbargoenddate());
        }
        if (result.getBestaccessright() != null) {
            re.setAccessRightCode(result.getBestaccessright().getCode());
        }
        if (r.getPid() != null) {
            re.setPids(r.getPid().stream().map(p -> new PidEntry(p.getTypeCode(), p.getValue())).toList());
        }
        if ((instance = (Instance)result.getInstance().stream().findFirst().orElse(null)) != null) {
            re.setResourceType(instance.getInstancetype());
            if (instance.getUrl() != null) {
                re.setUrl((String)instance.getUrl().stream().findFirst().orElse(null));
            }
            if (instance.getCollectedfrom() != null) {
                re.setCollectedFromId(instance.getCollectedfrom().getDsId());
            }
            if (instance.getHostedby() != null) {
                re.setHostedById(instance.getHostedby().getDsId());
            }
        }
        ArrayList<String> contexts = new ArrayList<String>();
        if (r.getContext() != null) {
            for (Context ctx : r.getContext()) {
                if (ctx.getCategory() != null && ctx.getCategory().size() > 0) {
                    for (Category cat : ctx.getCategory()) {
                        if (cat.getConcept() == null || cat.getConcept().size() <= 0) continue;
                        for (Concept cpt : cat.getConcept()) {
                            contexts.add(cpt.getId());
                        }
                    }
                    continue;
                }
                contexts.add(ctx.getId());
            }
        }
        re.setContexts(contexts);
        if (r.getLinks() != null) {
            List projects = r.getLinks().stream().filter(l -> l.getHeader().getRelatedRecordType() == RecordType.project).filter(p -> p.getFunding() != null).filter(p -> p.getFunding().getFunder() != null).filter(p -> p.getFunding().getLevel0() != null).filter(p -> p.getFunding().getFunder().getJurisdiction() != null).map(p -> String.format("info:eu-repo/grantAgreement/%s/%s/%s/%s/%s/%s", StringUtils.defaultIfBlank((CharSequence)p.getFunding().getFunder().getShortname(), (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)p.getFunding().getLevel0().getName(), (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)p.getCode(), (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)p.getFunding().getFunder().getJurisdiction().getCode(), (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)p.getProjectTitle(), (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)p.getAcronym(), (CharSequence)""))).distinct().collect(Collectors.toList());
            re.setLinksToProjects(projects);
        }
        return re;
    }

    private SolrRecordHeader prepareDnetHeader(ResultEntry re) {
        SolrRecordHeader header = new SolrRecordHeader();
        header.setId(re.getOpenaireId());
        header.setOriginalId(Arrays.asList(re.getOriginalId()));
        header.setRecordType(StringUtils.isNotBlank((CharSequence)re.getType()) ? RecordType.valueOf((String)re.getType()) : RecordType.publication);
        header.setStatus(SolrRecordHeader.Status.UNDER_CURATION);
        header.setDeletedbyinference(Boolean.valueOf(false));
        return header;
    }

    private Result prepareDnetResult(ResultEntry re, Provenance collectedFrom, Provenance hostedBy, List<Pid> pids) {
        String code;
        Result r = new Result();
        r.setResulttype((String)StringUtils.firstNonBlank((CharSequence[])new String[]{re.getType(), "publication"}));
        r.setMaintitle(re.getTitle());
        if (re.getAuthors() != null) {
            ArrayList<Author> list = new ArrayList<Author>();
            for (int i = 0; i < re.getAuthors().size(); ++i) {
                list.add(Author.newInstance((String)((String)re.getAuthors().get(i)), null, null, (int)i, Arrays.asList(new Pid[0])));
            }
            r.setAuthor(list);
        }
        if (StringUtils.isNotBlank((CharSequence)re.getDescription())) {
            r.setDescription(Arrays.asList(re.getDescription()));
        }
        if (StringUtils.isNotBlank((CharSequence)re.getLanguage())) {
            code = re.getLanguage();
            String label = this.vocClient.findTermLabel("dnet:languages", re.getLanguage());
            r.setLanguage(Language.newInstance((String)code, (String)label));
        }
        if (StringUtils.isNotBlank((CharSequence)re.getPublisher())) {
            r.setPublisher(re.getPublisher());
        }
        if (StringUtils.isNotBlank((CharSequence)re.getEmbargoEndDate())) {
            r.setEmbargoenddate(re.getEmbargoEndDate());
        }
        if (StringUtils.isNotBlank((CharSequence)re.getAccessRightCode())) {
            code = re.getAccessRightCode();
            String label = this.vocClient.findTermLabel("dnet:access_modes", re.getAccessRightCode());
            r.setBestaccessright(BestAccessRight.newInstance((String)code, (String)label));
        } else {
            r.setBestaccessright(BestAccessRight.newInstance((String)"UNKNOWN", (String)"not available"));
        }
        InstanceWithTypeCode instance = new InstanceWithTypeCode();
        instance.setInstancetype(this.vocClient.findTermLabel("dnet:publication_resource", re.getResourceType()));
        instance.setInstancetypeCode(re.getResourceType());
        instance.setCollectedfrom(collectedFrom);
        instance.setHostedby(hostedBy);
        instance.setPid(pids);
        if (StringUtils.isNotBlank((CharSequence)re.getUrl())) {
            instance.setUrl(Arrays.asList(re.getUrl()));
        }
        if (StringUtils.isNotBlank((CharSequence)re.getAccessRightCode())) {
            String code2 = re.getAccessRightCode();
            String label = this.vocClient.findTermLabel("dnet:access_modes", re.getAccessRightCode());
            instance.setAccessright(AccessRight.newInstance((String)code2, (String)label, null));
        } else {
            instance.setAccessright(AccessRight.newInstance((String)"UNKNOWN", (String)"not available", null));
        }
        r.setInstance(Arrays.asList(instance));
        return r;
    }

    private Provenance prepareProvenance(String dsId) {
        Provenance p = new Provenance();
        p.setDsId(dsId);
        try {
            p.setDsName(this.dsmClient.findDatasource(dsId).getName());
        }
        catch (DirectIndexApiException e) {
            log.warn((Object)("Invalid datasource id: " + dsId), (Throwable)e);
            p.setDsName("UNRECOGNIZED DATASOURCE");
        }
        return p;
    }

    private RelatedRecord prepareDnetProjectLink(String link) {
        ProjectClient.ProjectInfo info = this.projectClient.resolveProjectLink(link);
        if (info == null) {
            return null;
        }
        RelatedRecordHeader head = new RelatedRecordHeader();
        head.setRelatedIdentifier(info.getId());
        head.setRelationType("resultProject");
        head.setRelatedRecordType(RecordType.project);
        head.setRelationClass("isProducedBy");
        head.setRelationProvenance("user:claim");
        head.setTrust("0.9");
        RelatedRecord rel = new RelatedRecord();
        rel.setHeader(head);
        rel.setProjectTitle(info.getTitle());
        rel.setAcronym(info.getAcronym());
        rel.setCode(info.getCode());
        if (StringUtils.isNotBlank((CharSequence)info.getFunderId())) {
            Funding funding = new Funding();
            Funder funder = new Funder();
            funder.setId(info.getFunderId());
            funder.setName(info.getFunderName());
            funder.setShortname(info.getFunderShortName());
            funder.setJurisdiction(Country.newInstance((String)info.getJurisdiction(), (String)this.vocClient.findTermLabel("dnet:countries", info.getJurisdiction())));
            funding.setFunder(funder);
            if (StringUtils.isNotBlank((CharSequence)info.getFundingId())) {
                FundingLevel level = new FundingLevel();
                level.setId(info.getFundingId());
                level.setName(info.getFundingName());
                level.setDescription(info.getFundingName());
                funding.setLevel0(level);
            }
            rel.setFunding(funding);
        }
        return rel;
    }

    private Pid prepareDnetPid(PidEntry pe) {
        Pid p = new Pid();
        p.setValue(pe.getValue());
        p.setTypeCode(pe.getType());
        p.setTypeLabel(this.vocClient.findTermLabel("dnet:pid_types", pe.getType()));
        return p;
    }

    private List<Context> prepareDnetContext(List<String> list) {
        HashMap nodes = new HashMap();
        for (String id : list) {
            String context = id.substring(id.lastIndexOf("/") + 1);
            if (!id.contains("zenodo.org/communities/")) {
                nodes.putAll(this.communityClient.findNodes(id));
                continue;
            }
            for (String path : this.communityClient.findOpenaireCommunities(context)) {
                nodes.putAll(this.communityClient.findNodes(path));
            }
        }
        ArrayList<Context> res = new ArrayList<Context>();
        this.filterContextInfoByLevel(nodes, 0, null).forEach((k, v) -> res.add(Context.newInstance((String)k, (String)v.getLabel(), (String)v.getType(), (List)this.prepareDnetCategories(nodes, k))));
        return res;
    }

    private List<Category> prepareDnetCategories(Map<String, CommunityClient.ContextInfo> nodes, String parent) {
        ArrayList<Category> res = new ArrayList<Category>();
        this.filterContextInfoByLevel(nodes, 1, parent).forEach((k, v) -> {
            Category cat = Category.newInstance((String)k, (String)v.getLabel());
            cat.setConcept(this.prepareDnetConcepts(nodes, k, 2));
            res.add(cat);
        });
        return res;
    }

    private List<Concept> prepareDnetConcepts(Map<String, CommunityClient.ContextInfo> nodes, String parent, int level) {
        ArrayList<Concept> res = new ArrayList<Concept>();
        this.filterContextInfoByLevel(nodes, level, parent).forEach((k, v) -> res.add(Concept.newInstance((String)k, (String)v.getLabel())));
        return res;
    }

    private Map<String, CommunityClient.ContextInfo> filterContextInfoByLevel(Map<String, CommunityClient.ContextInfo> nodes, int level, String parent) {
        return nodes.entrySet().stream().filter(e -> parent == null || ((String)e.getKey()).startsWith(parent + "::")).filter(e -> ((String)e.getKey()).split("::").length == level).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public String calculateOpenaireId(String originalId, String collectedFromId) throws DirectIndexApiException {
        return this.calculateOpenaireId(originalId, this.dsmClient.findDatasource(collectedFromId));
    }

    private String calculateOpenaireId(String originalId, DatasourceEntry collectedFromEntry) {
        return collectedFromEntry.getPrefix() + "::" + DigestUtils.md5Hex((String)originalId);
    }

    public DatasourceManagerClient getDsmClient() {
        return this.dsmClient;
    }

    public void setDsmClient(DatasourceManagerClient dsmClient) {
        this.dsmClient = dsmClient;
    }

    public VocabularyClient getVocClient() {
        return this.vocClient;
    }

    public void setVocClient(VocabularyClient vocClient) {
        this.vocClient = vocClient;
    }

    public CommunityClient getCommunityClient() {
        return this.communityClient;
    }

    public void setCommunityClient(CommunityClient communityClient) {
        this.communityClient = communityClient;
    }

    public ProjectClient getProjectClient() {
        return this.projectClient;
    }

    public void setProjectClient(ProjectClient projectClient) {
        this.projectClient = projectClient;
    }
}

