/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.input;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.app.directindex.input.PidEntry;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultEntry
implements Serializable {
    private static final long serialVersionUID = 3171122009783163319L;
    private String openaireId;
    private String originalId;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    private String title;
    private List<String> authors = new ArrayList();
    private String publisher;
    private String description;
    @Schema(description="ISO Alpha-3 code. E.g. 'eng', 'ita'")
    private String language;
    private List<PidEntry> pids = new ArrayList();
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, allowableValues={"OPEN", "CLOSED", "RESTRICTED", "EMBARGO", "UNKNOWN", "OTHER", "OPEN SOURCE"})
    @JsonProperty(value="accessRightCode")
    @JsonAlias(value={"licenseCode", "licenceCode"})
    private String accessRightCode;
    private String embargoEndDate;
    @Schema(allowableValues={"publication", "dataset", "software", "other"})
    private String type = "publication";
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Use 0001 for articles, 0021 for datasets, 0029 for software. See: http://api.openaire.eu/vocabularies/dnet:publication_resource for all the available resource types.")
    private String resourceType;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    private String url;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Use opendoar___::2659 for Zenodo Publications; re3data_____::r3d100010468 for Zenodo datasets; infrastruct::openaire for OpenAIRE portal.")
    private String collectedFromId;
    private String hostedById;
    @Schema(description="E.g. fet, egi::classification::natsc::math::pure, egi::projects::EMI")
    private List<String> contexts = new ArrayList();
    @Schema(description="E.g. info:eu-repo/grantAgreement/EC/FP7/283595/EU//OpenAIREplus")
    private List<String> linksToProjects = new ArrayList();
    private static final Log log = LogFactory.getLog(ResultEntry.class);

    public String getOpenaireId() {
        return this.openaireId;
    }

    public void setOpenaireId(String openaireId) {
        this.openaireId = openaireId;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<PidEntry> getPids() {
        return this.pids;
    }

    public void setPids(List<PidEntry> pids) {
        this.pids = pids;
    }

    public String getAccessRightCode() {
        return this.accessRightCode;
    }

    public void setAccessRightCode(String accessRightCode) {
        this.accessRightCode = accessRightCode;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCollectedFromId() {
        return this.collectedFromId;
    }

    public void setCollectedFromId(String collectedFromId) {
        this.collectedFromId = collectedFromId;
    }

    public String getHostedById() {
        return this.hostedById;
    }

    public void setHostedById(String hostedById) {
        this.hostedById = hostedById;
    }

    public List<String> getContexts() {
        return this.contexts;
    }

    public void setContexts(List<String> contexts) {
        this.contexts = contexts;
    }

    public List<String> getLinksToProjects() {
        return this.linksToProjects;
    }

    public void setLinksToProjects(List<String> linksToProjects) {
        this.linksToProjects = linksToProjects;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getEmbargoEndDate() {
        return this.embargoEndDate;
    }

    public void setEmbargoEndDate(String embargoEndDate) {
        this.embargoEndDate = embargoEndDate;
    }

    public String toString() {
        return this.toJson();
    }

    public String toJson() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            log.error((Object)"Error converting object in json", (Throwable)e);
            throw new RuntimeException("Error converting object in json", e);
        }
    }
}

