/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.controllers;

import eu.dnetlib.app.directindex.clients.HasCache;
import eu.dnetlib.app.directindex.service.DirectIndexService;
import eu.dnetlib.app.directindex.tasks.ScheduledActions;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin"})
public class AdminController {
    @Autowired
    private ScheduledActions scheduledActions;
    @Autowired
    private DirectIndexService service;
    @Autowired
    private List<HasCache> clients;

    @GetMapping(value={"/info"})
    public Map<String, ?> info() {
        return this.service.getInfo();
    }

    @DeleteMapping(value={"/other-caches"})
    @ResponseStatus(value=HttpStatus.OK)
    public void evictCaches() {
        this.clients.forEach(HasCache::clearCache);
    }

    @GetMapping(value={"/scheduling/{enabled}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void updateScheduling(@PathVariable boolean enabled) {
        this.scheduledActions.setEnabled(enabled);
    }

    @GetMapping(value={"/resetExecutions/all"})
    @ResponseStatus(value=HttpStatus.OK)
    public void resetExecutions() {
        this.service.resetExecutions();
    }

    @GetMapping(value={"/resetExecutions/byDateAfter"})
    @ResponseStatus(value=HttpStatus.OK)
    public void resetExecutions(@RequestParam LocalDateTime datetime) {
        this.service.resetExecutions(datetime);
    }

    @GetMapping(value={"/resetExecutions/byId"})
    @ResponseStatus(value=HttpStatus.OK)
    public void resetExecutions(@RequestParam String id) {
        this.service.resetExecutions(id);
    }

    @DeleteMapping(value={"/records-cache/byDateBefore"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteExpiredRecords(@RequestParam LocalDateTime datetime) {
        this.service.clearDatabase(datetime);
    }

    @DeleteMapping(value={"/records-cache/all"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteExpiredRecords() {
        this.service.clearDatabase();
    }

    @DeleteMapping(value={"/records-cache/byId"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteExpiredRecords(@RequestParam String id) {
        this.service.clearDatabase(id);
    }
}

