/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.clients;

import eu.dnetlib.app.directindex.clients.HasCache;
import eu.dnetlib.app.directindex.clients.VocabularyClient;
import eu.dnetlib.app.directindex.errors.DirectIndexApiException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class VocabularyClient
implements HasCache {
    private static final Log log = LogFactory.getLog(VocabularyClient.class);
    @Value(value="${dnet.directindex.vocabulary.url}")
    private String vocApiUrl;

    @Cacheable(value={"vocabularies"})
    public Map<String, String> findVocabulary(String voc) throws DirectIndexApiException {
        String url = this.vocApiUrl + "/" + voc + ".json";
        RestTemplate rt = new RestTemplate();
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            for (VocTerm term : ((Vocabulary)rt.getForObject(url, Vocabulary.class, new Object[0])).getTerms()) {
                map.put(term.getCode(), term.getEnglishName());
            }
            return map;
        }
        catch (RestClientException e) {
            log.error((Object)("Unable to get vocabulary, url: " + url), (Throwable)e);
            throw new DirectIndexApiException("Unable to get vocabulary, url: " + url, (Throwable)e);
        }
    }

    public String findTermLabel(String vocabulary, String code) {
        try {
            String label = (String)this.findVocabulary(vocabulary).get(code);
            return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{label, code});
        }
        catch (DirectIndexApiException e) {
            log.warn((Object)("Problem accessing vocabulary: " + vocabulary), (Throwable)e);
            return code;
        }
    }

    @CacheEvict(value={"vocabularies"}, allEntries=true)
    public void clearCache() {
    }

    public String getVocApiUrl() {
        return this.vocApiUrl;
    }

    public void setVocApiUrl(String vocApiUrl) {
        this.vocApiUrl = vocApiUrl;
    }
}

