package eu.dnetlib.broker.common.elasticsearch;

import java.util.Map;

import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName = "#{@elasticSearchProperties.getSuggestionNotificationsIndexName()}")
public class SuggestionNotification implements Notification {

	public static final String PREFIX = "ntf-";

	@Id
	private String notificationId;

	@Field(type = FieldType.Keyword)
	private String subscriptionId;

	@Field(type = FieldType.Keyword)
	private String producerId;

	@Field(type = FieldType.Keyword)
	private String eventId;

	@Field(type = FieldType.Keyword)
	private String topic;

	@Field(type = FieldType.Text)
	private String payload;

	@Field(type = FieldType.Nested)
	private Map<String, Object> map;

	@Field(type = FieldType.Long)
	private Long date;

	@Override
	public String getNotificationId() {
		return notificationId;
	}

	public void setNotificationId(final String notificationId) {
		this.notificationId = notificationId;
	}

	@Override
	public String getSubscriptionId() {
		return subscriptionId;
	}

	public void setSubscriptionId(final String subscriptionId) {
		this.subscriptionId = subscriptionId;
	}

	@Override
	public String getProducerId() {
		return producerId;
	}

	public void setProducerId(final String producerId) {
		this.producerId = producerId;
	}

	@Override
	public String getEventId() {
		return eventId;
	}

	public void setEventId(final String eventId) {
		this.eventId = eventId;
	}

	@Override
	public Long getDate() {
		return date;
	}

	public void setDate(final Long date) {
		this.date = date;
	}

	@Override
	public String getTopic() {
		return topic;
	}

	public void setTopic(final String topic) {
		this.topic = topic;
	}

	@Override
	public String getPayload() {
		return payload;
	}

	public void setPayload(final String payload) {
		this.payload = payload;
	}

	@Override
	public Map<String, Object> getMap() {
		return map;
	}

	public void setMap(final Map<String, Object> map) {
		this.map = map;
	}
}
