/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.mdstore;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="mdstore_versions")
public class MDStoreVersion
implements Serializable {
    private static final long serialVersionUID = -4763494442274298339L;
    @Id
    @Column(name="id")
    private String id;
    @Column(name="mdstore")
    private String mdstore;
    @Column(name="writing")
    private boolean writing;
    @Column(name="readcount")
    private int readCount = 0;
    @Column(name="lastupdate")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastUpdate;
    @Column(name="size")
    private long size = 0L;
    @Column(name="hdfs_path")
    private String hdfsPath;

    public static MDStoreVersion newInstance(String mdId, boolean writing, String hdfsBasePath) {
        MDStoreVersion v = new MDStoreVersion();
        String versionId = mdId + "-" + new Date().getTime();
        v.setId(versionId);
        v.setMdstore(mdId);
        v.setLastUpdate(null);
        v.setWriting(writing);
        v.setReadCount(0);
        v.setSize(0L);
        v.setHdfsPath(String.format("%s/%s/%s", hdfsBasePath, mdId, versionId));
        return v;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMdstore() {
        return this.mdstore;
    }

    public void setMdstore(String mdstore) {
        this.mdstore = mdstore;
    }

    public boolean isWriting() {
        return this.writing;
    }

    public void setWriting(boolean writing) {
        this.writing = writing;
    }

    public int getReadCount() {
        return this.readCount;
    }

    public void setReadCount(int readCount) {
        this.readCount = readCount;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getHdfsPath() {
        return this.hdfsPath;
    }

    public void setHdfsPath(String hdfsPath) {
        this.hdfsPath = hdfsPath;
    }

    public String toString() {
        return String.format("MDStoreVersion [id=%s, mdstore=%s, writing=%s, readCount=%s, lastUpdate=%s, size=%s, hdfsPath=%s]", this.id, this.mdstore, this.writing, this.readCount, this.lastUpdate, this.size, this.hdfsPath);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MDStoreVersion)) {
            return false;
        }
        MDStoreVersion other = (MDStoreVersion)obj;
        return Objects.equals(this.id, other.id);
    }
}

