/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.controllers;

import eu.dnetlib.broker.common.elasticsearch.AlertNotificationRepository;
import eu.dnetlib.broker.common.elasticsearch.SuggestionNotificationRepository;
import eu.dnetlib.broker.common.subscriptions.Subscription;
import eu.dnetlib.broker.common.subscriptions.SubscriptionRepository;
import eu.dnetlib.broker.controllers.InSubscription;
import eu.dnetlib.common.controller.AbstractDnetController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/subscriptions"})
@Tag(name="Subscriptions")
public class SubscriptionsController
extends AbstractDnetController {
    @Autowired
    private SubscriptionRepository subscriptionRepo;
    @Autowired
    private SuggestionNotificationRepository suggestionNotificationRepository;
    @Autowired
    private AlertNotificationRepository alertNotificationRepository;
    public static final Predicate<String> verifyTopic = Pattern.compile("^([a-zA-Z0-9._-]+(\\/[a-zA-Z0-9._-]+)+)|\\*$").asPredicate();
    public static final Predicate<String> verifyEmail = email -> {
        try {
            new InternetAddress(email).validate();
            return true;
        }
        catch (AddressException e) {
            return false;
        }
    };

    @Operation(summary="Return the list of subscriptions")
    @GetMapping(value={""})
    public Iterable<Subscription> listSubscriptions() {
        return this.subscriptionRepo.findAll();
    }

    @Operation(summary="Return a subscription by ID")
    @GetMapping(value={"/{id}"})
    public Subscription getSubscription(@PathVariable String id) {
        return (Subscription)this.subscriptionRepo.findById((Object)id).get();
    }

    @Operation(summary="Delete a subscription by ID and its notifications")
    @DeleteMapping(value={"/{id}"})
    public void deleteSubscription(@PathVariable String id) {
        Subscription s = (Subscription)this.subscriptionRepo.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Subscription not found"));
        if (s.getTopic().toLowerCase().startsWith("alert")) {
            this.alertNotificationRepository.deleteBySubscriptionId(id);
        } else {
            this.suggestionNotificationRepository.deleteBySubscriptionId(id);
        }
        this.subscriptionRepo.delete((Object)s);
    }

    @Operation(summary="Perform a new subscription")
    @PostMapping(value={""})
    public Subscription registerSubscription(@RequestBody InSubscription inSub) {
        Subscription sub = inSub.asSubscription();
        this.subscriptionRepo.save((Object)sub);
        return sub;
    }

    @Operation(summary="Reset the last notification date")
    @DeleteMapping(value={"/{id}/date"})
    public void deleteNotificationDate(@PathVariable String id) {
        Subscription s = (Subscription)this.subscriptionRepo.findById((Object)id).get();
        s.setLastNotificationDate(null);
        this.subscriptionRepo.save((Object)s);
    }

    @Operation(summary="Reset all the last notification dates")
    @GetMapping(value={"/resetLastNotificationDates"})
    public void deleteAllNotificationDates() {
        for (Subscription s : this.subscriptionRepo.findAll()) {
            s.setLastNotificationDate(null);
            this.subscriptionRepo.save((Object)s);
        }
    }
}

