package eu.dnetlib.broker.openaire;

public class BrowseEntry implements Comparable<BrowseEntry> {

	public final String value;
	public final String displayValue;
	public final long size;

	public BrowseEntry(final String value, final long size) {
		this(value, value, size);
	}

	public BrowseEntry(final String value, final String displayValue, final long size) {
		this.value = value;
		this.displayValue = displayValue;
		this.size = size;
	}

	public String getValue() {
		return value;
	}

	public String getDisplayValue() {
		return displayValue;
	}

	public long getSize() {
		return size;
	}

	@Override
	public int compareTo(final BrowseEntry bv) {
		return Long.compare(getSize(), bv.getSize());
	}

}
