/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.events.output;

import com.google.common.base.Splitter;
import eu.dnetlib.broker.common.elasticsearch.Event;
import eu.dnetlib.broker.common.subscriptions.NotificationMode;
import eu.dnetlib.broker.common.subscriptions.Subscription;
import eu.dnetlib.broker.events.output.AbstractNotificationDispatcher;
import eu.dnetlib.broker.properties.EmailProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class EmailDispatcher
extends AbstractNotificationDispatcher<Message> {
    @Autowired
    private EmailProperties props;
    @Value(value="${lbs.mail.message.template}")
    private Resource emailTemplate;
    @Value(value="${lbs.mail.message.template.dashboard.baseUrl}")
    private String dashboardBaseUrl;
    @Value(value="${lbs.mail.message.template.dashboard.helpdesk}")
    private String helpdesk;
    @Value(value="${lbs.mail.message.template.publicApi}")
    private String publicApi;
    public static final int MAX_NUMBER_OF_EVENTS = 20;
    private static final Log log = LogFactory.getLog(EmailDispatcher.class);

    protected Message prepareAction(Subscription subscription, Event ... events) throws Exception {
        if (subscription == null || StringUtils.isBlank((CharSequence)subscription.getSubscriber())) {
            log.warn((Object)"Invalid subscription");
            throw new IllegalArgumentException("Invalid subscription");
        }
        if (events.length == 0) {
            log.warn((Object)"Event list is empty");
        }
        String content = this.generateMailContent(subscription, null, events);
        return this.prepareMimeMessage(subscription, content);
    }

    protected Message prepareAction(Subscription subscription, Map<String, Object> params) throws Exception {
        if (subscription == null || StringUtils.isBlank((CharSequence)subscription.getSubscriber())) {
            log.warn((Object)"Invalid subscription");
            throw new IllegalArgumentException("Invalid subscription");
        }
        String content = this.generateMailContent(subscription, params, new Event[0]);
        return this.prepareMimeMessage(subscription, content);
    }

    protected String generateMailContent(Subscription subscription, Map<String, Object> params, Event ... events) throws IOException {
        StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)this.emailTemplate.getInputStream(), (Charset)StandardCharsets.UTF_8));
        st.setAttribute("sub", (Object)subscription);
        st.setAttribute("total", events.length);
        st.setAttribute("max", 20);
        st.setAttribute("dashboardBaseUrl", (Object)this.dashboardBaseUrl.trim());
        st.setAttribute("publicApi", (Object)this.publicApi.trim());
        st.setAttribute("helpdesk", (Object)this.helpdesk.trim());
        if (events.length > 20) {
            st.setAttribute("events", (Object)Arrays.copyOfRange(events, 0, 20));
        } else {
            st.setAttribute("events", (Object)events);
        }
        if (params != null) {
            params.entrySet().forEach(e -> st.setAttribute((String)e.getKey(), e.getValue()));
        }
        return st.toString();
    }

    private Message prepareMimeMessage(Subscription subscription, String content) throws MessagingException, UnsupportedEncodingException, AddressException {
        Session session = Session.getInstance((Properties)this.obtainProperties(), (Authenticator)this.obtainAuthenticator());
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)new InternetAddress(this.props.getFrom(), this.props.getFromName()));
        mimeMessage.setSubject("Notification for topic: " + subscription.getTopic());
        mimeMessage.setContent((Object)content, "text/html; charset=utf-8");
        mimeMessage.setSentDate(new Date());
        mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(subscription.getSubscriber()));
        if (StringUtils.isNotBlank((CharSequence)this.props.getCc())) {
            for (String aCC : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)this.props.getCc())) {
                mimeMessage.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(aCC));
            }
        }
        log.info((Object)("Created mail, to: " + subscription.getSubscriber()));
        return mimeMessage;
    }

    protected void performAction(Message message) throws Exception {
        log.info((Object)("Sending mail to " + Arrays.toString(message.getAllRecipients()) + "..."));
        Transport.send((Message)message);
        log.info((Object)"...sent");
    }

    private Properties obtainProperties() {
        Properties p = new Properties();
        p.put("mail.transport.protocol", "smtp");
        p.put("mail.smtp.host", this.props.getSmtpHost());
        p.put("mail.smtp.port", (Object)this.props.getSmtpPort());
        p.put("mail.smtp.auth", Boolean.toString(StringUtils.isNotBlank((CharSequence)this.props.getSmtpUser())));
        return p;
    }

    private Authenticator obtainAuthenticator() {
        if (StringUtils.isBlank((CharSequence)this.props.getSmtpUser())) {
            return null;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public NotificationMode getMode() {
        return NotificationMode.EMAIL;
    }

    protected Resource getEmailTemplate() {
        return this.emailTemplate;
    }

    protected void setEmailTemplate(Resource emailTemplate) {
        this.emailTemplate = emailTemplate;
    }

    protected String getDashboardBaseUrl() {
        return this.dashboardBaseUrl;
    }

    protected void setDashboardBaseUrl(String dashboardBaseUrl) {
        this.dashboardBaseUrl = dashboardBaseUrl;
    }

    protected String getHelpdesk() {
        return this.helpdesk;
    }

    protected void setHelpdesk(String helpdesk) {
        this.helpdesk = helpdesk;
    }

    protected String getPublicApi() {
        return this.publicApi;
    }

    protected void setPublicApi(String publicApi) {
        this.publicApi = publicApi;
    }

    static /* synthetic */ EmailProperties access$000(EmailDispatcher x0) {
        return x0.props;
    }
}

