/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.controllers;

import eu.dnetlib.broker.common.controllers.AbstractLbsController;
import eu.dnetlib.broker.common.topics.TopicType;
import eu.dnetlib.broker.common.topics.TopicTypeRepository;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/topic-types"})
@Api(tags={"Topic Types"})
public class TopicsController
extends AbstractLbsController {
    @Autowired
    private TopicTypeRepository topicTypeRepo;
    private final Predicate<String> verifyExpression = Pattern.compile("^([a-zA-Z0-9._-]+|<[a-zA-Z0-9._-]+>)(\\/([a-zA-Z0-9._-]+|<[a-zA-Z0-9._-]+>))+$").asPredicate();

    @ApiOperation(value="Return the list of topic types")
    @GetMapping(value={""})
    public Iterable<TopicType> listTopicTypes() {
        return this.topicTypeRepo.findAll();
    }

    @ApiOperation(value="Register a new topic type")
    @PostMapping(value={"/add"})
    public TopicType registerTopicType(@RequestParam String name, @RequestParam String expression, @RequestParam String producerId, @RequestParam String mapKeys) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name is empty");
        }
        if (StringUtils.isBlank((CharSequence)expression)) {
            throw new IllegalArgumentException("expression is empty");
        }
        if (!this.verifyExpression.test(expression)) {
            throw new IllegalArgumentException("Invalid expression: " + expression);
        }
        String id = "tt-" + UUID.randomUUID();
        TopicType type = new TopicType(id, name, expression, producerId, mapKeys);
        this.topicTypeRepo.save((Object)type);
        return type;
    }

    @ApiOperation(value="Return a topic type by ID")
    @GetMapping(value={"/{id}"})
    public TopicType getTopicType(@PathVariable String id) {
        return (TopicType)this.topicTypeRepo.findById((Object)id).get();
    }

    @ApiOperation(value="Delete a topic type by ID")
    @DeleteMapping(value={"/{id}"})
    public List<String> deleteTopicType(@PathVariable String id) {
        this.topicTypeRepo.deleteById((Object)id);
        return Arrays.asList("Done.");
    }

    @ApiOperation(value="Delete all topic types")
    @DeleteMapping(value={""})
    public Map<String, Object> clearTopicTypes() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        this.topicTypeRepo.deleteAll();
        res.put("deleted", "all");
        return res;
    }
}

