/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.bioschemas.api.scraper;

import eu.dnetlib.bioschemas.api.crawl.CrawlRecord;
import eu.dnetlib.bioschemas.api.scraper.BMUSEScraper;
import eu.dnetlib.bioschemas.api.scraper.ScrapeState;
import eu.dnetlib.bioschemas.api.utils.CompressorUtil;
import hwu.elixir.scrape.exceptions.CannotWriteException;
import hwu.elixir.scrape.exceptions.FourZeroFourException;
import hwu.elixir.scrape.exceptions.JsonLDInspectionException;
import hwu.elixir.scrape.exceptions.MissingMarkupException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScrapeThread
extends Thread {
    private ScrapeState scrapeState;
    private BMUSEScraper process;
    private int waitTime;
    private boolean fileWritten = true;
    private int scrapeVersion = 1;
    private static Logger logger = LoggerFactory.getLogger(ScrapeThread.class);

    public ScrapeThread(BMUSEScraper scraper, ScrapeState scrapeState, int waitTime, int contextVersion) {
        this.scrapeState = scrapeState;
        this.process = scraper;
        this.waitTime = waitTime;
        this.scrapeVersion = contextVersion;
    }

    @Override
    public void run() {
        CrawlRecord record;
        while (this.scrapeState.pagesLeftToScrape() && (record = this.scrapeState.getURLToProcess()) != null) {
            record.setContext("https://bioschemas.org/crawl/" + this.scrapeVersion + "/" + record.getId());
            record.setDateScraped(new Date());
            try {
                String nquads = this.process.getNQUADSFromUrl(record.getUrl(), Boolean.valueOf(true));
                logger.info("downloaded " + record.getUrl() + " leftToScrape:" + this.scrapeState.getNumberPagesLeftToScrape());
                record.setNquads(CompressorUtil.compressValue((String)nquads));
                if (!nquads.isEmpty()) {
                    this.scrapeState.addSuccessfulScrapedURL(record);
                } else {
                    this.scrapeState.addFailedToScrapeURL(record);
                }
            }
            catch (FourZeroFourException fourZeroFourException) {
                this.scrapeState.setStatusTo404(record);
                this.fileWritten = false;
            }
            catch (JsonLDInspectionException je) {
                this.scrapeState.setStatusToHumanInspection(record);
                this.fileWritten = false;
            }
            catch (CannotWriteException cannotWrite) {
                logger.error("Caught cannot read file, setting worked to false!");
                this.fileWritten = false;
                this.scrapeState.addFailedToScrapeURL(record);
                return;
            }
            catch (MissingMarkupException e) {
                logger.error("Cannot obtain markup from " + record.getUrl() + ".");
                this.fileWritten = false;
                this.scrapeState.addFailedToScrapeURL(record);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                ScrapeThread.sleep((long)(100 * this.waitTime));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.process.shutdown();
    }

    public boolean isFileWritten() {
        return this.fileWritten;
    }
}

