/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.primer;

import eu.dnetlib.iis.primer.ImportLinkFileChecker;
import eu.dnetlib.iis.primer.Resolver;
import eu.dnetlib.iis.primer.UnresolvableResourceException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ImportLinkReader {
    private final Logger log = Logger.getLogger(ImportLinkReader.class);
    private BufferedReader reader;

    public ImportLinkReader(InputStream is) {
        this.reader = new BufferedReader(new InputStreamReader(is));
    }

    public void performResolution(File workingDir, Resolver resolver) throws IOException, UnresolvableResourceException, ParseException {
        String line;
        this.log.debug((Object)("Performing resolution in " + workingDir));
        int lineNo = 0;
        ImportLinkFileChecker.dropHeader(this.reader);
        while ((line = this.reader.readLine()) != null) {
            ++lineNo;
            if (StringUtils.isBlank((String)line)) continue;
            int COLUMN_COUNT = 3;
            String[] splits = line.split("\\s+", 3);
            if (splits.length < 3) {
                throw new ParseException("Malformed line in " + workingDir + File.separator + "import.txt file", lineNo);
            }
            resolver.resolve(new File(workingDir, splits[0]), splits[1], splits[2]);
        }
    }
}

