/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.utils.contents;

import eu.dnetlib.iis.core.java.io.DataStore;
import eu.dnetlib.iis.core.java.io.FileSystemPath;
import eu.dnetlib.iis.metadataextraction.schemas.DocumentText;
import eu.dnetlib.iis.utils.contents.Utils;
import eu.dnetlib.iis.utils.contents.WoSCSVReader;
import eu.dnetlib.iis.utils.contents.WoSRecord;
import eu.dnetlib.iis.utils.contents.schemas.wos.WoS2OpenAIRE;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;

public class WoSConverter {
    private final File input;
    private final File output;
    private final File outputMappingDir;

    public static void main(String[] args) throws IOException {
        WoSConverter converter = WoSConverter.parse(args);
        converter.run();
    }

    private static WoSConverter parse(String[] args) throws IOException {
        if (args.length != 3) {
            WoSConverter.parseError("This program converts Web of Science metadata records stored in TSV (tab separated values) file into a data store. Two arguments should be given: 1) \"input file\" and 2) output dir for DocumentText data store; 3) output dir for data store with WoS and OpenAIRE IDs outputMappingDir");
        }
        String input = args[0];
        String output = args[1];
        String outputMappingDir = args[2];
        return new WoSConverter(new File(input), new File(output), new File(outputMappingDir));
    }

    private static void parseError(String error) {
        System.err.println("ERROR while parsing command line: " + error);
        System.exit(1);
    }

    public WoSConverter(File input, File output, File mapping) {
        this.input = input;
        this.output = output;
        this.outputMappingDir = mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        WoSCSVReader reader = new WoSCSVReader(this.input);
        DataFileWriter writer = DataStore.create((FileSystemPath)new FileSystemPath(this.output), (Schema)DocumentText.SCHEMA$);
        DataFileWriter mappingWriter = DataStore.create((FileSystemPath)new FileSystemPath(this.outputMappingDir), (Schema)WoS2OpenAIRE.SCHEMA$);
        try {
            DocumentText docText = new DocumentText();
            WoS2OpenAIRE idMap = new WoS2OpenAIRE();
            HashSet<String> alreadyProcessedWOSIds = new HashSet<String>();
            while (reader.hasNext()) {
                WoSRecord record = reader.next();
                String wosId = record.id;
                if (alreadyProcessedWOSIds.contains(wosId)) continue;
                alreadyProcessedWOSIds.add(wosId);
                String openAIREId = WoSConverter.convertToOpenAIREId(wosId);
                idMap.setWosId(wosId);
                idMap.setOpenAIREId(openAIREId);
                mappingWriter.append((Object)idMap);
                docText.setId((CharSequence)openAIREId);
                docText.setText((CharSequence)record.fundingText);
                writer.append((Object)docText);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (mappingWriter != null) {
                mappingWriter.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static String convertToOpenAIREId(String wosId) {
        return Utils.convertToOpenAIREId("webcrawl____::", "", wosId);
    }
}

