/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.utils.contents;

import eu.dnetlib.iis.core.java.io.CloseableIterator;
import eu.dnetlib.iis.utils.contents.WoSRecord;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;

class WoSCSVReader
implements CloseableIterator<WoSRecord> {
    private static final String idColumnName = "UT";
    private static final String textColumnName = "FX";
    private final LineIterator iterator;
    private int lineNo = 0;
    private int idColumnIndex;
    private int textColumnIndex;
    private int columnsCount = -1;

    public WoSCSVReader(File file) {
        try {
            this.iterator = FileUtils.lineIterator((File)file, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.lineNo = 0;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public WoSRecord next() {
        ++this.lineNo;
        try {
            String line = this.iterator.nextLine();
            String[] rawFields = line.split("\t");
            if (this.lineNo == 1) {
                this.idColumnIndex = WoSCSVReader.getFieldIndex(rawFields, idColumnName);
                this.textColumnIndex = WoSCSVReader.getFieldIndex(rawFields, textColumnName);
                this.columnsCount = rawFields.length;
                return this.next();
            }
            String[] fields = WoSCSVReader.fixNumberOfColumns(rawFields, this.columnsCount);
            String id = fields[this.idColumnIndex];
            if (id == null) {
                System.err.println("Skipping line " + this.lineNo + " since the field " + "corresponding to ID (with column name " + "\"" + idColumnName + "\") is empty");
                return this.next();
            }
            return new WoSRecord(id, fields[this.textColumnIndex]);
        }
        catch (Exception ex) {
            throw new RuntimeException("ERROR in line " + this.lineNo + " of the " + "read file: " + ex, ex);
        }
    }

    private static String[] fixNumberOfColumns(String[] elements, int expectedColumnsCount) {
        if (elements.length == expectedColumnsCount) {
            return elements;
        }
        if (elements.length < expectedColumnsCount) {
            return Arrays.copyOf(elements, expectedColumnsCount);
        }
        throw new RuntimeException(String.format("The line contains %d columns but only %d were expected", elements.length, expectedColumnsCount));
    }

    private static int getFieldIndex(String[] fields, String value) {
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].equals(value)) continue;
            return i;
        }
        throw new RuntimeException(String.format("Field \"%s\" not found ", value));
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        if (this.iterator != null) {
            this.iterator.close();
        }
    }
}

