
-- query performed by IIS to bulk load project details
DROP MATERIALIZED VIEW project_details;
CREATE MATERIALIZED VIEW project_details AS (
		SELECT  p.id                         AS projectid,
	          p.acronym                    AS acronym,
	          p.code                       AS code,
	          p.optional1                  AS optional1,
	          p.optional2                  AS optional2,
						p.jsonextrainfo              AS jsonextrainfo,
	          array_agg(fp.path)           AS fundingpath
		FROM projects p
	       LEFT OUTER JOIN project_fundingpath pf ON (pf.project = p.id)
	       LEFT OUTER JOIN fundingpaths fp ON (fp.id = pf.funding)
		GROUP BY p.id
);

-- used to serve queries from api tsv exporter
DROP MATERIALIZED VIEW projects_tsv;
CREATE MATERIALIZED VIEW projects_tsv AS (
		SELECT
			pr.code,
			pr.acronym,
			pr.title,
			pr.call_identifier,
			pr.startdate,
			pr.enddate,
			pr.ec_sc39,
			pr.oa_mandate_for_publications,
			pr.ec_article29_3,
			f.id AS fundingpathid,
			f.description,
			org.legalname,
			org.countryclass,
			CASE WHEN po.participantnumber = 1 THEN 'coordinator' ELSE '' END AS role,
			pe.firstname,
			pe.secondnames,
			pe.email
		FROM projects pr
			LEFT OUTER JOIN project_organization po ON (pr.id = po.project)
			LEFT OUTER JOIN persons pe ON (po.contactperson=pe.id)
			LEFT OUTER JOIN organizations org ON (po.resporganization = org.id)
			LEFT OUTER JOIN project_fundingpath pf ON (pr.id = pf.project)
			LEFT OUTER JOIN fundingpaths f ON (pf.funding = f.id)
		ORDER BY pr.acronym);
CREATE INDEX projects_tsv_fundingpathid_idx ON projects_tsv (fundingpathid);
CREATE INDEX projects_tsv_ec_article29_3_idx ON projects_tsv (ec_article29_3);

-- used to serve queries from dspace and eprints exporter
DROP MATERIALIZED VIEW projects_api;
CREATE MATERIALIZED VIEW projects_api AS (
		SELECT
			org.legalshortname  AS funder,
			fp.jurisdiction     AS jurisdiction,
			p.acronym           AS acronym,
			p.title             AS title,
			p.code              AS code,
			p.startdate         AS startdate,
			p.enddate           AS enddate,
			fp.id               AS fundingpathid
		FROM projects p
			LEFT OUTER JOIN project_fundingpath pfp  ON (p.id = pfp.project)
			LEFT OUTER JOIN fundingpaths fp ON (pfp.funding = fp.id)
			LEFT OUTER JOIN organizations org ON (org.id = fp.funder));
CREATE INDEX projects_api_fundingpathid_idx ON projects_api (fundingpathid);
CREATE INDEX projects_api_startdate_idx ON projects_api (startdate);
CREATE INDEX projects_api_enddate_idx ON projects_api (enddate);

GRANT SELECT ON projects_api TO dnetapi;
GRANT SELECT ON projects_tsv TO dnetapi;
GRANT SELECT ON project_details TO dnetapi;
