SELECT 	 o.id										as organizationid, 
		 o.legalshortname							as legalshortname,
		 o.legalname                                as legalname,
		 o.websiteurl                               as websiteurl,
		 o.logourl                                  as logourl,
		 o.ec_legalbody                             as eclegalbody,
		 o.ec_legalperson                           as eclegalperson,
		 o.ec_nonprofit                             as ecnonprofit,
		 o.ec_researchorganization                  as ecresearchorganization,
		 o.ec_highereducation                       as echighereducation,
		 o.ec_internationalorganizationeurinterests as ecinternationalorganizationeurinterests,
		 o.ec_internationalorganization             as ecinternationalorganization,
		 o.ec_enterprise                            as ecenterprise,
		 o.ec_smevalidated                          as ecsmevalidated,
		 o.ec_nutscode                              as ecnutscode,
		 o.dateofcollection							as dateofcollection,
		 o.inferred                                 as inferred,
		 o.deletedbyinference                       as deletedbyinference,
		 o.trust                                    as trust,
		 o.inferenceprovenance                      as inferenceprovenance,
		 dc.id			                            as collectedfromid,
		 dc.officialname                            as collectedfromname,
		 
		 cc.code || '@@@' || cc.name || '@@@' || cs.code || '@@@' || cs.name	as country,
		 pac.code || '@@@' || pac.name || '@@@' || pas.code || '@@@' || pas.name	as provenanceaction,
		 
		 array_agg(DISTINCT i.pid || '###' || i.issuertypeclass)	as pid

FROM organizations o
	left outer join class cc on (cc.code = o.countryclass)	
	left outer join scheme cs on (cs.code = o.countryscheme)
	
	left outer join class pac on (pac.code = o.provenanceactionclass)	
	left outer join scheme pas on (pas.code = o.provenanceactionscheme)		
	
	left outer join organizationpids op on (op.organization = o.id)
	left outer join identities i on (i.pid = op.pid)
	
	left outer join datasources dc on (dc.id = o.collectedfrom)
 
GROUP BY
		 o.id, 
		 o.legalshortname,
		 o.legalname,
		 o.websiteurl,
		 o.logourl,
		 o.ec_legalbody,
		 o.ec_legalperson,
		 o.ec_nonprofit,
		 o.ec_researchorganization,
		 o.ec_highereducation,
		 o.ec_internationalorganizationeurinterests,
		 o.ec_internationalorganization,
		 o.ec_enterprise,
		 o.ec_smevalidated,
		 o.ec_nutscode,
		 o.dateofcollection,
		 o.inferred,
		 o.deletedbyinference,
		 o.trust,
		 o.inferenceprovenance,
		 dc.id, 
		 dc.officialname, 
		 cc.code, cc.name, cs.code, cs.name,
		 pac.code, pac.name, pas.code, pas.name
		