<NODE name="COLLECT" isStart="true" type="FetchMDStoreRecords">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("orig_id")$</PARAM>
		<PARAM required="true" type="string" name="mdFormat" managedBy="system">$params.("orig_format")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">collected_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="FIND_CONTEXTS"/>
	</ARCS>
</NODE>

<NODE name="FIND_CONTEXTS" type="ApplyXslt">
	<DESCRIPTION>Find project contexts</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="xsltClasspath" managedBy="user" function="listFiles('/eu/dnetlib/msro/openaireplus/workflows/repo-hi/entityreg-contexts/xsl','xsl')"></PARAM>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">collected_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">contexts_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="PROCESS_CONTEXTS"/>
	</ARCS>
</NODE>

<NODE name="PROCESS_CONTEXTS" type="ProcessContexts">
	<DESCRIPTION>Process project contexts</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">contexts_epr</PARAM>
		<PARAM required="true" type="string" name="contextObj" managedBy="system">contexts</PARAM>
		<PARAM required="true" type="string" name="contextId" managedBy="user"></PARAM>
		<PARAM required="true" type="string" name="contextLabel" managedBy="user"></PARAM>
		<PARAM required="true" type="string" name="contextType" managedBy="user">funding</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="PREPARE_DB_ENTRIES"/>
	</ARCS>
</NODE>

<NODE name="PREPARE_DB_ENTRIES" type="PrepareContextDbEntries">
	<DESCRIPTION>Prepare the DB entries</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">db_epr</PARAM>
		<PARAM required="true" type="string" name="contextObj" managedBy="system">contexts</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="UPDATE_DB"/>
	</ARCS>
</NODE>

<NODE name="UPDATE_DB" type="UpdateOpenaireDb">
	<DESCRIPTION>Update Db</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">db_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="SAVE_PROFILE"/>
	</ARCS>
</NODE>

<NODE name="SAVE_PROFILE" type="SaveContextProfile">
	<DESCRIPTION>Save the Context Profile</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="contextObj" managedBy="system">contexts</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>
