<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:fn="http://www.w3.org/2005/xpath-functions">

	<xsl:param name="parentDatasourceId" />
	<xsl:param name="funderAcronym" />

	<xsl:template name="formatDate">
		<xsl:param name="datename" />
		<xsl:param name="datevalue" />
		<xsl:choose>
			<xsl:when test="string-length($datevalue) = 4 and $datename = 'startdate'">
				<FIELD name="{$datename}" type="date" format="yyyy-MM-dd"><xsl:value-of select="concat($datevalue, '-01-01')" /></FIELD>
			</xsl:when>
			<xsl:when test="string-length($datevalue) = 4 and $datename = 'enddate'">
				<FIELD name="{$datename}" type="date" format="yyyy-MM-dd"><xsl:value-of select="concat($datevalue, '-12-31')" /></FIELD>
			</xsl:when>
			<xsl:when test="string-length($datevalue) = 10">
				<FIELD name="{$datename}" type="date" format="yyyy-MM-dd"><xsl:value-of select="$datevalue" /></FIELD>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:variable name="namespacePrefix" select="string('irb_hr______')" />

	<xsl:template match="/">
		<record xmlns:dr="http://www.driver-repository.eu/namespace/dr"
		        xmlns:dri="http://www.driver-repository.eu/namespace/dri"
		        xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
		        xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/">
			<xsl:if test="contains(//column[@name='FUNDER_NAME'], $funderAcronym)">

				<xsl:variable name="fundingId" select="normalize-space(concat($namespacePrefix, '::', $funderAcronym, '::fundingStream'))" />
				<xsl:copy-of select=".//*[local-name()='header']"/>
				<metadata>
					<ROWS>
						<xsl:variable name="projectId" select="concat($namespacePrefix, '::', normalize-space(//column[@name = 'PROJECT_IDENTIFIER']))"/>
						<xsl:variable name="projectTitle">
								<xsl:choose>
										<xsl:when test="//column[@name = 'PROJECT_TITLE'] != ''"><xsl:value-of select="//column[@name = 'PROJECT_TITLE']" /></xsl:when>
										<xsl:otherwise><xsl:value-of select="//column[@name = 'PROJECT_IDENTIFIER']" /></xsl:otherwise>
								</xsl:choose>
						</xsl:variable>

						<ROW table="projects">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="id"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="code"><xsl:value-of select="//column[@name = 'PROJECT_IDENTIFIER']" /></FIELD>
							<FIELD name="title"><xsl:value-of select="$projectTitle" /></FIELD>
							<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
							<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							<xsl:call-template name="formatDate">
								<xsl:with-param name="datename">startdate</xsl:with-param>
								<xsl:with-param name="datevalue" select="//column[@name = 'START_DATE']"></xsl:with-param>
							</xsl:call-template>
							<xsl:call-template name="formatDate">
								<xsl:with-param name="datename">enddate</xsl:with-param>
								<xsl:with-param name="datevalue" select="//column[@name = 'END_DATE']"></xsl:with-param>
							</xsl:call-template>
						</ROW>
						<xsl:if test="string-length(normalize-space(//column[@name = 'ORGANIZATION_INVOLVED'])) &gt; 0">
							<xsl:variable name="organizationId" select="concat($namespacePrefix, '::', normalize-space(//column[@name = 'ORGANIZATION_INVOLVED']))" />
							<ROW table="organizations">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$organizationId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$organizationId" /></FIELD>
								<FIELD name="legalname"><xsl:value-of select="//column[@name = 'ORGANIZATION_INVOLVED']" /></FIELD>
								<FIELD name="countryclass">HR</FIELD>
								<FIELD name="countryscheme">dnet:countries</FIELD>
								<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
								<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
								<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							</ROW>
							<ROW table="project_organization">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select='concat($projectId, "@@", $organizationId)' /></FIELD>
								<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
								<FIELD name="resporganization"><xsl:value-of select="$organizationId" /></FIELD>
								<FIELD name="participantnumber" type="int">1</FIELD>
								<FIELD name="semanticclass">coordinator</FIELD>
								<FIELD name="semanticscheme">dnet:project_organization_relations</FIELD>
							</ROW>
						</xsl:if>
						<xsl:if test="string-length($fundingId) &gt; 0">
							<ROW table="project_fundingpath">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($fundingId, '@@', $projectId)" /></FIELD>
								<FIELD name="funding"><xsl:value-of select="$fundingId" /></FIELD>
								<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
								<xsl:call-template name="formatDate">
									<xsl:with-param name="datename">startdate</xsl:with-param>
									<xsl:with-param name="datevalue" select="//column[@name = 'START_DATE']"></xsl:with-param>
								</xsl:call-template>
								<xsl:call-template name="formatDate">
									<xsl:with-param name="datename">enddate</xsl:with-param>
									<xsl:with-param name="datevalue" select="//column[@name = 'END_DATE']"></xsl:with-param>
								</xsl:call-template>
							</ROW>
						</xsl:if>
					</ROWS>
				</metadata>

			</xsl:if>
		</record>
	</xsl:template>
</xsl:stylesheet>
