<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="SELECT_MODE"/>
	</ARCS>
</NODE>

 <NODE name="SELECT_MODE" type="Selection">
	<DESCRIPTION>Choose collection mode</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="selection" managedBy="user" function="validValues(['REFRESH','INCREMENTAL'])">REFRESH</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="COLLECT_REFRESH" name="REFRESH" />
		<ARC to="PREPARE_INCREMENTAL" name="INCREMENTAL" />
	</ARCS>
</NODE>

<NODE name="COLLECT_REFRESH" type="CollectRecords">
	<DESCRIPTION>Start Harvesting</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">collected_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="MD_BUILDER_REFRESH"/>
	</ARCS>
</NODE>

<NODE name="MD_BUILDER_REFRESH" type="MdBuilder">
	<DESCRIPTION>Prepare mdstore records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">collected_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">store_epr</PARAM>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="STORE_REFRESH"/>
	</ARCS>
</NODE>