/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby;

import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.database.rmi.DatabaseException;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby.HostedByCounters;
import eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby.HostedByEntry;
import eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby.PatchHostedBy;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;

public class PatchHostedByJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PatchHostedByJobNode.class);
    private String inputEprParam;
    private String outputEprParam;
    @Value(value="${dnet.openaire.db.name}")
    private String dbName;
    private String countersParam;
    private String hostedbyMapTable;
    private String xpathEntry;
    private String overrideDataSourceId;
    private String keyTypeFilter;
    @Resource
    private UniqueServiceLocator serviceLocator;
    private MappedResultSetFactory mappedResultSetFactory;
    private ResultSetClientFactory resultSetClientFactory;

    protected String execute(NodeToken token) throws Exception {
        W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(this.inputEprParam));
        HostedByCounters counters = new HostedByCounters();
        String datasourceId = StringUtils.isEmpty((String)this.overrideDataSourceId) ? token.getEnv().getAttribute("parentDatasourceId") : this.getOverrideDataSourceId();
        Map<String, HostedByEntry> hostedByEntryMap = !StringUtils.isBlank((String)this.keyTypeFilter) ? this.loadHostedByMapFromType(this.keyTypeFilter) : this.loadHostedByMap(datasourceId);
        W3CEndpointReference epr = this.mappedResultSetFactory.createMappedResultSet(inputEpr, (UnaryFunction)new PatchHostedBy(hostedByEntryMap, this.getXpathEntry(), counters));
        token.getEnv().setAttribute(this.outputEprParam, epr.toString());
        token.getEnv().setTransientAttribute(this.countersParam, (Object)counters);
        return Arc.DEFAULT_ARC;
    }

    private Map<String, HostedByEntry> loadHostedByMap(String datasourceId) throws DocumentException, DatabaseException {
        String sql = "SELECT d.id, d.officialname, p.entry from %s p JOIN datasources d ON (p.datasourceid = d.id) WHERE p.oa_source_id= '%s'";
        return this.getHostedByEntryMapByQuery(datasourceId, "SELECT d.id, d.officialname, p.entry from %s p JOIN datasources d ON (p.datasourceid = d.id) WHERE p.oa_source_id= '%s'");
    }

    private Map<String, HostedByEntry> loadHostedByMapFromType(String keyType) throws DocumentException, DatabaseException {
        String sql = "SELECT d.id, d.officialname, p.entry from %s p JOIN datasources d ON (p.datasourceid = d.id) WHERE p.key_type= '%s'";
        return this.getHostedByEntryMapByQuery(keyType, "SELECT d.id, d.officialname, p.entry from %s p JOIN datasources d ON (p.datasourceid = d.id) WHERE p.key_type= '%s'");
    }

    private Map<String, HostedByEntry> getHostedByEntryMapByQuery(String datasourceId, String sql) throws DatabaseException, DocumentException {
        HashMap map = Maps.newHashMap();
        W3CEndpointReference epr = ((DatabaseService)this.serviceLocator.getService(DatabaseService.class)).searchSQL(this.getDbName(), String.format(sql, this.getHostedbyMapTable(), datasourceId));
        SAXReader reader = new SAXReader();
        for (String s : this.resultSetClientFactory.getClient(epr)) {
            Document doc = reader.read((Reader)new StringReader(s));
            String entry = doc.valueOf("//FIELD[@name='entry']");
            String dsId = doc.valueOf("//FIELD[@name='id']");
            String dsName = doc.valueOf("//FIELD[@name='officialname']");
            map.put(entry, new HostedByEntry(dsId, dsName));
        }
        log.info((Object)String.format("built hostedByMap from dsId '%s', size: '%s'", datasourceId, map.size()));
        return map;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getKeyTypeFilter() {
        return this.keyTypeFilter;
    }

    public void setKeyTypeFilter(String keyTypeFilter) {
        this.keyTypeFilter = keyTypeFilter;
    }

    public MappedResultSetFactory getMappedResultSetFactory() {
        return this.mappedResultSetFactory;
    }

    @Required
    public void setMappedResultSetFactory(MappedResultSetFactory mappedResultSetFactory) {
        this.mappedResultSetFactory = mappedResultSetFactory;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public String getCountersParam() {
        return this.countersParam;
    }

    public void setCountersParam(String countersParam) {
        this.countersParam = countersParam;
    }

    public String getHostedbyMapTable() {
        return this.hostedbyMapTable;
    }

    public void setHostedbyMapTable(String hostedbyMapTable) {
        this.hostedbyMapTable = hostedbyMapTable;
    }

    public String getXpathEntry() {
        return this.xpathEntry;
    }

    public void setXpathEntry(String xpathEntry) {
        this.xpathEntry = xpathEntry;
    }

    public String getOverrideDataSourceId() {
        return this.overrideDataSourceId;
    }

    public void setOverrideDataSourceId(String overrideDataSourceId) {
        this.overrideDataSourceId = overrideDataSourceId;
    }
}

