/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.api;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SinglePublicationSubmitterUtils {
    private final ISLookUpService lookupService;

    public SinglePublicationSubmitterUtils(ISLookUpService lookupService) {
        this.lookupService = lookupService;
    }

    public Map<String, String> calculateProjectInfo(String link) {
        HashMap<String, String> info = new HashMap<String, String>();
        String[] arr = link.split("/");
        String funderId = this.calculateFunderId(arr[2]);
        info.put("id", this.calculateProjectId(arr[2], arr[3], arr[4]));
        info.put("funderShortName", arr[2]);
        info.put("fundingName", arr[3]);
        info.put("code", arr[4]);
        info.put("jurisdiction", arr[5]);
        info.put("title", StringUtils.isNotBlank((String)arr[6]) ? arr[6] : arr[7]);
        info.put("acronym", arr[7]);
        info.put("funderId", funderId);
        info.put("funderName", this.calculateFunderName(arr[2]));
        info.put("fundingId", funderId + "::" + arr[3]);
        return info;
    }

    private String calculateProjectId(String funderShortName, String funding, String code) {
        String suffix = Hashing.md5((String)code);
        if (funderShortName.equalsIgnoreCase("ec")) {
            if (funding.equalsIgnoreCase("fp7")) {
                return "corda_______::" + suffix;
            }
            return "corda__h2020::" + suffix;
        }
        if (funderShortName.equalsIgnoreCase("arc")) {
            return "arc_________::" + suffix;
        }
        if (funderShortName.equalsIgnoreCase("fct")) {
            return "fct_________::" + suffix;
        }
        if (funderShortName.equalsIgnoreCase("nhmrc")) {
            return "nhmrc_______::" + suffix;
        }
        if (funderShortName.equalsIgnoreCase("wt")) {
            return "wt__________::" + suffix;
        }
        return "";
    }

    private String calculateFunderId(String funderShortName) {
        if (funderShortName.equalsIgnoreCase("ec")) {
            return "ec__________::EC";
        }
        if (funderShortName.equalsIgnoreCase("arc")) {
            return "arc_________::ARC";
        }
        if (funderShortName.equalsIgnoreCase("fct")) {
            return "fct_________::FCT";
        }
        if (funderShortName.equalsIgnoreCase("nhmrc")) {
            return "nhmrc_______::NHMRC";
        }
        if (funderShortName.equalsIgnoreCase("wt")) {
            return "wt__________::WT";
        }
        return "";
    }

    private String calculateFunderName(String funderShortName) {
        if (funderShortName.equalsIgnoreCase("ec")) {
            return "European Commission";
        }
        if (funderShortName.equalsIgnoreCase("arc")) {
            return "Australian Research Council (ARC)";
        }
        if (funderShortName.equalsIgnoreCase("fct")) {
            return "Funda\u00e7\u00e3o para a Ci\u00eancia e a Tecnologia";
        }
        if (funderShortName.equalsIgnoreCase("nhmrc")) {
            return "National Health and Medical Research Council (NHMRC)";
        }
        if (funderShortName.equalsIgnoreCase("wt")) {
            return "Wellcome Trust";
        }
        return "";
    }

    public List<ContextInfo> processContexts(List<String> list) {
        return Lists.newArrayList((Iterable)Lists.transform(list, (Function)new Function<String, ContextInfo>(){

            public ContextInfo apply(String s) {
                return this.createContextInfo(s.split("::"), 0);
            }

            private ContextInfo createContextInfo(String[] arr, int pos) {
                StringWriter id = new StringWriter();
                id.write(arr[0]);
                for (int i = 0; i < pos; ++i) {
                    id.write("::");
                    id.write(arr[i + 1]);
                }
                String elem = pos == 0 ? "context" : (pos == 1 ? "category" : "concept");
                ContextInfo info = new ContextInfo(elem, id.toString());
                if (pos + 1 < arr.length) {
                    info.getChildren().add(this.createContextInfo(arr, pos + 1));
                }
                return info;
            }
        }));
    }

    public class ContextInfo {
        private String elem;
        private String id;
        private List<ContextInfo> children = new ArrayList<ContextInfo>();

        public ContextInfo(String elem, String id) {
            this.elem = elem;
            this.id = id;
        }

        public String getElem() {
            return this.elem;
        }

        public void setElem(String elem) {
            this.elem = elem;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public List<ContextInfo> getChildren() {
            return this.children;
        }

        public void setChildren(List<ContextInfo> children) {
            this.children = children;
        }

        public boolean isRoot() {
            return this.elem.equals("context");
        }
    }
}

