package eu.dnetlib.openaire.exporter.model;

import java.util.ArrayList;
import java.util.List;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;

/**
 * Created by claudio on 20/09/16.
 */
public class Project {

	public static final String INFO_EU_REPO_GRANT_AGREEMENT = "info:eu-repo/grantAgreement/";
	private String code;
	private String acronym;
	private String title;
	private String call_identifier;
	private String startdate;
	private String enddate;
	private boolean ec_sc39;
	private boolean oa_mandate_for_publications;
	private boolean ec_article29_3;
	private String fundingpathid;
	private String description;
	private String jurisdiction;
	private String legalname;
	private String funder;
	private String countryclass;
	private String role;
	private String firstname;
	private String secondnames;
	private String email;

	public Project() {
	}

	public String getIdnamespace() {
		String res = INFO_EU_REPO_GRANT_AGREEMENT + getFunder()+"/";
		final String fundingProgram = asFundingProgram(getFundingpathid());
		if (StringUtils.isNotBlank(fundingProgram)) {
			res += fundingProgram;
		}
		res += "/" + escapeCode(getCode());
		if (StringUtils.isNotBlank(getJurisdiction())) {
			res += "/" + getJurisdiction();
		}
		return res;
	}

	public String getListLabel() {
		return String.format("for:value:component:_%s_project_id", asFunder(getFunder()));
	}

	private String asFunder(final String legalshortname) {
		switch (legalshortname.toLowerCase()) {
		case "ec":
			return asFundingProgram(getFundingpathid()).toLowerCase();
		default:
			return legalshortname.toLowerCase();
		}
	}

	public List<String> asList() {
		return Lists.newArrayList(
				clean(getCode()),
				clean(getAcronym()),
				clean(getTitle()),
				clean(getCall_identifier()),
				clean(getStartdate()),
				clean(getEnddate()),
				String.valueOf(isEc_article29_3()),
				String.valueOf(isOa_mandate_for_publications()),
				String.valueOf(isEc_article29_3()),
				clean(getDescription()),
				clean(getLegalname()),
				clean(getCountryclass()),
				clean(getRole()),
				clean(getFirstname()),
				clean(getSecondnames()),
				clean(getEmail()));
	}

	private String clean(final String s) {
		return StringUtils.isNotBlank(s) ? "\"" + s.replaceAll("\\n|\\t|\\s+", " ").replace("\"","\"\"").trim() + "\"" : "";
	}

	private String escapeCode(final String code) {
		return replaceSlash(code);
	}

	private String asFundingProgram(final String fundingpathid) {
		final ArrayList<String> strings = Lists.newArrayList(Splitter.on("::").split(fundingpathid));
		if(strings.size() <= 1) throw new IllegalStateException("Unexpected funding id: "+fundingpathid);
		if(strings.size() == 2) return "";
		else return replaceSlash(strings.get(2));
	}

	private String replaceSlash(final String s) {
		return s.replaceAll("/", "%2F");
	}

	public String getCode() {
		return code;
	}

	public Project setCode(final String code) {
		this.code = code;
		return this;
	}

	public String getAcronym() {
		return acronym;
	}

	public Project setAcronym(final String acronym) {
		this.acronym = acronym;
		return this;
	}

	public String getTitle() {
		return title;
	}

	public Project setTitle(final String title) {
		this.title = title;
		return this;
	}

	public String getCall_identifier() {
		return call_identifier;
	}

	public Project setCall_identifier(final String call_identifier) {
		this.call_identifier = call_identifier;
		return this;
	}

	public String getStartdate() {
		return startdate;
	}

	public Project setStartdate(final String startdate) {
		this.startdate = startdate;
		return this;
	}

	public String getEnddate() {
		return enddate;
	}

	public Project setEnddate(final String enddate) {
		this.enddate = enddate;
		return this;
	}

	public boolean isEc_sc39() {
		return ec_sc39;
	}

	public Project setEc_sc39(final boolean ec_sc39) {
		this.ec_sc39 = ec_sc39;
		return this;
	}

	public boolean isOa_mandate_for_publications() {
		return oa_mandate_for_publications;
	}

	public Project setOa_mandate_for_publications(final boolean oa_mandate_for_publications) {
		this.oa_mandate_for_publications = oa_mandate_for_publications;
		return this;
	}

	public boolean isEc_article29_3() {
		return ec_article29_3;
	}

	public Project setEc_article29_3(final boolean ec_article29_3) {
		this.ec_article29_3 = ec_article29_3;
		return this;
	}

	public String getFundingpathid() {
		return fundingpathid;
	}

	public Project setFundingpathid(final String fundingpathid) {
		this.fundingpathid = fundingpathid;
		return this;
	}

	public String getDescription() {
		return description;
	}

	public Project setDescription(final String description) {
		this.description = description;
		return this;
	}

	public String getJurisdiction() {
		return jurisdiction;
	}

	public Project setJurisdiction(final String jurisdiction) {
		this.jurisdiction = jurisdiction;
		return this;
	}

	public String getLegalname() {
		return legalname;
	}

	public Project setLegalname(final String legalname) {
		this.legalname = legalname;
		return this;
	}

	public String getCountryclass() {
		return countryclass;
	}

	public Project setCountryclass(final String countryclass) {
		this.countryclass = countryclass;
		return this;
	}

	public String getRole() {
		return role;
	}

	public Project setRole(final String role) {
		this.role = role;
		return this;
	}

	public String getFirstname() {
		return firstname;
	}

	public Project setFirstname(final String firstname) {
		this.firstname = firstname;
		return this;
	}

	public String getSecondnames() {
		return secondnames;
	}

	public Project setSecondnames(final String secondnames) {
		this.secondnames = secondnames;
		return this;
	}

	public String getEmail() {
		return email;
	}

	public Project setEmail(final String email) {
		this.email = email;
		return this;
	}

	public String getFunder() {
		return funder;
	}

	public Project setFunder(final String funder) {
		this.funder = funder;
		return this;
	}
}
