/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.pace.config.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractProtoMapper {
    private static final String COND_WRAPPER = "\\{|\\}";
    private static final String COND_SEPARATOR = "#";
    private static final String PATH_SEPARATOR = "/";

    protected List<Object> processMultiPath(GeneratedMessage proto, List<String> paths, Type type) {
        ArrayList response = Lists.newArrayList();
        for (String pathElements : paths) {
            response.addAll(this.processPath(proto, pathElements, type));
        }
        return response;
    }

    protected List<Object> processPath(GeneratedMessage proto, String path, Type type) {
        return this.processPath(proto, Lists.newLinkedList((Iterable)Splitter.on((String)PATH_SEPARATOR).trimResults().split((CharSequence)path)), type);
    }

    protected List<Object> processPath(GeneratedMessage proto, List<String> pathElements, Type type) {
        ArrayList response = Lists.newArrayList();
        if (pathElements.isEmpty()) {
            throw new RuntimeException("ProtoBuf navigation path is empty");
        }
        String fieldPathCond = pathElements.get(0);
        String fieldPath = StringUtils.substringBefore((String)fieldPathCond, (String)"[");
        String cond = this.getCondition(fieldPathCond);
        Descriptors.FieldDescriptor fd = proto.getDescriptorForType().findFieldByName(fieldPath);
        if (fd != null) {
            if (fd.isRepeated()) {
                int count = proto.getRepeatedFieldCount(fd);
                for (int i = 0; i < count; ++i) {
                    Object field = proto.getRepeatedField(fd, i);
                    response.addAll(this.generateFields(fd, field, pathElements, cond, type));
                }
            } else {
                Object field = proto.getField(fd);
                response.addAll(this.generateFields(fd, field, pathElements, cond, type));
            }
        } else {
            throw new IllegalArgumentException("Invalid protobuf path (field not found): " + StringUtils.join(pathElements, (String)">") + "\nMessage:\n" + proto);
        }
        return response;
    }

    private List<Object> generateFields(Descriptors.FieldDescriptor fd, Object field, List<String> list, String cond, Type type) {
        ArrayList res = Lists.newArrayList();
        if (field instanceof GeneratedMessage) {
            if (list.size() > 1) {
                String condVal;
                if (StringUtils.isBlank((String)cond)) {
                    return this.processPath((GeneratedMessage)field, list.subList(1, list.size()), type);
                }
                LinkedList condPath = Lists.newLinkedList((Iterable)Splitter.on((String)COND_SEPARATOR).trimResults().split((CharSequence)StringUtils.substringBefore((String)cond, (String)"=")));
                String val = (String)Iterables.getOnlyElement(this.processPath((GeneratedMessage)field, condPath, type));
                return val.equals(condVal = StringUtils.substringAfter((String)cond, (String)"=").replaceAll(COND_WRAPPER, "").trim()) ? this.processPath((GeneratedMessage)field, list.subList(1, list.size()), type) : res;
            }
            if (Type.JSON.equals((Object)type)) {
                res.add(JsonFormat.printToString((Message)((Message)field)));
                return res;
            }
            throw new RuntimeException("No primitive type found");
        }
        if (list.size() == 1) {
            switch (fd.getType()) {
                case ENUM: {
                    res.add(((Descriptors.EnumValueDescriptor)field).getName());
                    break;
                }
                default: {
                    res.add(field);
                }
            }
            return res;
        }
        throw new RuntimeException("Found a primitive type before the path end");
    }

    private String getCondition(String fieldPathCond) {
        return fieldPathCond.contains("[") ? StringUtils.substringAfter((String)fieldPathCond, (String)"[").replace("]", "") : "";
    }
}

