<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dnet="eu.dnetlib.data.transform.xml.OdfToHbaseXsltFunctions"
                xmlns:oaf="http://namespace.openaire.eu/oaf"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:dr="http://www.driver-repository.eu/namespace/dr"
                xmlns:exslt="http://exslt.org/common" version="1.0"
                extension-element-prefixes="exslt" exclude-result-prefixes="xsl dnet exslt oaf dr dri">

    <xsl:output omit-xml-declaration="yes" indent="yes"/>

    <xsl:param name="trust" select="string('0.9')"/>
    <xsl:param name="provenance" select="string('UNKNOWN')"/>
    <xsl:param name="namespaceprefix" select="string('datacite____')"/>

    <xsl:template match="/*">
        <xsl:variable name="about" select="/*[local-name() = 'record']/*[local-name() = 'about']"/>
        <xsl:variable name="metadata" select="exslt:node-set(/*[local-name()='record']/*[local-name()='metadata']/*[local-name()='resource'])"/>
        <xsl:variable name="rightNSPrefix">
            <xsl:choose>
                <xsl:when test="not($namespaceprefix)">
                    <xsl:value-of select="//oaf:datasourceprefix"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$namespaceprefix"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:choose>
            <xsl:when test="count($metadata) =  0">
                <ACTIONS/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="originalId" select="/record/metadata/*[local-name() = 'identifier' and ./@identifierType='DOI']"/>
                <xsl:variable name="resultId" select="dnet:oafSimpleId('result', //dri:objIdentifier)"/>

	            <xsl:if test="string-length($resultId) &gt; 0">
		            <xsl:variable name="originalids"
		                          select="//*[local-name() = 'resource']/*[local-name()='identifier'] | //*[local-name() = 'resource']//*[local-name()='alternateIdentifier']"/>

		            <xsl:variable name="creators" select="//*[local-name() = 'creator']"/>
	                <xsl:variable name="titles" select="//*[local-name() = 'title']"/>
	                <xsl:variable name="subjects" select="//*[local-name() = 'subject']"/>
	                <xsl:variable name="publisher" select="//*[local-name() = 'publisher']"/>
	                <xsl:variable name="descriptions" select="//*[local-name() = 'description']"/>
	                <xsl:variable name="dates" select="//*[local-name() = 'date']"/>
	                <xsl:variable name="dateaccepted" select="//oaf:dateAccepted"/>
	                <xsl:variable name="resourceType" select="//*[local-name() = 'resourceType']"/>
	                <xsl:variable name="formats" select="//*[local-name() = 'format']"/>
	                <xsl:variable name="sizes" select="//*[local-name() = 'size']"/>
	                <xsl:variable name="rights" select="//oaf:accessrights"/>
	                <xsl:variable name="version" select="//*[local-name() = 'version']"/>
		            <xsl:variable name="instanceURI">
			            <xsl:choose>
				            <xsl:when
						            test="string-length( //*[local-name() = 'resource']/*[local-name()='identifier' and ./@identifierType='DOI']) &gt; 0">
					            <xsl:value-of
							            select="concat('http://dx.doi.org','/', //*[local-name() = 'resource']/*[local-name()='identifier' and ./@identifierType='DOI']/text())"/>
				            </xsl:when>
				            <xsl:otherwise>
					            <xsl:value-of select="//*[local-name() = 'resource']/*[local-name()='identifier' and ./@identifierType='URL']"/>
				            </xsl:otherwise>
			            </xsl:choose>
		            </xsl:variable>
		            <xsl:variable name="hostedbyid" select="dnet:oafSplitId('datasource', //oaf:hostedBy/@id)"/>
	                <xsl:variable name="hostedbyname" select="//oaf:hostedBy/@name"/>
	                <xsl:variable name="collectedfromid" select="dnet:oafSplitId('datasource', //oaf:collectedFrom/@id)"/>
	                <xsl:variable name="collectedfromname" select="//oaf:collectedFrom/@name"/>
	                <xsl:variable name="dateOfCollection" select="//dr:dateOfCollection"/>
		            <xsl:variable name="dateoftransformation" select="concat('', //dr:dateOfTransformation)"/>
	                <xsl:variable name="language" select="//oaf:language"/>
	                <xsl:variable name="cobjcategory" select="//dr:CobjCategory"/>
		            <xsl:variable name="contributor" select="//*[local-name() = 'contributor']/*[local-name() = 'contributorName']"/>
		            <xsl:variable name="pids" select="//*[local-name() = 'resource']/*[local-name()='identifier']"/>

		            <xsl:variable name="result"
		                          select="dnet:odfResult($resultId, $about, $metadata, $titles, $subjects, $publisher, $descriptions,
		                                            $dates, $dateaccepted, $resourceType, $formats, $sizes, $language, $cobjcategory, $contributor,
		                                            $rights, $version, $pids, $provenance, $trust, $hostedbyid, $hostedbyname, $collectedfromid,
		                                            $collectedfromname, $originalids, $instanceURI, $dateOfCollection, $dateoftransformation)"/>

		            <ACTIONS>
			            <ACTION targetKey="{$resultId}" targetColumnFamily="result" targetColumn="body">
				            <xsl:value-of select="$result"/>
	                    </ACTION>

	                    <xsl:for-each select="//*[local-name() = 'creator']">
	                        <xsl:variable name="personIdTemp">
	                            <xsl:choose>
	                                <xsl:when test="string-length(./*[local-name() = 'nameIdentifier']) &gt; 0">
	                                    <xsl:value-of
	                                            select="translate(normalize-space(./*[local-name() = 'nameIdentifier']),' .,','___')"
	                                            />
	                                </xsl:when>
	                                <xsl:otherwise>
	                                    <xsl:value-of
	                                            select="translate(normalize-space(./*[local-name() = 'creatorName']),' .,','___')"
	                                            />
	                                </xsl:otherwise>
	                            </xsl:choose>

	                        </xsl:variable>

	                        <xsl:variable name="personId"
	                                      select="dnet:oafId('person', $namespaceprefix, concat($originalId, '::', normalize-space($personIdTemp)))"/>

	                        <xsl:variable name="originalPersonId" select="./*[local-name() = 'nameIdentifier']"/>
	                        <xsl:if test="string-length($personId) &gt; 0">
		                        <xsl:variable name="position" select="position()"/>
		                        <xsl:variable name="person"
		                                      select="dnet:person($personId, $about, $provenance, $trust, $collectedfromid, $collectedfromname,
									                              $originalPersonId, $dateOfCollection, $dateoftransformation, normalize-space(./*[local-name() = 'creatorName']),
									                              ./*[local-name() = 'nameIdentifier'], ./*[local-name() = 'nameIdentifier']/@nameIdentifierScheme)"/>

		                        <xsl:variable name="personresult"
		                                      select="dnet:personResult_Authorship($personId, $resultId, $position, 'isAuthorOf',
									                              $collectedfromid, $collectedfromname, $provenance, $trust, $about)"/>
		                        <xsl:variable name="resultperson"
		                                      select="dnet:personResult_Authorship($resultId, $personId, $position, 'hasAuthor',
									                              $collectedfromid, $collectedfromname, $provenance, $trust, $about)"/>

		                        <ACTION targetKey="{$personId}" targetColumnFamily="person" targetColumn="body">
			                        <xsl:value-of select="$person"/>
	                            </ACTION>
		                        <ACTION targetKey="{$personId}" targetColumnFamily="personResult_authorship_isAuthorOf" targetColumn="{$resultId}">
			                        <xsl:value-of select="$personresult"/>
	                            </ACTION>
		                        <ACTION targetKey="{$resultId}" targetColumnFamily="personResult_authorship_hasAuthor" targetColumn="{$personId}">
			                        <xsl:value-of select="$resultperson"/>
	                            </ACTION>
	                        </xsl:if>
	                    </xsl:for-each>

			            <xsl:for-each select="//*[local-name()='relatedIdentifier' and ./@relatedIdentifierType='OPENAIRE' and ./@relationType='IsSupplementTo']">

				            <!-- relatedDataset ids must be in the openaire format  -->
				            <xsl:variable name="targetId" select="dnet:oafSimpleId('result', normalize-space(.))"/>

				            <xsl:if test="string-length($targetId) &gt; 0">

					            <xsl:variable name="resultDataset"
					                          select="dnet:rel($resultId, $targetId, 'resultResult', 'supplement', 'isSupplementTo',
						                              $collectedfromid, $collectedfromname, $provenance, $trust, $about)"/>
					            <xsl:variable name="datasetResult"
					                          select="dnet:rel($targetId, $resultId, 'resultResult', 'supplement', 'isSupplementedBy',
						                              $collectedfromid, $collectedfromname, $provenance, $trust, $about)"/>

					            <ACTION targetKey="{$resultId}" targetColumnFamily="resultResult_supplement_isSupplementTo" targetColumn="$targetId">
						            <xsl:value-of select="$resultDataset"/>
					            </ACTION>
					            <ACTION targetKey="{$targetId}" targetColumnFamily="resultResult_supplement_isSupplementedBy" targetColumn="$resultId">
						            <xsl:value-of select="$datasetResult"/>
					            </ACTION>
				            </xsl:if>
			            </xsl:for-each>
			            <xsl:for-each select="//*[local-name()='relatedIdentifier' and ./@relatedIdentifierType='OPENAIRE' and ./@relationType='IsPartOf']">

				            <!-- relatedDataset ids must be in the openaire format  -->
				            <xsl:variable name="datasetId" select="dnet:oafSimpleId('result', normalize-space(.))"/>

				            <xsl:if test="string-length($datasetId) &gt; 0">

					            <xsl:variable name="childParent"
					                          select="dnet:rel($resultId, $datasetId, 'resultResult', 'part', 'isPartOf',
						                              $collectedfromid, $collectedfromname, $provenance, $trust, $about)"/>
					            <xsl:variable name="parentChild"
					                          select="dnet:rel($datasetId, $resultId, 'resultResult', 'part', 'hasPart',
						                              $collectedfromid, $collectedfromname, $provenance, $trust, $about)"/>

					            <ACTION targetKey="{$resultId}" targetColumnFamily="resultResult_part_isPartOf" targetColumn="$datasetId">
						            <xsl:value-of select="$childParent"/>
					            </ACTION>
					            <ACTION targetKey="{$datasetId}" targetColumnFamily="resultResult_part_hasPart" targetColumn="$resultId">
						            <xsl:value-of select="$parentChild"/>
					            </ACTION>
				            </xsl:if>
			            </xsl:for-each>

		            </ACTIONS>
	            </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
