<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dnet="eu.dnetlib.data.transform.xml.OdfToHbaseXsltFunctions"
                xmlns:oaf="http://namespace.openaire.eu/oaf"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:date="java.lang.System"
                xmlns:dr="http://www.driver-repository.eu/namespace/dr"
                xmlns:exslt="http://exslt.org/common" version="1.0"
                extension-element-prefixes="exslt" exclude-result-prefixes="xsl dnet exslt oaf dr dri date">

    <xsl:output omit-xml-declaration="yes" indent="yes"/>

    <xsl:param name="trust" select="string('0.9')"/>
    <xsl:param name="provenance" select="string('UNKNOWN')"/>
    <xsl:param name="namespaceprefix" select="string('datacite____')"/>

    <xsl:template match="/*">
        <xsl:variable name="about" select="/*[local-name() = 'record']/*[local-name() = 'about']"/>
        <xsl:variable name="metadata" select="exslt:node-set(/*[local-name()='record']/*[local-name()='metadata']/*[local-name()='resource'])"/>
        <xsl:variable name="rightNSPrefix">
            <xsl:choose>
                <xsl:when test="not($namespaceprefix)">
                    <xsl:value-of select="//oaf:datasourceprefix"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$namespaceprefix"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:choose>
            <xsl:when test="count($metadata) =  0">
                <ACTIONS/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="originalId" select="//*[local-name() = 'identifier' and ./@identifierType='DOI']"/>
                <xsl:variable name="resultId" select="dnet:oafSimpleId('result', //dri:objIdentifier)"/>

	            <xsl:if test="string-length($resultId) &gt; 0">
		            <xsl:variable name="originalids"
		                          select="//*[local-name() = 'resource']/*[local-name()='identifier'] | //*[local-name() = 'resource']//*[local-name()='alternateIdentifier']"/>

		            <xsl:variable name="creators" select="//*[local-name() = 'creator']"/>
		            <xsl:variable name="titles" select="//*[local-name() = 'title']"/>
		            <xsl:variable name="subjects" select="//*[local-name() = 'subject']"/>
		            <xsl:variable name="publisher" select="//*[local-name() = 'publisher']"/>
		            <xsl:variable name="descriptions" select="//*[local-name() = 'description']"/>
		            <xsl:variable name="dates" select="//*[local-name() = 'date']"/>
		            <xsl:variable name="dateaccepted" select="//oaf:dateAccepted"/>
		            <xsl:variable name="resourceType" select="//*[local-name() = 'resourceType']"/>
		            <xsl:variable name="formats" select="//*[local-name() = 'format']"/>
		            <xsl:variable name="sizes" select="//*[local-name() = 'size']"/>
		            <xsl:variable name="rights" select="//oaf:accessrights"/>
		            <xsl:variable name="version" select="//*[local-name() = 'version']"/>
		            <xsl:variable name="instanceURI"
		                          select="concat('http://dx.doi.org','/',//*[local-name() = 'resource']/*[local-name() = 'identifier'])"/>
		            <xsl:variable name="hostedbyid"
		                          select="dnet:oafSplitId('datasource', //oaf:hostedBy/@id)"/>
		            <xsl:variable name="hostedbyname" select="//oaf:hostedBy/@name"/>
		            <xsl:variable name="collectedfromid"
		                          select="dnet:oafSplitId('datasource', //oaf:collectedFrom/@id)"/>
		            <xsl:variable name="collectedfromname" select="//oaf:collectedFrom/@name"/>
		            <xsl:variable name="dateOfCollection" select="//dr:dateOfCollection"/>
		            <xsl:variable name="dateoftransformation" select="concat('', //dr:dateOfTransformation)"/>
		            <xsl:variable name="language" select="//oaf:language"/>
		            <xsl:variable name="cobjcategory" select="//dr:CobjCategory"/>
		            <xsl:variable name="contributors" select="//*[local-name() = 'contributorName']"/>
		            <xsl:variable name="pids" select="//*[local-name() = 'resource']/*[local-name()='identifier']"/>

		            <xsl:variable name="result"
		                          select="dnet:odfResult($resultId, $about, $metadata, $titles, $subjects, $publisher, $descriptions,
			                                            $dates, $dateaccepted, $resourceType, $formats, $sizes, $language, $cobjcategory, $contributors, $rights,
			                                            $version, $pids, $provenance, $trust, $hostedbyid, $hostedbyname, $collectedfromid,
			                                            $collectedfromname, $originalids, $instanceURI, $dateOfCollection, $dateoftransformation)"/>


		            final NodeList dates,
		            final NodeList dateaccepted,
		            final NodeList resourceTypes,
		            final NodeList formats,
		            final NodeList sizes,
		            final NodeList languages,
		            final NodeList cobjcategory,
		            final NodeList contributors,
		            final NodeList rights,
		            final NodeList version,
		            final NodeList pidList,
		            final String provenance,
		            final String trust,
		            final String hostedbyId,
		            final String hostedbyName,
		            final String collectedfromId,
		            final String collectedfromName,
		            final NodeList originalIds,
		            final String instanceUri,
		            final String dateOfCollection,
		            final String dateOfTransformation



		            <ACTIONS>
			            <ACTION targetKey="{$resultId}" targetColumnFamily="result" targetColumn="{concat('update_', date:nanoTime())}">
				            <xsl:value-of select="$result"/>
			            </ACTION>
		            </ACTIONS>
	            </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
