/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.model;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.io.CsvBeanReader;
import org.supercsv.io.CsvBeanWriter;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.CsvContext;

public class ProjectDetail {
    private static final String[] NAMEMAPPING = new String[]{"projectId", "acronym", "code", "optional1", "optional2", "jsonextrainfo", "fundingPath"};
    private String projectId;
    private String acronym;
    private String code;
    private String optional1;
    private String optional2;
    private String jsonextrainfo;
    private List<String> fundingPath;

    public static ProjectDetail fromJson(String json) {
        return (ProjectDetail)new Gson().fromJson(json, ProjectDetail.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectDetail fromCSV(String csv) throws IOException {
        try (CsvBeanReader beanReader = null;){
            beanReader = new CsvBeanReader((Reader)new StringReader(csv), CsvPreference.STANDARD_PREFERENCE);
            ProjectDetail projectDetail = (ProjectDetail)beanReader.read(ProjectDetail.class, NAMEMAPPING, ProjectDetail.getProcessors((CellProcessor)new StringCellProcessor(){

                public Object execute(Object value, CsvContext context) {
                    return new Gson().fromJson(value.toString(), List.class);
                }
            }));
            return projectDetail;
        }
    }

    private static CellProcessor[] getProcessors(CellProcessor fundingPathProcessor) {
        return new CellProcessor[]{new Optional(), new Optional(), new Optional(), new Optional(), new Optional(), new Optional(), fundingPathProcessor};
    }

    public String asJson() {
        return new Gson().toJson((Object)this) + '\n';
    }

    public String asCSV() throws IOException {
        StringWriter sb = new StringWriter();
        try (CsvBeanWriter beanWriter = new CsvBeanWriter((Writer)sb, CsvPreference.STANDARD_PREFERENCE);){
            beanWriter.write((Object)this, NAMEMAPPING, ProjectDetail.getProcessors((CellProcessor)new StringCellProcessor(){

                public Object execute(Object value, CsvContext context) {
                    return new Gson().toJson(value);
                }
            }));
            beanWriter.flush();
        }
        return sb.toString();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public ProjectDetail setProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public String getAcronym() {
        return this.acronym;
    }

    public ProjectDetail setAcronym(String acronym) {
        this.acronym = acronym;
        return this;
    }

    public String getCode() {
        return this.code;
    }

    public ProjectDetail setCode(String code) {
        this.code = code;
        return this;
    }

    public String getOptional1() {
        return this.optional1;
    }

    public ProjectDetail setOptional1(String optional1) {
        this.optional1 = optional1;
        return this;
    }

    public String getOptional2() {
        return this.optional2;
    }

    public ProjectDetail setOptional2(String optional2) {
        this.optional2 = optional2;
        return this;
    }

    public String getJsonextrainfo() {
        return this.jsonextrainfo;
    }

    public ProjectDetail setJsonextrainfo(String jsonextrainfo) {
        this.jsonextrainfo = jsonextrainfo;
        return this;
    }

    public List<String> getFundingPath() {
        return this.fundingPath;
    }

    public ProjectDetail setFundingPath(List<String> fundingPath) {
        this.fundingPath = fundingPath;
        return this;
    }
}

