/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.model;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ProjectDetail {
    public static final String COL_SEPARATOR = ",";
    public static final String VAL_SEPARATOR = "||";
    private String projectId;
    private String acronym;
    private String code;
    private String optional1;
    private String optional2;
    private String jsonextrainfo;
    private List<String> fundingPath;

    public String asJson() {
        return new Gson().toJson((Object)this);
    }

    public static ProjectDetail fromJson(String json) {
        return (ProjectDetail)new Gson().fromJson(json, ProjectDetail.class);
    }

    public String asCSV() {
        return Joiner.on((String)COL_SEPARATOR).useForNull("").join((Object)this.clean(this.getProjectId()), (Object)this.clean(this.getAcronym()), new Object[]{this.clean(this.getCode()), this.clean(this.getOptional1()), this.clean(this.getOptional2()), this.clean(this.getJsonextrainfo()), this.clean(Joiner.on((String)VAL_SEPARATOR).useForNull("").join(this.getFundingPath()))});
    }

    public static ProjectDetail fromCSV(String csv) {
        ArrayList split = Lists.newArrayList((Iterable)Splitter.on((String)COL_SEPARATOR).trimResults(CharMatcher.is((char)'\"')).split((CharSequence)csv));
        ProjectDetail p = new ProjectDetail().setProjectId(ProjectDetail.unescape((String)split.get(0))).setAcronym(ProjectDetail.unescape((String)split.get(1))).setCode(ProjectDetail.unescape((String)split.get(2))).setOptional1(ProjectDetail.unescape((String)split.get(3))).setOptional2(ProjectDetail.unescape((String)split.get(4))).setJsonextrainfo(ProjectDetail.unescape((String)split.get(5))).setFundingPath(ProjectDetail.asList(ProjectDetail.unescape((String)split.get(6))));
        return p;
    }

    private static List<String> asList(String s) {
        return Lists.newArrayList((Iterable)Splitter.on((String)VAL_SEPARATOR).split((CharSequence)s));
    }

    private String clean(String s) {
        return StringUtils.isNotBlank((String)s) ? "\"" + s.replaceAll("\\n|\\t|\\s+", " ").replace("\"", "\"\"").trim() + "\"" : "";
    }

    private static String unescape(String s) {
        return StringUtils.isNotBlank((String)s) ? s.replace("\"\"", "\"") : "";
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getAcronym() {
        return this.acronym;
    }

    public String getCode() {
        return this.code;
    }

    public String getOptional1() {
        return this.optional1;
    }

    public String getOptional2() {
        return this.optional2;
    }

    public String getJsonextrainfo() {
        return this.jsonextrainfo;
    }

    public List<String> getFundingPath() {
        return this.fundingPath;
    }

    public ProjectDetail setProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public ProjectDetail setAcronym(String acronym) {
        this.acronym = acronym;
        return this;
    }

    public ProjectDetail setCode(String code) {
        this.code = code;
        return this;
    }

    public ProjectDetail setOptional1(String optional1) {
        this.optional1 = optional1;
        return this;
    }

    public ProjectDetail setOptional2(String optional2) {
        this.optional2 = optional2;
        return this;
    }

    public ProjectDetail setJsonextrainfo(String jsonextrainfo) {
        this.jsonextrainfo = jsonextrainfo;
        return this;
    }

    public ProjectDetail setFundingPath(List<String> fundingPath) {
        this.fundingPath = fundingPath;
        return this;
    }
}

