package eu.dnetlib.data.transform.xml;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.Message.Builder;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos.StructuredProperty;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.OafProtos.OafRel;
import eu.dnetlib.data.proto.PersonProtos.Person;
import eu.dnetlib.data.proto.PersonProtos.Person.CoAuthor;
import eu.dnetlib.data.proto.RelMetadataProtos.RelMetadata;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.data.proto.RelTypeProtos.SubRelType;
import eu.dnetlib.data.proto.TypeProtos.Type;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Created by claudio on 01/12/15.
 */
public class CommonDNetXsltFunctions extends AbstractDNetXsltFunctions {

	private static final int MAX_COAUTHORS = 50;

	// dnet:oafPersonResultFromDMF($resultId, $oafPerson, position(), "sysimport:crosswalk:repository", "0.9")
	public static String personResult_Authorship(
			final String source,
			final String target,
			final int rank,
			final String relClass,
			final String provenanceAction,
			final String trust,
			final NodeList about) {

		final Map<String, String> params = Maps.newHashMap();
		params.put("rank", "" + rank);
		return rel(source, target, RelType.personResult.name(), SubRelType.authorship.name(), relClass, provenanceAction, trust, about, params);
	}

	public static String rel(
			final String source,
			final String target,
			final String relType,
			final String subRelType,
			final String relClass,
			final String provenanceAction,
			final String trust) {
		return rel(source, target, relType, subRelType, relClass, provenanceAction, trust, null, null);
	}

	public static String rel(
			final String source,
			final String target,
			final String relType,
			final String subRelType,
			final String relClass,
			final String provenanceAction,
			final String trust,
			final NodeList about) {
		return rel(source, target, relType, subRelType, relClass, provenanceAction, trust, about, null);
	}

	// dnet:oafRel($resultId, $datasetId, 'resultResult', 'part' 'isPartOf', $about)
	public static String rel(
			final String source,
			final String target,
			final String relType,
			final String subRelType,
			final String relClass,
			final String provenanceAction,
			final String trust,
			final NodeList about,
			final Map<String, String> params) {
		try {
			final String eSource = OafRowKeyDecoder.decode(source).getKey();
			final String eTarget = OafRowKeyDecoder.decode(target).getKey();

			final RelType rType = RelType.valueOf(relType);
			final SubRelType srType = SubRelType.valueOf(subRelType);

			final RelMetadata.Builder metadata = RelMetadata.newBuilder().setSemantics(getSimpleQualifier(relClass, getVocabularyName(rType)));

			final Builder subRel = getSubRelBuilder(metadata, srType, params);

			final OafRel.Builder rel = getRelBuilder(rType, srType, getRel(eSource, eTarget, rType, srType, relClass, false), subRel);

			final Oaf oaf = getOaf(rel, getDataInfo(about, provenanceAction, trust, false, false));
			return base64(oaf.toByteArray());
		} catch (Exception e) {
			e.printStackTrace(System.err);
			throw new RuntimeException(e);
		}
	}

	public static String person(
			final String personId,
			final NodeList about,
			final String provenanceAction,
			final String trust,
			final String collectedFromId,
			final String collectedFromName,
			final String originalId,
			final String dateOfCollection,
			final String dateOfTransformation,
			final String fullname,
			final String nameIdentifier,
			final String nameIdentifierScheme) {
		return person(personId, fullname, nameIdentifier, nameIdentifierScheme, null, null, null, provenanceAction, trust, about, collectedFromId,
				collectedFromName, originalId, dateOfCollection, dateOfTransformation);
	}

	// $personId, $about, $provenance, $trust, $collectedfromid, $collectedfromname, $originalPersonId, $dateofcollection, normalize-space(.))
	public static String person(
			final String personId,
			final String fullname,
			final String nameIdentifier,
			final String nameIdentifierScheme,
			final NodeList authors,
			final String namespaceprefix,
			final String objIdentifier,
			final String provenanceAction,
			final String trust,
			final NodeList about,
			final String collectedFromId,
			final String collectedFromName,
			final String originalId,
			final String dateOfCollection,
			final String dateOfTransformation) {
		try {
			final String entityId = OafRowKeyDecoder.decode(personId).getKey();

			final Person.Builder person = Person.newBuilder();
			final Person.Metadata.Builder metadata = getMetadata(fullname);

			if (authors != null) {
				for (int i = 0; (i < authors.getLength()) && (i < MAX_COAUTHORS); i++) {
					final Node node = authors.item(i);

					final String name = StringUtils.trim(node.getTextContent());
					if (!name.equals(fullname)) {

						final CoAuthor.Builder coAuthor = CoAuthor.newBuilder();

						coAuthor.setId(oafId("person", namespaceprefix, objIdentifier + "::" + name));
						coAuthor.setMetadata(getMetadata(name));

						person.addCoauthor(coAuthor);
					}
				}
			}

			final List<StructuredProperty> pids = Lists.newArrayList();
			if (StringUtils.isNotBlank(nameIdentifier) && StringUtils.isNotBlank(nameIdentifierScheme)) {
				pids.add(getStructuredProperty(nameIdentifier, nameIdentifierScheme, nameIdentifierScheme, "dnet:pid_types", "dnet:pid_types"));
			}

			final OafEntity.Builder entity =
					getEntity(Type.person, entityId, getKV(collectedFromId, collectedFromName), Lists.newArrayList(originalId), dateOfCollection,
							dateOfTransformation, pids)
							.setPerson(person.setMetadata(metadata));

			final Oaf oaf = getOaf(entity, getDataInfo(about, provenanceAction, trust, false, false));
			return base64(oaf.toByteArray());
		} catch (final Throwable e) {
			System.err.println("personId: " + personId);
			System.err.println("fullname: " + fullname);
			System.err.println("provenanceAction: " + provenanceAction);
			System.err.println("trust: " + trust);
			System.err.println("collectedFromId: " + collectedFromId);
			System.err.println("collectedFromName: " + collectedFromName);
			System.err.println("originalId: " + originalId);
			System.err.println("dateOfCollection: " + dateOfCollection);
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}

	private static Person.Metadata.Builder getMetadata(final String fullname) {
		final Person.Metadata.Builder metadata = Person.Metadata.newBuilder();

		metadata.setFullname(sf(fullname));

		final eu.dnetlib.pace.model.Person p = new eu.dnetlib.pace.model.Person(fullname, false);
		if (p.isAccurate()) {
			metadata.setFirstname(sf(p.getNormalisedFirstName()));
			metadata.clearSecondnames().addSecondnames(sf(p.getNormalisedSurname()));
			// metadata.setFullname(sf(p.getNormalisedFullname()));
		}
		return metadata;
	}

}
