<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa"
                xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:dnet="eu.dnetlib.data.transform.xml.OafToHbaseXsltFunctions"
                xmlns:exslt="http://exslt.org/common"
                version="1.0"
                extension-element-prefixes="exslt"
                exclude-result-prefixes="xsl dc dr dri oaa oaf dnet exslt">

    <xsl:output omit-xml-declaration="yes" indent="yes"/>

    <xsl:param name="trust" select="string('0.9')"/>
    <xsl:param name="provenance" select="string('UNKNOWN')"/>
    <xsl:param name="namespaceprefix" select="string('unknown_____')"/>

    <xsl:template match="/*">
        <xsl:variable name="about" select="/*[local-name() = 'record']/*[local-name() = 'about']"/>
        <xsl:variable name="dateofcollection" select="//dr:dateOfCollection"/>
	    <xsl:variable name="dateoftransformation" select="//dr:dateOfTransformation"/>

        <xsl:variable name="metadata" select="exslt:node-set(//*[local-name()='metadata']/*)"/>
        <xsl:variable name="collectedDatasourceid">
            <xsl:choose>
                <xsl:when test="string-length(//oaf:collectedDatasourceid) &gt; 0">
                    <xsl:value-of select="//oaf:collectedDatasourceid"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="UNKNOWN"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>


        <xsl:choose>
            <xsl:when test="count($metadata) = 0">
                <ACTIONS/>
            </xsl:when>
            <xsl:otherwise>

                <xsl:variable name="objidentifier" select="/record/*[local-name() = 'header']/*[local-name() = 'objIdentifier']"/>

                <xsl:variable name="resultId" select="dnet:oafSimpleId('result', $objidentifier)"/>

                <xsl:variable name="hostedbyid" select="dnet:oafSplitId('datasource', //oaf:hostedBy/@id)"/>
                <xsl:variable name="hostedbyname" select="//oaf:hostedBy/@name"/>

                <xsl:variable name="collectedfromid" select="dnet:oafSplitId('datasource', //oaf:collectedFrom/@id)"/>
                <xsl:variable name="collectedfromname" select="//oaf:collectedFrom/@name"/>

	            <xsl:variable name="originalidTest" select="/record/*[local-name() = 'header']/*[local-name() = 'recordIdentifier']"/>
	            <xsl:variable name="originalid">
		            <xsl:choose>
			            <xsl:when test="contains($originalidTest, '::')">
				            <xsl:value-of select="substring-after($originalidTest, '::')"/>
			            </xsl:when>
			            <xsl:otherwise>
				            <xsl:value-of select="$originalidTest"/>
			            </xsl:otherwise>
		            </xsl:choose>
	            </xsl:variable>

	            <xsl:variable name="result"
	                          select="dnet:oafResult($resultId, $provenance, $trust, $about, $hostedbyid, $hostedbyname,
	                          $collectedfromid, $collectedfromname, $originalid, $dateofcollection, $dateoftransformation, $metadata)"/>

	            <ACTIONS>
                    <ACTION targetKey="{$resultId}" targetColumnFamily="result" targetColumn="body">
                        <xsl:value-of select="$result"/>
                    </ACTION>

                    <!-- 					<xsl:variable name="instance" select="dnet:oafInstanceFromInfoPackage($resultId, $hostedbyid, $hostedbyname, $provenance, $trust, $metadata)" /> -->

                    <!-- 					<ACTION targetKey="{$resultId}" targetColumnFamily="instance" targetColumn="{$resultId}"> -->
                    <!-- 						<xsl:value-of select="$instance" /> -->
                    <!-- 					</ACTION> -->

                    <xsl:for-each select="//*[local-name()='projectid']">

                        <xsl:variable name="projectId" select="dnet:oafSplitId('project', normalize-space(.))"/>

	                    <xsl:if test="string-length($projectId) &gt; 0">

		                    <xsl:variable name="resultproject"
		                                  select="dnet:rel($resultId, $projectId, 'resultProject', 'outcome', 'isProducedBy', $provenance, $trust, $about)"/>
		                    <xsl:variable name="projectresult"
		                                  select="dnet:rel($projectId, $resultId, 'resultProject', 'outcome', 'produces', $provenance, $trust, $about)"/>

		                    <xsl:if test="string-length($projectId) &gt; 0">
			                    <ACTION targetKey="{$resultId}" targetColumnFamily="resultProject_outcome_isProducedBy" targetColumn="{$projectId}">
				                    <xsl:value-of select="$resultproject"/>
			                    </ACTION>
			                    <ACTION targetKey="{$projectId}" targetColumnFamily="resultProject_outcome_produces" targetColumn="{$resultId}">
				                    <xsl:value-of select="$projectresult"/>
			                    </ACTION>
		                    </xsl:if>

	                    </xsl:if>
                    </xsl:for-each>

                    <xsl:for-each select="//dc:creator">

                        <xsl:variable name="personId" select="dnet:oafId('person', $namespaceprefix, concat($objidentifier, '::', .))"/>

	                    <xsl:if test="string-length($personId) &gt; 0">

		                    <xsl:variable name="position" select="position()"/>
		                    <xsl:variable name="originalPersonId">
			                    <xsl:choose>
				                    <xsl:when test="string-length(@nameIdentifier) &gt; 0">
					                    <xsl:value-of select="normalize-space(@nameIdentifier)"/>
				                    </xsl:when>
				                    <xsl:otherwise>
					                    <xsl:value-of select="concat($originalid, '::', normalize-space(.))"/>
				                    </xsl:otherwise>
			                    </xsl:choose>
		                    </xsl:variable>

		                    <xsl:variable name="person"
		                                  select="dnet:person($personId, $about, $provenance, $trust, $collectedfromid, $collectedfromname,
								              $originalPersonId, $dateofcollection, $dateoftransformation, normalize-space(.), @nameIdentifier, @nameIdentifierScheme)"/>
		                    <xsl:variable name="personresult"
		                                  select="dnet:personResult_Authorship($personId, $resultId, $position, 'isAuthorOf', $provenance, $trust, $about)"/>
		                    <xsl:variable name="resultperson"
		                                  select="dnet:personResult_Authorship($resultId, $personId, $position, 'hasAuthor', $provenance, $trust, $about)"/>

		                    <ACTION targetKey="{$personId}" targetColumnFamily="person" targetColumn="body">
                                <xsl:value-of select="$person"/>
                            </ACTION>
                            <ACTION targetKey="{$personId}" targetColumnFamily="personResult_authorship_isAuthorOf" targetColumn="{$resultId}">
                                <xsl:value-of select="$personresult"/>
                            </ACTION>
                            <ACTION targetKey="{$resultId}" targetColumnFamily="personResult_authorship_hasAuthor" targetColumn="{$personId}">
                                <xsl:value-of select="$resultperson"/>
                            </ACTION>
                        </xsl:if>
                    </xsl:for-each>

                    <xsl:for-each select="//*[local-name()='relatedPublication']">

                        <!-- relatedDataset ids must be in the openaire format  -->
                        <xsl:variable name="publicationId" select="dnet:oafSimpleId('result', normalize-space(./@id))"/>

                        <xsl:if test="string-length($publicationId) &gt; 0">

	                        <xsl:variable name="resultDataset"
	                                      select="dnet:rel($resultId, $publicationId, 'resultResult', 'publicationDataset', 'isRelatedTo', $provenance, $trust, $about)"/>
	                        <xsl:variable name="datasetResult"
	                                      select="dnet:rel($publicationId, $resultId, 'resultResult', 'publicationDataset', 'isRelatedTo', $provenance, $trust, $about)"/>

	                        <ACTION targetKey="{$resultId}" targetColumnFamily="resultResult_publicationDataset_isRelatedTo" targetColumn="{$publicationId}">
                                <xsl:value-of select="$resultDataset"/>
                            </ACTION>
	                        <ACTION targetKey="{$publicationId}" targetColumnFamily="resultResult_publicationDataset_isRelatedTo" targetColumn="{$resultId}">
                                <xsl:value-of select="$datasetResult"/>
                            </ACTION>
                        </xsl:if>
                    </xsl:for-each>

                </ACTIONS>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
