/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.index;

import eu.dnetlib.data.index.CloudIndexClientException;
import eu.dnetlib.functionality.index.solr.feed.StreamingInputDocumentFactory;
import eu.dnetlib.miscutils.datetime.HumanTime;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;

public class CloudIndexClient {
    private static final Log log = LogFactory.getLog(CloudIndexClient.class);
    private static final String INDEX_RECORD_RESULT_FIELD = "dnetResult";
    private final CloudSolrServer solrServer;

    protected CloudIndexClient(CloudSolrServer solrServer) {
        this.solrServer = solrServer;
    }

    public int feed(String record, String indexDsId, UnaryFunction<String, String> toIndexRecord) throws CloudIndexClientException {
        try {
            SolrInputDocument doc = this.prepareSolrDocument(record, indexDsId, toIndexRecord);
            if (doc == null || doc.isEmpty()) {
                throw new CloudIndexClientException("Invalid solr document");
            }
            return this.feed(doc);
        }
        catch (Throwable e) {
            throw new CloudIndexClientException("Error feeding document", e);
        }
    }

    public int feed(SolrInputDocument document) throws CloudIndexClientException {
        try {
            UpdateResponse res = this.solrServer.add(document);
            log.debug((Object)("feed time for single records, elapsed time: " + HumanTime.exactly((long)res.getElapsedTime())));
            if (res.getStatus() != 0) {
                throw new CloudIndexClientException("bad status: " + res.getStatus());
            }
            this.solrServer.commit();
            return res.getStatus();
        }
        catch (Throwable e) {
            throw new CloudIndexClientException("Error feeding document", e);
        }
    }

    public void feed(List<SolrInputDocument> docs, AfterFeedingCallback callback) throws CloudIndexClientException {
        try {
            UpdateResponse res = this.solrServer.add(docs);
            log.debug((Object)("feed time for " + docs.size() + " records, elapsed tipe: : " + HumanTime.exactly((long)res.getElapsedTime())));
            this.solrServer.commit();
            if (callback != null) {
                callback.doAfterFeeding(res);
            }
            if (res.getStatus() != 0) {
                throw new CloudIndexClientException("bad status: " + res.getStatus());
            }
        }
        catch (Throwable e) {
            throw new CloudIndexClientException("Error feeding documents", e);
        }
    }

    public SolrInputDocument prepareSolrDocument(String record, String indexDsId, UnaryFunction<String, String> toIndexRecord) throws CloudIndexClientException {
        try {
            StreamingInputDocumentFactory documentFactory = new StreamingInputDocumentFactory();
            String version = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'").format(new Date());
            String indexRecord = (String)toIndexRecord.evaluate((Object)record);
            if (log.isDebugEnabled()) {
                log.debug((Object)("***************************************\nSubmitting index record:\n" + indexRecord + "\n***************************************\n"));
            }
            return documentFactory.parseDocument(version, indexRecord, indexDsId, INDEX_RECORD_RESULT_FIELD);
        }
        catch (Throwable e) {
            throw new CloudIndexClientException("Error creating solr document", e);
        }
    }

    public boolean isRecordIndexed(String id) throws CloudIndexClientException {
        try {
            SolrQuery query = new SolrQuery();
            query.setQuery("objidentifier:\"" + id + "\"");
            QueryResponse res = this.solrServer.query((SolrParams)query);
            return res.getResults().size() > 0;
        }
        catch (Throwable e) {
            throw new CloudIndexClientException("Error searching documents", e);
        }
    }

    public void close() {
        if (this.solrServer != null) {
            this.solrServer.shutdown();
        }
    }

    public static interface AfterFeedingCallback {
        public void doAfterFeeding(UpdateResponse var1);
    }
}

