<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa"
                xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:dnet="eu.dnetlib.actionmanager.actions.infopackage.DMFInfoPackageToHbaseXsltFunctions"
                xmlns:date="eu.dnetlib.miscutils.datetime.DateUtils"
                xmlns:exslt="http://exslt.org/common"
                version="1.0"
                extension-element-prefixes="exslt"
                exclude-result-prefixes="xsl dc dr dri oaa oaf dnet exslt date">

    <xsl:output omit-xml-declaration="yes" indent="yes"/>

    <xsl:param name="trust" select="string('0.9')"/>
    <xsl:param name="provenance" select="string('UNKNOWN')"/>
    <xsl:param name="namespaceprefix" select="string('unknown_____')"/>

    <xsl:template match="/*">
        <xsl:variable name="about" select="/*[local-name() = 'record']/*[local-name() = 'about']"/>
        <xsl:variable name="dateofcollection" select="//dr:dateOfCollection"/>

        <xsl:variable name="metadata" select="exslt:node-set(//*[local-name()='metadata']/*)"/>
        <xsl:variable name="collectedDatasourceid">
            <xsl:choose>
                <xsl:when test="string-length(//oaf:collectedDatasourceid) &gt; 0">
                    <xsl:value-of select="//oaf:collectedDatasourceid"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="UNKNOWN"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:choose>
            <xsl:when test="count($metadata) = 0">
                <ACTIONS/>
            </xsl:when>
            <xsl:otherwise>

                <xsl:variable name="objidentifier" select="/record/*[local-name() = 'header']/*[local-name() = 'objIdentifier']"/>

                <xsl:variable name="resultId" select="dnet:oafSimpleId('result', $objidentifier)"/>

                <xsl:variable name="hostedbyid" select="dnet:oafSplitId('datasource', //oaf:hostedBy/@id)"/>
                <xsl:variable name="hostedbyname" select="//oaf:hostedBy/@name"/>

                <xsl:variable name="collectedfromid" select="dnet:oafSplitId('datasource', //oaf:collectedFrom/@id)"/>
                <xsl:variable name="collectedfromname" select="//oaf:collectedFrom/@name"/>

                <!-- 				<xsl:variable name="country" select="substring(//dr:repositoryCountry,  1, 200)" /> -->
                <!-- 				<xsl:variable name="accessmode" select="substring(//oaf:accessrights,   1, 200)" /> -->

                <xsl:variable name="result"
                              select="dnet:oafResultFromInfoPackage($resultId, $about, $provenance, $trust, $hostedbyid, $hostedbyname, $collectedfromid, $collectedfromname, $objidentifier, $dateofcollection, $metadata)"/>

                <ACTIONS>
                    <ACTION targetKey="{$resultId}" targetColumnFamily="result" targetColumn="{concat('update_', date:now())}">
                        <xsl:value-of select="$result"/>
                    </ACTION>
                </ACTIONS>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
