/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model.gt;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.pace.model.gt.Author;
import eu.dnetlib.pace.model.gt.CoAuthor;
import eu.dnetlib.pace.model.gt.GTAuthor;
import org.apache.commons.lang.StringUtils;

public class GTAuthorMapper {
    public OafProtos.Oaf map(GTAuthor gta) {
        OafProtos.Oaf.Builder oaf = OafProtos.Oaf.newBuilder();
        oaf.setDataInfo(this.getDataInfo());
        oaf.setTimestamp(System.currentTimeMillis());
        oaf.setKind(KindProtos.Kind.entity);
        oaf.setEntity(this.getOafEntity(gta));
        return oaf.build();
    }

    private OafProtos.OafEntity getOafEntity(GTAuthor gta) {
        OafProtos.OafEntity.Builder entity = OafProtos.OafEntity.newBuilder();
        entity.setType(TypeProtos.Type.person);
        entity.setId(gta.getId());
        entity.setPerson(this.getPerson(gta));
        return entity.build();
    }

    private PersonProtos.Person getPerson(GTAuthor gta) {
        PersonProtos.Person.Builder person = PersonProtos.Person.newBuilder();
        if (gta.getAuthor() != null) {
            PersonProtos.Person.Metadata.Builder m = PersonProtos.Person.Metadata.newBuilder();
            if (StringUtils.isNotBlank((String)gta.getAuthor().getFullname())) {
                m.setFullname(this.sf(gta.getAuthor().getFullname()));
            }
            if (StringUtils.isNotBlank((String)gta.getAuthor().getFirstname())) {
                m.setFirstname(this.sf(gta.getAuthor().getFirstname()));
            }
            if (StringUtils.isNotBlank((String)gta.getAuthor().getSecondnames())) {
                m.addSecondnames(this.sf(gta.getAuthor().getSecondnames()));
            }
            person.setMetadata(m.build());
        }
        person.setAnchor(true);
        person.addAllMergedperson(Iterables.transform((Iterable)gta.getMerged(), (Function)new Function<Author, PersonProtos.Person.MergedPerson>(){

            public PersonProtos.Person.MergedPerson apply(Author a) {
                PersonProtos.Person.MergedPerson.Builder mp = PersonProtos.Person.MergedPerson.newBuilder();
                mp.setId(a.getId());
                mp.setMetadata(GTAuthorMapper.this.getMetadata(a));
                return mp.build();
            }
        }));
        person.addAllCoauthor(Iterables.transform((Iterable)gta.getCoAuthors(), (Function)new Function<CoAuthor, PersonProtos.Person.CoAuthor>(){

            public PersonProtos.Person.CoAuthor apply(CoAuthor ca) {
                PersonProtos.Person.CoAuthor.Builder coAuthor = PersonProtos.Person.CoAuthor.newBuilder();
                coAuthor.setId(ca.getId());
                if (StringUtils.isNotBlank((String)ca.getAnchorId())) {
                    coAuthor.setAnchorId(ca.getAnchorId());
                }
                coAuthor.setMetadata(GTAuthorMapper.this.getMetadata((Author)ca));
                return coAuthor.build();
            }
        }));
        return person.build();
    }

    private PersonProtos.Person.Metadata getMetadata(Author a) {
        PersonProtos.Person.Metadata.Builder m = PersonProtos.Person.Metadata.newBuilder();
        m.setFullname(this.sf(a.getFullname()));
        if (a.isWellFormed()) {
            m.setFirstname(this.sf(a.getFirstname()));
            m.addSecondnames(this.sf(a.getSecondnames()));
        }
        return m.build();
    }

    private FieldTypeProtos.DataInfo getDataInfo() {
        FieldTypeProtos.DataInfo.Builder d = FieldTypeProtos.DataInfo.newBuilder();
        d.setDeletedbyinference(false);
        d.setInferred(true);
        d.setTrust("0.5");
        d.setInferenceprovenance("dedup-person-groundtruth");
        d.setProvenanceaction(FieldTypeProtos.Qualifier.newBuilder().setClassid("").setClassname("").setSchemeid("").setSchemename(""));
        return d.build();
    }

    private FieldTypeProtos.StringField sf(String s) {
        FieldTypeProtos.StringField.Builder sf = FieldTypeProtos.StringField.newBuilder();
        sf.setValue(s);
        return sf.build();
    }
}

