/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.miscutils.collections.Pair;
import eu.dnetlib.miscutils.iterators.IterablePair;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractDNetOafXsltFunctions {
    private static final int MAX_NSPREFIX_LEN = 12;
    public static final String URL_REGEX = "^(http|https|ftp)\\://.*";
    protected static Map<String, String> code2name = Maps.newHashMap();
    public static Predicate<String> urlFilter = new Predicate<String>(){

        public boolean apply(String s) {
            return s.trim().matches(AbstractDNetOafXsltFunctions.URL_REGEX);
        }
    };

    protected static OafProtos.Oaf getOaf(OafProtos.OafEntity.Builder entity, FieldTypeProtos.DataInfo.Builder info) {
        return AbstractDNetOafXsltFunctions._getOaf(OafProtos.Oaf.newBuilder(), info).setKind(KindProtos.Kind.entity).setEntity(entity).build();
    }

    protected static OafProtos.Oaf getOaf(OafProtos.OafRel.Builder rel, FieldTypeProtos.DataInfo.Builder info) {
        return AbstractDNetOafXsltFunctions._getOaf(OafProtos.Oaf.newBuilder(), info).setKind(KindProtos.Kind.relation).setRel(rel).build();
    }

    private static OafProtos.Oaf.Builder _getOaf(OafProtos.Oaf.Builder oaf, FieldTypeProtos.DataInfo.Builder info) {
        return oaf.setDataInfo(AbstractDNetOafXsltFunctions.ensureDataInfo(info)).setTimestamp(System.currentTimeMillis());
    }

    protected static FieldTypeProtos.DataInfo.Builder ensureDataInfo(FieldTypeProtos.DataInfo.Builder info) {
        if (info.isInitialized()) {
            return info;
        }
        return AbstractDNetOafXsltFunctions.getDataInfo(null, "UNKNOWN", "0.9", false, false);
    }

    protected static FieldTypeProtos.KeyValue getKV(String id, String name) {
        return FieldTypeProtos.KeyValue.newBuilder().setKey(id).setValue(name).build();
    }

    protected static OafProtos.OafRel.Builder getRel(String sourceId, String targetId, RelTypeProtos.RelType relType, RelTypeProtos.SubRelType subRelType, String relClass, boolean isChild) {
        return OafProtos.OafRel.newBuilder().setSource(sourceId).setTarget(targetId).setRelType(relType).setSubRelType(subRelType).setRelClass(relClass).setChild(isChild);
    }

    protected static OafProtos.OafEntity.Builder getEntity(TypeProtos.Type type, String id, FieldTypeProtos.KeyValue collectedFrom, String originalId, String dateOfCollection, List<FieldTypeProtos.StructuredProperty> pids) {
        OafProtos.OafEntity.Builder builder = OafProtos.OafEntity.newBuilder().setType(type).setId(id).addCollectedfrom(collectedFrom).addOriginalId(originalId).setDateofcollection(dateOfCollection);
        if (pids != null && !pids.isEmpty()) {
            builder.addAllPid(Iterables.filter(pids, (Predicate)Predicates.notNull()));
        }
        return builder;
    }

    public static FieldTypeProtos.DataInfo.Builder getDataInfo(NodeList about, String provenanceaction, String trust, boolean deletedbyinference, boolean inferred) {
        FieldTypeProtos.DataInfo.Builder dataInfoBuilder = FieldTypeProtos.DataInfo.newBuilder();
        dataInfoBuilder.setInferred(Boolean.valueOf(inferred).booleanValue());
        dataInfoBuilder.setDeletedbyinference(Boolean.valueOf(deletedbyinference).booleanValue());
        dataInfoBuilder.setTrust(trust);
        dataInfoBuilder.setProvenanceaction(AbstractDNetOafXsltFunctions.getSimpleQualifier(provenanceaction, "dnet:provenanceActions").build());
        if (about != null && about.getLength() > 0) {
            Element e = AbstractDNetOafXsltFunctions.getDirectChild((Element)about.item(0), "datainfo");
            Element elem = AbstractDNetOafXsltFunctions.getDirectChild(e, "inferred");
            dataInfoBuilder.setInferred(Boolean.valueOf(elem != null ? elem.getTextContent() : String.valueOf(inferred)).booleanValue());
            elem = AbstractDNetOafXsltFunctions.getDirectChild(e, "deletedbyinference");
            dataInfoBuilder.setDeletedbyinference(Boolean.valueOf(elem != null ? elem.getTextContent() : String.valueOf(deletedbyinference)).booleanValue());
            elem = AbstractDNetOafXsltFunctions.getDirectChild(e, "trust");
            dataInfoBuilder.setTrust(elem != null ? elem.getTextContent() : trust);
            elem = AbstractDNetOafXsltFunctions.getDirectChild(e, "inferenceprovenance");
            dataInfoBuilder.setInferenceprovenance(elem != null ? elem.getTextContent() : "");
            elem = AbstractDNetOafXsltFunctions.getDirectChild(e, "provenanceaction");
            FieldTypeProtos.Qualifier.Builder pBuilder = FieldTypeProtos.Qualifier.newBuilder();
            if (elem.hasAttributes()) {
                NamedNodeMap attributes = elem.getAttributes();
                pBuilder.setClassid(attributes.getNamedItem("classid").getNodeValue());
                pBuilder.setClassname(attributes.getNamedItem("classname").getNodeValue());
                pBuilder.setSchemeid(attributes.getNamedItem("schemeid").getNodeValue());
                pBuilder.setSchemename(attributes.getNamedItem("schemename").getNodeValue());
            } else {
                pBuilder.mergeFrom(AbstractDNetOafXsltFunctions.getSimpleQualifier(provenanceaction, "dnet:provenanceActions").build());
            }
            dataInfoBuilder.setProvenanceaction(pBuilder);
        }
        return dataInfoBuilder;
    }

    protected static Element getDirectChild(Element parent, String name) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !name.equals(child.getLocalName())) continue;
            return (Element)child;
        }
        return null;
    }

    protected static FieldTypeProtos.Qualifier.Builder getSimpleQualifier(String classname, String schemename) {
        return AbstractDNetOafXsltFunctions.getQualifier(classname, classname, schemename, schemename);
    }

    protected static FieldTypeProtos.Qualifier.Builder getSimpleQualifier(ProtocolMessageEnum classname, String schemename) {
        return AbstractDNetOafXsltFunctions.getQualifier(classname.toString(), classname.toString(), schemename, schemename);
    }

    protected static FieldTypeProtos.Qualifier.Builder getQualifier(String classid, String classname, String schemeid, String schemename) {
        return FieldTypeProtos.Qualifier.newBuilder().setClassid(classid).setClassname(classname).setSchemeid(schemeid).setSchemename(schemename);
    }

    protected static FieldTypeProtos.Qualifier.Builder setQualifier(FieldTypeProtos.Qualifier.Builder qualifier, List<String> fields) {
        if (fields == null || fields.isEmpty() || fields.get(0).isEmpty()) {
            return null;
        }
        if (fields != null && !fields.isEmpty() && fields.get(0) != null) {
            qualifier.setClassid(fields.get(0));
            qualifier.setClassname(AbstractDNetOafXsltFunctions.getClassName(fields.get(0)));
        }
        return qualifier;
    }

    protected static void addStructuredProps(Message.Builder builder, Descriptors.FieldDescriptor fd, List<String> values, String classid, String schemeid) {
        if (values != null) {
            for (String s : values) {
                AbstractDNetOafXsltFunctions.addField(builder, fd, AbstractDNetOafXsltFunctions.getStructuredProperty(s, classid, classid, schemeid, schemeid));
            }
        }
    }

    protected static List<FieldTypeProtos.StructuredProperty> parsePids(NodeList nodelist) {
        ArrayList pids = Lists.newArrayList();
        block0: for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            if (node.getNodeType() != 1 || !node.getLocalName().toLowerCase().equals("identifier")) continue;
            Node pidType = node.getAttributes().getNamedItem("identifierType");
            for (int j = 0; j < node.getChildNodes().getLength(); ++j) {
                Node child = node.getChildNodes().item(j);
                if (child.getNodeType() != 3 || pidType == null || pidType.getNodeValue() == null || pidType.getNodeValue().isEmpty() || pidType.getNodeValue().equalsIgnoreCase("url")) continue;
                String type = pidType.getNodeValue().toLowerCase();
                String value = child.getTextContent();
                pids.add(AbstractDNetOafXsltFunctions.getStructuredProperty(value, type, AbstractDNetOafXsltFunctions.getClassName(type), "dnet:pid_types", "dnet:pid_types"));
                continue block0;
            }
        }
        return pids;
    }

    protected static void addField(Message.Builder builder, Descriptors.FieldDescriptor descriptor, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof List) {
            for (Object o : (List)value) {
                AbstractDNetOafXsltFunctions.addField(builder, descriptor, o);
            }
        } else {
            Object fieldValue = value;
            switch (descriptor.getType()) {
                case BOOL: {
                    fieldValue = Boolean.valueOf(value.toString());
                    break;
                }
                case BYTES: {
                    fieldValue = value.toString().getBytes(Charset.forName("UTF-8"));
                    break;
                }
                case DOUBLE: {
                    fieldValue = Double.valueOf(value.toString());
                    break;
                }
                case FLOAT: {
                    fieldValue = Float.valueOf(value.toString());
                    break;
                }
                case INT32: 
                case INT64: 
                case SINT32: 
                case SINT64: {
                    fieldValue = Integer.valueOf(value.toString());
                    break;
                }
                case MESSAGE: {
                    Message.Builder q = builder.newBuilderForField(descriptor);
                    if (value instanceof Message.Builder) {
                        value = ((Message.Builder)value).build();
                        byte[] b = ((Message)value).toByteArray();
                        try {
                            q.mergeFrom(b);
                        }
                        catch (InvalidProtocolBufferException e) {
                            throw new IllegalArgumentException("Unable to merge value: " + value + " with builder: " + q.getDescriptorForType().getName());
                        }
                    } else if (FieldTypeProtos.Qualifier.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.Qualifier) {
                            q.mergeFrom((Message)((FieldTypeProtos.Qualifier)value));
                        } else {
                            AbstractDNetOafXsltFunctions.parseMessage(q, FieldTypeProtos.Qualifier.getDescriptor(), value.toString(), "@@@");
                        }
                    } else if (FieldTypeProtos.StructuredProperty.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.StructuredProperty) {
                            q.mergeFrom((Message)((FieldTypeProtos.StructuredProperty)value));
                        } else {
                            AbstractDNetOafXsltFunctions.parseMessage(q, FieldTypeProtos.StructuredProperty.getDescriptor(), value.toString(), "###");
                        }
                    } else if (FieldTypeProtos.KeyValue.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.KeyValue) {
                            q.mergeFrom((Message)((FieldTypeProtos.KeyValue)value));
                        } else {
                            AbstractDNetOafXsltFunctions.parseMessage(q, FieldTypeProtos.KeyValue.getDescriptor(), value.toString(), "&&&");
                        }
                    } else if (FieldTypeProtos.StringField.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.StringField) {
                            q.mergeFrom((Message)((FieldTypeProtos.StringField)value));
                        } else {
                            q.setField(FieldTypeProtos.StringField.getDescriptor().findFieldByName("value"), value);
                        }
                    } else if (FieldTypeProtos.BoolField.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.BoolField) {
                            q.mergeFrom((Message)((FieldTypeProtos.BoolField)value));
                        } else if (value instanceof String) {
                            q.setField(FieldTypeProtos.BoolField.getDescriptor().findFieldByName("value"), (Object)Boolean.valueOf((String)value));
                        } else {
                            q.setField(FieldTypeProtos.BoolField.getDescriptor().findFieldByName("value"), value);
                        }
                    } else if (FieldTypeProtos.IntField.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.IntField) {
                            q.mergeFrom((Message)((FieldTypeProtos.IntField)value));
                        } else if (value instanceof String) {
                            q.setField(FieldTypeProtos.IntField.getDescriptor().findFieldByName("value"), (Object)NumberUtils.toInt((String)((String)value)));
                        } else {
                            q.setField(FieldTypeProtos.IntField.getDescriptor().findFieldByName("value"), value);
                        }
                    }
                    fieldValue = q.buildPartial();
                    break;
                }
            }
            AbstractDNetOafXsltFunctions.doAddField(builder, descriptor, fieldValue);
        }
    }

    protected static void doAddField(Message.Builder builder, Descriptors.FieldDescriptor fd, Object value) {
        if (value != null) {
            if (fd.isRepeated()) {
                builder.addRepeatedField(fd, value);
            } else if (fd.isOptional() || fd.isRequired()) {
                builder.setField(fd, value);
            }
        }
    }

    protected static void parseMessage(Message.Builder builder, Descriptors.Descriptor descriptor, String value, String split) {
        IterablePair iterablePair = new IterablePair(descriptor.getFields(), (List)Lists.newArrayList((Iterable)Splitter.on((String)split).trimResults().split((CharSequence)value)));
        for (Pair p : iterablePair) {
            AbstractDNetOafXsltFunctions.addField(builder, (Descriptors.FieldDescriptor)p.getKey(), p.getValue());
        }
    }

    protected static String base64(byte[] data) {
        return new String(Base64.encodeBase64((byte[])data));
    }

    public static String replace(String s, String regex, String replacement) {
        return s.replaceAll(regex, replacement);
    }

    public static String trim(String s) {
        return s.trim();
    }

    protected static String removePrefix(TypeProtos.Type type, String s) {
        return AbstractDNetOafXsltFunctions.removePrefix(type.toString(), s);
    }

    private static String removePrefix(String prefix, String s) {
        return StringUtils.removeStart((String)("" + s), (String)(prefix + "|"));
    }

    protected static FieldTypeProtos.Qualifier.Builder getDefaultQualifier(String scheme) {
        FieldTypeProtos.Qualifier.Builder qualifier = FieldTypeProtos.Qualifier.newBuilder().setSchemeid(scheme).setSchemename(scheme);
        return qualifier;
    }

    protected static FieldTypeProtos.StructuredProperty getStructuredProperty(String value, String classid, String classname, String schemeid, String schemename) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return FieldTypeProtos.StructuredProperty.newBuilder().setValue(value).setQualifier(AbstractDNetOafXsltFunctions.getQualifier(classid, classname, schemeid, schemename)).build();
    }

    protected static FieldTypeProtos.StringField.Builder sf(String s) {
        return FieldTypeProtos.StringField.newBuilder().setValue(s);
    }

    public static String generateNsPrefix(String prefix, String externalId) {
        return StringUtils.substring((String)(prefix + StringUtils.leftPad((String)externalId, (int)(12 - prefix.length()), (String)"_")), (int)0, (int)12);
    }

    public static String md5(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(s.getBytes("UTF-8"));
            return new String(Hex.encodeHex((byte[])md.digest()));
        }
        catch (Exception e) {
            System.err.println("Error creating id");
            return null;
        }
    }

    public static String oafId(String entityType, String prefix, String id) {
        if (id.isEmpty() || prefix.isEmpty()) {
            return "";
        }
        return AbstractDNetOafXsltFunctions.oafSimpleId(entityType, prefix + "::" + AbstractDNetOafXsltFunctions.md5(id));
    }

    public static String oafPersonId(String entityType, String prefix, String parentId, String localId, Map<String, Object> map) {
        Object val;
        if (MapUtils.isNotEmpty(map) && (val = map.get(prefix)) != null && val.equals("true")) {
            String oafId = AbstractDNetOafXsltFunctions.oafId(entityType, prefix, localId);
            return oafId;
        }
        String oafId = AbstractDNetOafXsltFunctions.oafId(entityType, prefix, parentId + "::" + localId);
        return oafId;
    }

    public static String oafSimpleId(String entityType, String id) {
        return (TypeProtos.Type.valueOf((String)entityType).getNumber() + "|" + id).replaceAll("\\s|\\n", "");
    }

    public static String oafSplitId(String entityType, String fullId) {
        return AbstractDNetOafXsltFunctions.oafId(entityType, StringUtils.substringBefore((String)fullId, (String)"::"), StringUtils.substringAfter((String)fullId, (String)"::"));
    }

    public static String getClassName(String code) {
        String classname = code2name.get(code);
        if (StringUtils.isBlank((String)classname)) {
            return code;
        }
        return classname;
    }

    public static Object lookupValue(Map<String, Object> map, String key) {
        return map.get(key);
    }

    public static int mustMerge(Map<String, Object> map, String key) {
        Object val = AbstractDNetOafXsltFunctions.lookupValue(map, key);
        return val != null && val instanceof String && val.equals("true") ? 1 : 0;
    }

    static {
        code2name.put("MO", "Macao");
        code2name.put("UK", "United Kingdom");
        code2name.put("WF", "WALLIS AND FUTUNA");
        code2name.put("srp", "Serbian");
        code2name.put("FM", "MICRONESIA, FEDERATED STATES OF");
        code2name.put("PendingRepositoryResources", "Pending datasource");
        code2name.put("12MONTHS", "12 Months Embargo");
        code2name.put("chy", "Cheyenne");
        code2name.put("yid", "Yiddish");
        code2name.put("sword", "sword");
        code2name.put("aggregator::pubsrepository::institutional", "Aggregator of Institutional Publication Repositories");
        code2name.put("LSID", "LSID");
        code2name.put("BO", "Bolivia");
        code2name.put("0008", "Bachelor thesis");
        code2name.put("CW", "CURA\u00c3\u0087AO");
        code2name.put("PURL", "PURL");
        code2name.put("HR", "Croatia");
        code2name.put("KM", "COMOROS");
        code2name.put("VU", "VANUATU");
        code2name.put("CU", "Cuba");
        code2name.put("MN", "MONGOLIA");
        code2name.put("RepositoryServiceResources", "Valid datasource");
        code2name.put("cop", "Coptic");
        code2name.put("cpe", "English-based Creoles and Pidgins");
        code2name.put("ine", "Indo-European");
        code2name.put("ipk", "Inupiaq");
        code2name.put("ira", "Iranian");
        code2name.put("max", "Manx");
        code2name.put("men", "Mende");
        code2name.put("mga", "Middle Irish");
        code2name.put("sco", "Scots");
        code2name.put("scr", "Serbo-Croatian");
        code2name.put("yao", "Yao");
        code2name.put("yap", "Yap");
        code2name.put("yor", "Yoruba");
        code2name.put("api", "api");
        code2name.put("file", "file");
        code2name.put("files_from_metadata", "files_from_metadata");
        code2name.put("ftp", "ftp");
        code2name.put("0009", "External research report");
        code2name.put("UPC", "UPC");
        code2name.put("CK", "COOK ISLANDS");
        code2name.put("CZ", "Czech Republic");
        code2name.put("MS", "MONTSERRAT");
        code2name.put("MW", "Malawi");
        code2name.put("MV", "Maldives");
        code2name.put("MH", "Marshall Islands");
        code2name.put("URL", "URL");
        code2name.put("CG", "Congo");
        code2name.put("DK", "Denmark");
        code2name.put("VI", "VIRGIN ISLANDS, U.S.");
        code2name.put("cpf", "French-based Creoles and Pidgins");
        code2name.put("mic", "Micmac");
        code2name.put("min", "Minangkabau");
        code2name.put("sel", "Selkup");
        code2name.put("sem", "Semitic");
        code2name.put("sga", "old Irish");
        code2name.put("zap", "Zapotec");
        code2name.put("zen", "Zenaga");
        code2name.put("http", "http");
        code2name.put("jdbc", "jdbc");
        code2name.put("cpp", "Portuguese-based Creoles and Pidgins");
        code2name.put("crp", "Creoles and Pidgins");
        code2name.put("oai", "oai");
        code2name.put("mis", "Miscellaneous");
        code2name.put("mkh", "Mon-Kmer");
        code2name.put("mni", "Manipuri");
        code2name.put("mno", "Manobo");
        code2name.put("moh", "Mohawk");
        code2name.put("shn", "Shan");
        code2name.put("sid", "Sidamo");
        code2name.put("sio", "Siouan");
        code2name.put("sit", "Sino-Tibetan");
        code2name.put("zha", "Zhuang; Chuang");
        code2name.put("other", "other");
        code2name.put("rest", "rest");
        code2name.put("soap", "soap");
        code2name.put("sparql", "sparql");
        code2name.put("zul", "Zulu");
        code2name.put("zun", "Zuni");
        code2name.put("file::EuropePMC", "file::EuropePMC");
        code2name.put("mos", "Mossi");
        code2name.put("sla", "Slavic");
        code2name.put("iro", "Iroquoian");
        code2name.put("slk/slo", "Slovak");
        code2name.put("httpCSV", "httpCSV");
        code2name.put("IS", "Iceland");
        code2name.put("NA", "Namibia");
        code2name.put("QA", "Qatar");
        code2name.put("endDate", "endDate");
        code2name.put("issued", "issued");
        code2name.put("CIP-EIP-TN", "CIP-Eco-Innovation - CIP-Thematic Network");
        code2name.put("ace", "Achinese");
        code2name.put("akk", "Akkadian");
        code2name.put("alb/sqi", "Albanian");
        code2name.put("bra", "Braj");
        code2name.put("bua", "Buriat");
        code2name.put("0019", "Patent");
        code2name.put("NL", "Netherlands");
        code2name.put("RO", "Romania");
        code2name.put("CP", "Collaborative project");
        code2name.put("ach", "Acoli");
        code2name.put("bug", "Buginese");
        code2name.put("dra", "Dravidian");
        code2name.put("dua", "Duala");
        code2name.put("dum", "Middle Dutch");
        code2name.put("epo", "Esperanto");
        code2name.put("esk", "Eskimo");
        code2name.put("jav/jaw", "Javanese");
        code2name.put("jpr", "Judeo-Persian");
        code2name.put("0018", "Annotation");
        code2name.put("mun", "Munda");
        code2name.put("mus", "Creek");
        code2name.put("mwr", "Marwari");
        code2name.put("myn", "Mayan");
        code2name.put("smi", "Sami");
        code2name.put("sog", "Sogdian");
        code2name.put("son", "Songhai");
        code2name.put("sot", "Sotho, Southern");
        code2name.put("tgk", "Tajik");
        code2name.put("arxiv", "arXiv");
        code2name.put("datasetsbyproject", "datasetsbyproject");
        code2name.put("oai_sets", "oai_sets");
        code2name.put("0021", "Dataset");
        code2name.put("VA", "HOLY SEE (VATICAN CITY STATE)");
        code2name.put("HT", "Haiti");
        code2name.put("IN", "India");
        code2name.put("ID", "Indonesia");
        code2name.put("RU", "Russian Federation");
        code2name.put("CP-CSA", "Combination of CP & CSA");
        code2name.put("CSA", "Coordination and support action");
        code2name.put("ada", "Adangme");
        code2name.put("HN", "Honduras");
        code2name.put("HK", "Hong Kong");
        code2name.put("IR", "Iran (Islamic Republic of)");
        code2name.put("IL", "Israel");
        code2name.put("RW", "Rwanda");
        code2name.put("RE", "R\u00c3\u0089UNION");
        code2name.put("BL", "SAINT BARTH\u00c3\u0089LEMY");
        code2name.put("afa", "Afro-Asiatic");
        code2name.put("afh", "Afrihili");
        code2name.put("dyu", "Dyula");
        code2name.put("efi", "Efik");
        code2name.put("egy", "Ancient Egyptian");
        code2name.put("jrb", "Judeo-Arabic");
        code2name.put("kaa", "Kara-Kalpak");
        code2name.put("kab", "Kabyle");
        code2name.put("nah", "Aztec");
        code2name.put("nai", "North American Indian");
        code2name.put("spa", "Spanish; Castilian");
        code2name.put("srd", "Sardinian");
        code2name.put("srr", "Serer");
        code2name.put("HU", "Hungary");
        code2name.put("IQ", "IRAQ");
        code2name.put("SH", "SAINT HELENA, ASCENSION AND TRISTAN DA CUNHA");
        code2name.put("afr", "Afrikaans");
        code2name.put("kac", "Kachin");
        code2name.put("nde", "Ndebele, North");
        code2name.put("ssa", "Nilo-Saharan");
        code2name.put("ssw", "Swati");
        code2name.put("suk", "Sukuma");
        code2name.put("kam", "Kamba");
        code2name.put("kan", "Kannada");
        code2name.put("kar", "Karen");
        code2name.put("ndo", "Ndonga");
        code2name.put("nep", "Nepali");
        code2name.put("new", "Newari");
        code2name.put("sun", "Sundanese");
        code2name.put("niu", "Niuean");
        code2name.put("non", "Norse");
        code2name.put("sux", "Sumerian");
        code2name.put("wos", "Web of Science Subject Areas");
        code2name.put("ISTC", "ISTC");
        code2name.put("KZ", "Kazakhstan");
        code2name.put("KG", "Kyrgyzstan");
        code2name.put("sysimport:crosswalk:repository", "sysimport:crosswalk:repository");
        code2name.put("alg", "Algonquian languages");
        code2name.put("ava", "Avaric");
        code2name.put("fon", "Fon");
        code2name.put("fra/fre", "French");
        code2name.put("fry", "Frisian");
        code2name.put("kha", "Khasi");
        code2name.put("kro", "Kru");
        code2name.put("nso", "Sotho");
        code2name.put("fileGzip", "fileGzip");
        code2name.put("FR", "France");
        code2name.put("KE", "Kenya");
        code2name.put("syr", "Syriac");
        code2name.put("tem", "Timne");
        code2name.put("aggregator::datarepository", "Aggregator of Data Repositories");
        code2name.put("aggregator::pubsrepository::journals", "Aggregator/Publisher of Journals");
        code2name.put("ISSN", "ISSN");
        code2name.put("JP", "Japan");
        code2name.put("JO", "Jordan");
        code2name.put("fre/fra", "French");
        code2name.put("KR", "Korea (Republic of)");
        code2name.put("PT", "Portugal");
        code2name.put("driver-openaire2.0", "OpenAIRE 2.0+ (DRIVER OA, EC funding)");
        code2name.put("sysimport:crosswalk:entityregistry", "sysimport:crosswalk:entityregistry");
        code2name.put("sysimport:crosswalk:infospace", "sysimport:crosswalk:infospace");
        code2name.put("ale", "Aleut");
        code2name.put("ang", "Old English");
        code2name.put("apa", "Apache");
        code2name.put("arc", "Aramaic");
        code2name.put("ave", "Avestan");
        code2name.put("sve/swe", "Swedish");
        code2name.put("ewo", "Ewondo");
        code2name.put("fan", "Fang");
        code2name.put("fas/per", "Persian");
        code2name.put("khi", "Khoisan");
        code2name.put("kho", "Khotanese");
        code2name.put("kok", "Konkani");
        code2name.put("nub", "Nubian");
        code2name.put("nym", "Nyamwezi");
        code2name.put("nyn", "Nyankole");
        code2name.put("nyo", "Nyoro");
        code2name.put("ter", "Tereno");
        code2name.put("tgl", "Tagalog");
        code2name.put("KI", "KIRIBATI");
        code2name.put("arn", "Araucanian");
        code2name.put("arp", "Arapaho");
        code2name.put("fat", "Fanti");
        code2name.put("fin", "Finnish");
        code2name.put("fiu", "Finno-Ugrian");
        code2name.put("kon", "Kongo");
        code2name.put("kor", "Korean");
        code2name.put("kpe", "Kpelle");
        code2name.put("nzi", "Nzima");
        code2name.put("osa", "Osage");
        code2name.put("oss", "Ossetian; Ossetic");
        code2name.put("tha", "Thai");
        code2name.put("tib/bod", "Tibetan");
        code2name.put("tig", "Tigre");
        code2name.put("tir", "Tigrinya");
        code2name.put("KP", "KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF");
        code2name.put("XK", "Kosovo * UN resolution");
        code2name.put("art", "Artificial");
        code2name.put("arw", "Arawak");
        code2name.put("asm", "Assamese");
        code2name.put("frm", "Middle French");
        code2name.put("fro", "Old French");
        code2name.put("kru", "Kurukh");
        code2name.put("kua", "Kuanyama; Kwanyama");
        code2name.put("ota", "Ottoman");
        code2name.put("oto", "Otomian");
        code2name.put("kum", "Kumyk");
        code2name.put("ath", "Athapascan");
        code2name.put("user:insert", "user:insert");
        code2name.put("awa", "Awadhi");
        code2name.put("bad", "Banda");
        code2name.put("ben", "Bengali");
        code2name.put("ber", "Berber");
        code2name.put("eka", "Ekajuk");
        code2name.put("gaa", "Ga");
        code2name.put("gae/gdh", "Gaelic");
        code2name.put("gai/iri", "Irish");
        code2name.put("gay", "Gayo");
        code2name.put("kus", "Kusaie");
        code2name.put("kut", "Kutenai");
        code2name.put("lad", "Ladino");
        code2name.put("lah", "Lahnda");
        code2name.put("paa", "Papuan-Australian");
        code2name.put("pag", "Pangasinan");
        code2name.put("pal", "Pahlavi");
        code2name.put("pam", "Pampanga");
        code2name.put("pap", "Papiamento");
        code2name.put("pau", "Palauan");
        code2name.put("tiv", "Tivi");
        code2name.put("tli", "Tlingit");
        code2name.put("tmh", "Tamashek");
        code2name.put("tum", "Tumbuka");
        code2name.put("ec:frameworkprogram", "frameworkprogram");
        code2name.put("tog", "Tonga(Nyasa)");
        code2name.put("tru", "Truk");
        code2name.put("tsi", "Tsimshian");
        code2name.put("ec:program", "program");
        code2name.put("ec:specificprogram", "specificprogram");
        code2name.put("hostedBy", "not available");
        code2name.put("GP", "GUADELOUPE");
        code2name.put("GT", "Guatemala");
        code2name.put("collection", "collection");
        code2name.put("0022", "Collection");
        code2name.put("0027", "Model");
        code2name.put("0023", "Event");
        code2name.put("0024", "Film");
        code2name.put("0025", "Image");
        code2name.put("0026", "InteractiveResource");
        code2name.put("GD", "GRENADA");
        code2name.put("GU", "GUAM");
        code2name.put("GG", "GUERNSEY");
        code2name.put("GA", "Gabon");
        code2name.put("GL", "Greenland");
        code2name.put("GY", "Guyana");
        code2name.put("LR", "LIBERIA");
        code2name.put("LV", "Latvia");
        code2name.put("LB", "Lebanon");
        code2name.put("LS", "Lesotho");
        code2name.put("PW", "PALAU");
        code2name.put("subtitle", "subtitle");
        code2name.put("translated title", "translated title");
        code2name.put("bai", "Bamileke");
        code2name.put("bal", "Baluchi");
        code2name.put("ell/gre", "Greek");
        code2name.put("elx", "Elamite");
        code2name.put("gem", "Germanic");
        code2name.put("lam", "Lamba");
        code2name.put("user:claim:search", "user:claim:search");
        code2name.put("ban", "Balinese");
        code2name.put("bas", "Basa");
        code2name.put("enm", "Middle English");
        code2name.put("gez", "Geez");
        code2name.put("lez", "Lezghian");
        code2name.put("lin", "Lingala");
        code2name.put("lit", "Lithuanian");
        code2name.put("lol", "Mongo");
        code2name.put("peo", "Persian, Old (ca 600 - 400 B.C.)");
        code2name.put("phn", "Phoenician");
        code2name.put("pus", "Pushto");
        code2name.put("tut", "Altaic");
        code2name.put("tyv", "Tuvinian");
        code2name.put("uga", "Ugaritic");
        code2name.put("bat", "Baltic");
        code2name.put("bej", "Beja");
        code2name.put("bel", "Belarusian");
        code2name.put("gil", "Gilbertese");
        code2name.put("glg", "Galician");
        code2name.put("gmh", "Middle High German");
        code2name.put("goh", "Old High German");
        code2name.put("loz", "Lozi");
        code2name.put("ltz", "Letzeburgesch; Luxembourgish");
        code2name.put("gon", "Gondi");
        code2name.put("DOI", "DOI");
        code2name.put("IsCitedBy", "IsCitedBy");
        code2name.put("dataset", "dataset");
        code2name.put("bho", "Bhojpuri");
        code2name.put("got", "Gothic");
        code2name.put("AG", "ANTIGUA AND BARBUDA");
        code2name.put("IsPartOf", "IsPartOf");
        code2name.put("IE", "Ireland");
        code2name.put("bik", "Bikol");
        code2name.put("lui", "Luiseno");
        code2name.put("grb", "Grebo");
        code2name.put("AW", "ARUBA");
        code2name.put("lun", "Lunda");
        code2name.put("luo", "Luo");
        code2name.put("raj", "Rajasthani");
        code2name.put("IM", "ISLE OF MAN");
        code2name.put("umb", "Umbundu");
        code2name.put("rar", "Rarotongan");
        code2name.put("roa", "Romance");
        code2name.put("rom", "Romany");
        code2name.put("LY", "Libyan Arab Jamahiriya");
        code2name.put("dnet:od_subjects", "OpenDOAR subjects");
        code2name.put("EAN13", "EAN13");
        code2name.put("grc", "Ancient Greek");
        code2name.put("vai", "Vai");
        code2name.put("vie", "Vietnamese");
        code2name.put("vol", "Volap\u00fck");
        code2name.put("0028", "Service");
        code2name.put("EISSN", "EISSN");
        code2name.put("IT", "Italy");
        code2name.put("JE", "JERSEY");
        code2name.put("LI", "Liechtenstein");
        code2name.put("ddc", "Dewey Decimal Classification");
        code2name.put("event", "event");
        code2name.put("IsReferencedBy", "IsReferencedBy");
        code2name.put("JM", "Jamaica");
        code2name.put("LT", "Lithuania");
        code2name.put("0029", "Software");
        code2name.put("bin", "Bini");
        code2name.put("hai", "Haida");
        code2name.put("mac/mak", "Macedonian");
        code2name.put("vot", "Votic");
        code2name.put("wak", "Wakashan");
        code2name.put("mesheuropmc", "Medical Subject Headings");
        code2name.put("image", "image");
        code2name.put("interactiveResource", "interactiveResource");
        code2name.put("model", "model");
        code2name.put("physicalObject", "physicalObject");
        code2name.put("0030", "Sound");
        code2name.put("References", "References");
        code2name.put("ARK", "ARK");
        code2name.put("isRelatedTo", "isRelatedTo");
        code2name.put("coauthor", "coauthor");
        code2name.put("Handle", "Handle");
        code2name.put("ISBN", "ISBN");
        code2name.put("LISSN", "LISSN");
        code2name.put("LU", "Luxembourg");
        code2name.put("MQ", "MARTINIQUE");
        code2name.put("MR", "MAURITANIA");
        code2name.put("bla", "Siksika");
        code2name.put("bnt", "Bantu");
        code2name.put("bod/tib", "Tibetan");
        code2name.put("hat", "Haitian; Haitian Creole");
        code2name.put("hau", "Hausa");
        code2name.put("haw", "Hawaiian");
        code2name.put("mad", "Madurese");
        code2name.put("ron/rum", "Romanian");
        code2name.put("mag", "Magahi");
        code2name.put("mai", "Maithili");
        code2name.put("rus", "Russian");
        code2name.put("sad", "Sandawe");
        code2name.put("sah", "Yakut");
        code2name.put("wal", "Walamo");
        code2name.put("war", "Waray");
        code2name.put("service", "service");
        code2name.put("software", "software");
        code2name.put("URN", "URN");
        code2name.put("YT", "MAYOTTE");
        code2name.put("heb", "Hebrew");
        code2name.put("mak", "Makasar");
        code2name.put("sai", "South American Indian");
        code2name.put("was", "Washo");
        code2name.put("sound", "sound");
        code2name.put("man", "Mandingo");
        code2name.put("wen", "Sorbian");
        code2name.put("map", "Austronesian");
        code2name.put("sal", "Salishan");
        code2name.put("mas", "Masai");
        code2name.put("sam", "Samaritan");
        code2name.put("hil", "Hiligaynon");
        code2name.put("hmo", "Hiri Motu");
        code2name.put("dan", "Danish");
        code2name.put("div", "Divehi");
        code2name.put("hun", "Hungarian");
        code2name.put("ibo", "Igbo");
        code2name.put("kik", "Gikuyu; Kikuyu");
        code2name.put("lug", "Ganda");
        code2name.put("nic", "Niger-Kordofanian");
        code2name.put("nob", "Bokm\u00e5l, Norwegian; Norwegian Bokm\u00e5l");
        code2name.put("AF", "AFGHANISTAN");
        code2name.put("AZ", "Azerbaijan");
        code2name.put("CM", "Cameroon");
        code2name.put("CR", "Costa Rica");
        code2name.put("CI", "Cote d'Ivoire");
        code2name.put("VE", "Venezuela");
        code2name.put("VG", "Virgin Islands (British)");
        code2name.put("EH", "WESTERN SAHARA");
        code2name.put("BSG", "Research for the benefit of specific groups");
        code2name.put("NoE", "Network of Excellence");
        code2name.put("aar", "Afar");
        code2name.put("arm/hye", "Armenian");
        code2name.put("aym", "Aymara");
        code2name.put("aze", "Azerbaijani");
        code2name.put("bak", "Bashkir");
        code2name.put("bam", "Bambara");
        code2name.put("baq/eus", "Basque");
        code2name.put("bih", "Bihari");
        code2name.put("bre", "Breton");
        code2name.put("bul", "Bulgarian");
        code2name.put("cat", "Catalan; Valencian");
        code2name.put("cha", "Chamorro");
        code2name.put("che", "Chechen");
        code2name.put("cor", "Cornish");
        code2name.put("dut/nld", "Dutch; Flemish");
        code2name.put("dzo", "Dzongkha");
        code2name.put("eng", "English");
        code2name.put("est", "Estonian");
        code2name.put("fij", "Fijian");
        code2name.put("ful", "Fulah");
        code2name.put("geo/kat", "Georgian");
        code2name.put("gla", "Gaelic; Scottish Gaelic");
        code2name.put("gre/ell", "Greek, Modern (1453-)");
        code2name.put("grn", "Guarani");
        code2name.put("guj", "Gujarati");
        code2name.put("ice/isl", "Icelandic");
        code2name.put("nya", "Chewa; Chichewa; Nyanja");
        code2name.put("DFG", "DFG Classification");
        code2name.put("pubsrepository::mock", "Mock Publication Repository");
        code2name.put("scholarcomminfra", "Scholarly Communication Infrastructure");
        code2name.put("EU", "European Union");
        code2name.put("scr/hrv", "Croatian");
        code2name.put("GF", "French Guiana");
        code2name.put("GR", "GREECE");
        code2name.put("abk", "Abkhazian");
        code2name.put("amh", "Amharic");
        code2name.put("ara", "Arabic");
        code2name.put("arg", "Aragonese");
        code2name.put("cos", "Corsican");
        code2name.put("cre", "Cree");
        code2name.put("cze/ces", "Czech");
        code2name.put("her", "Herero");
        code2name.put("ind", "Indonesian");
        code2name.put("kal", "Greenlandic; Kalaallisut");
        code2name.put("HM", "HEARD ISLAND AND MCDONALD ISLANDS");
        code2name.put("AE", "United Arab Emirates");
        code2name.put("bis", "Bislama");
        code2name.put("ewe", "Ewe");
        code2name.put("bos", "Bosnian");
        code2name.put("fao", "Faroese");
        code2name.put("ger/deu", "German");
        code2name.put("ton", "Tonga (Tonga Islands)");
        code2name.put("und", "Undetermined");
        code2name.put("pubsrepository::thematic", "Thematic Publication Repository");
        code2name.put("urd", "Urdu");
        code2name.put("uzb", "Uzbek");
        code2name.put("doi", "doi");
        code2name.put("IsNewVersionOf", "IsNewVersionOf");
        code2name.put("smo", "Samoan");
        code2name.put("nau", "Nauru");
        code2name.put("nor", "Norwegian");
        code2name.put("esl/spa", "Spanish");
        code2name.put("iii", "Sichuan Yi");
        code2name.put("que", "Quechua");
        code2name.put("AS", "AMERICAN SAMOA");
        code2name.put("ita", "Italian");
        code2name.put("BI", "Burundi");
        code2name.put("sin", "Sinhala; Sinhalese");
        code2name.put("may/msa", "Malay");
        code2name.put("tsn", "Tswana");
        code2name.put("tso", "Tsonga");
        code2name.put("CD", "Congo (Democratic Republic of)");
        code2name.put("FJ", "Fiji");
        code2name.put("GM", "Gambia");
        code2name.put("kaz", "Kazakh");
        code2name.put("GW", "Guinea-Bissau");
        code2name.put("KW", "Kuwait");
        code2name.put("mac/mkd", "Macedonian");
        code2name.put("scc/srp", "Serbian");
        code2name.put("kur", "Kurdish");
        code2name.put("LA", "Lao (People's Democratic Republic)");
        code2name.put("UNKNOWN", "UNKNOWN");
        code2name.put("mah", "Marshallese");
        code2name.put("IsPreviousVersionOf", "IsPreviousVersionOf");
        code2name.put("gle", "Irish");
        code2name.put("glv", "Manx");
        code2name.put("iku", "Inuktitut");
        code2name.put("mlg", "Malagasy");
        code2name.put("ile", "Interlingue");
        code2name.put("jav", "Javanese");
        code2name.put("jpn", "Japanese");
        code2name.put("nav", "Navajo; Navaho");
        code2name.put("khm", "Khmer");
        code2name.put("kin", "Kinyarwanda");
        code2name.put("lao", "Lao");
        code2name.put("lat", "Latin");
        code2name.put("oci", "Occitan (post 1500); Proven\u00e7al");
        code2name.put("lav", "Latvian");
        code2name.put("mal", "Malayalam");
        code2name.put("mao/mri", "Maori");
        code2name.put("mlt", "Maltese");
        code2name.put("mol", "Moldavian");
        code2name.put("nbl", "Ndebele, South");
        code2name.put("oji", "Ojibwa");
        code2name.put("ori", "Oriya");
        code2name.put("pan", "Panjabi; Punjabi");
        code2name.put("per/fas", "Persian");
        code2name.put("pli", "Pali");
        code2name.put("roh", "Raeto-Romance");
        code2name.put("pol", "Polish");
        code2name.put("rum/ron", "Romanian");
        code2name.put("slo/slk", "Slovak");
        code2name.put("run", "Rundi");
        code2name.put("slv", "Slovenian");
        code2name.put("sme", "Northern Sami");
        code2name.put("sna", "Shona");
        code2name.put("snd", "Sindhi");
        code2name.put("som", "Somali");
        code2name.put("sus", "Susu");
        code2name.put("swe", "Swedish");
        code2name.put("swa", "Swahili");
        code2name.put("tah", "Tahitian");
        code2name.put("tam", "Tamil");
        code2name.put("tat", "Tatar");
        code2name.put("tuk", "Turkmen");
        code2name.put("tur", "Turkish");
        code2name.put("ven", "Venda");
        code2name.put("kir", "Kirghiz");
        code2name.put("mon", "Mongolian");
        code2name.put("orm", "Oromo");
        code2name.put("sag", "Sango");
        code2name.put("kom", "Komi");
        code2name.put("mar", "Marathi");
        code2name.put("tel", "Telugu");
        code2name.put("twi", "Twi");
        code2name.put("ukr", "Ukrainian");
        code2name.put("OPEN", "Open Access");
        code2name.put("171", "Article 171 of the Treaty");
        code2name.put("film", "film");
        code2name.put("providedBy", "provided by");
        code2name.put("dataset_dataset", "dataset_dataset");
        code2name.put("publication_dataset", "publication_dataset");
        code2name.put("publication_publication", "publication_publication");
        code2name.put("coordinator", "coordinator");
        code2name.put("participant", "participant");
        code2name.put("subcontractor", "subcontractor");
        code2name.put("principal investigating", "principal investigating");
        code2name.put("exploitation", "exploitation");
        code2name.put("DM", "DOMINICA");
        code2name.put("BS", "BAHAMAS");
        code2name.put("KY", "CAYMAN ISLANDS");
        code2name.put("wt:fundingStream", "Wellcome Trust: Funding Stream");
        code2name.put("MY", "Malaysia");
        code2name.put("0012", "Newsletter");
        code2name.put("alternative title", "alternative title");
        code2name.put("0014", "Research");
        code2name.put("AX", "\u00c3LAND ISLANDS");
        code2name.put("main title", "main title");
        code2name.put("GQ", "EQUATORIAL GUINEA");
        code2name.put("ML", "Mali");
        code2name.put("driver", "OpenAIRE Basic (DRIVER OA)");
        code2name.put("wt:hasParentFunding", "wt:hasParentFunding");
        code2name.put("OTHER", "Other");
        code2name.put("openaire2.0", "OpenAIRE 2.0 (EC funding)");
        code2name.put("RESTRICTED", "Restricted");
        code2name.put("0020", "Other");
        code2name.put("0013", "Part of book or chapter of book");
        code2name.put("0016", "Preprint");
        code2name.put("aka", "Akan");
        code2name.put("TD", "CHAD");
        code2name.put("author", "author");
        code2name.put("isResultOf", "isResultOf");
        code2name.put("0015", "Review");
        code2name.put("AD", "ANDORRA");
        code2name.put("AI", "ANGUILLA");
        code2name.put("BZ", "BELIZE");
        code2name.put("CX", "CHRISTMAS ISLAND");
        code2name.put("ER", "ERITREA");
        code2name.put("MT", "Malta");
        code2name.put("NR", "NAURU");
        code2name.put("openaire3.0", "OpenAIRE 3.0 (OA, funding)");
        code2name.put("0000", "Unknown");
        code2name.put("FK", "FALKLAND ISLANDS (MALVINAS)");
        code2name.put("NU", "NIUE");
        code2name.put("AQ", "ANTARCTICA");
        code2name.put("CC", "COCOS (KEELING) ISLANDS");
        code2name.put("publication", "publication");
        code2name.put("user:claim:pid", "user:claim:pid");
        code2name.put("EMBARGO", "Embargo");
        code2name.put("0011", "Internal report");
        code2name.put("hin", "Hindi");
        code2name.put("0010", "Lecture");
        code2name.put("BM", "BERMUDA");
        code2name.put("pubsrepository::unknown", "Publication Repository");
        code2name.put("result", "result");
        code2name.put("websource", "Other Source");
        code2name.put("BQ", "BONAIRE, SINT EUSTATIUS AND SABA");
        code2name.put("DJ", "DJIBOUTI");
        code2name.put("GB", "UNITED KINGDOM");
        code2name.put("TF", "FRENCH SOUTHERN TERRITORIES");
        code2name.put("ido", "Ido");
        code2name.put("0017", "Report");
        code2name.put("BV", "BOUVET ISLAND");
        code2name.put("MG", "Madagascar");
        code2name.put("UM", "UNITED STATES MINOR OUTLYING ISLANDS");
        code2name.put("datasetsbyjournal", "datasetsbyjournal");
        code2name.put("IO", "BRITISH INDIAN OCEAN TERRITORY");
        code2name.put("copyrighted", "copyrighted");
        code2name.put("created", "created");
        code2name.put("notCompatible", "under validation");
        code2name.put("native", "native");
        code2name.put("fct:program", "fct:program");
        code2name.put("fct:hasParentFunding", "fct:hasParentFunding");
        code2name.put("0032", "Software Paper");
        code2name.put("AO", "ANGOLA");
        code2name.put("AR", "Argentina");
        code2name.put("AU", "Australia");
        code2name.put("sysimport:crosswalk:aggregator", "sysimport:crosswalk:aggregator");
        code2name.put("sysimport:crosswalk:cris", "sysimport:crosswalk:cris");
        code2name.put("sysimport:crosswalk:datasetarchive", "sysimport:crosswalk:datasetarchive");
        code2name.put("bem", "Bemba");
        code2name.put("deu/ger", "German");
        code2name.put("lub", "Luba-Katanga");
        code2name.put("wel/cym", "Welsh");
        code2name.put("wln", "Walloon");
        code2name.put("AT", "Austria");
        code2name.put("BH", "Bahrain");
        code2name.put("wol", "Wolof");
        code2name.put("xho", "Xhosa");
        code2name.put("file::hybrid", "file::hybrid");
        code2name.put("orcid", "Open Researcher and Contributor ID");
        code2name.put("BW", "Botswana");
        code2name.put("BR", "Brazil");
        code2name.put("BF", "Burkina Faso");
        code2name.put("KH", "Cambodia");
        code2name.put("CA", "Canada");
        code2name.put("CV", "Cape Verde");
        code2name.put("CL", "Chile");
        code2name.put("CO", "Colombia");
        code2name.put("SV", "El Salvador");
        code2name.put("PF", "FRENCH POLYNESIA");
        code2name.put("FI", "Finland");
        code2name.put("MK", "Former Yugoslav Republic of Macedonia");
        code2name.put("DE", "Germany");
        code2name.put("KO", "Kosovo * UN resolution");
        code2name.put("TR", "Turkey");
        code2name.put("TM", "Turkmenistan");
        code2name.put("UY", "Uruguay");
        code2name.put("ZM", "Zambia");
        code2name.put("pmc", "pmc");
        code2name.put("arXiv", "arXiv");
        code2name.put("httpList", "httpList");
        code2name.put("0033", "Audiovisual");
        code2name.put("0031", "Data Paper");
        code2name.put("ZW", "Zimbabwe");
        code2name.put("ec:hasframeworkprogram", "hasframeworkprogram");
        code2name.put("ec:hasprogram", "hasprogram");
        code2name.put("ec:hasspecificprogram", "hasspecificprogram");
        code2name.put("available", "available");
        code2name.put("filesystem", "filesystem");
        code2name.put("text", "text");
        code2name.put("files", "files");
        code2name.put("AL", "Albania");
        code2name.put("DZ", "Algeria");
        code2name.put("AM", "Armenia");
        code2name.put("BT", "BHUTAN");
        code2name.put("car", "Carib");
        code2name.put("cau", "Caucasian");
        code2name.put("BD", "Bangladesh");
        code2name.put("BB", "Barbados");
        code2name.put("BY", "Belarus");
        code2name.put("BE", "Belgium");
        code2name.put("ceb", "Cebuano");
        code2name.put("cel", "Celtic");
        code2name.put("BJ", "Benin");
        code2name.put("BA", "Bosnia and Herzegovina");
        code2name.put("BN", "Brunei Darussalam");
        code2name.put("BG", "Bulgaria");
        code2name.put("CF", "Central African Republic");
        code2name.put("CN", "China (People's Republic of)");
        code2name.put("CY", "Cyprus");
        code2name.put("DO", "Dominican Republic");
        code2name.put("EC", "Ecuador");
        code2name.put("ces/cze", "Czech");
        code2name.put("chb", "Chibcha");
        code2name.put("chg", "Chagatai");
        code2name.put("chi/zho", "Chinese");
        code2name.put("chm", "Mari");
        code2name.put("him", "Himachali");
        code2name.put("hup", "Hupa");
        code2name.put("iba", "Iban");
        code2name.put("ijo", "Ijo");
        code2name.put("ilo", "Iloko");
        code2name.put("inc", "Indic");
        code2name.put("mul", "Multiple languages");
        code2name.put("file::PDF", "file::PDF");
        code2name.put("file::WoS", "file::WoS");
        code2name.put("metadata", "metadata");
        code2name.put("FCT", "Funda\u00e7\u00e3o para a Ci\u00eancia e Tecnologia");
        code2name.put("EG", "Egypt");
        code2name.put("EE", "Estonia");
        code2name.put("ET", "Ethiopia");
        code2name.put("UG", "Uganda");
        code2name.put("UA", "Ukraine");
        code2name.put("US", "United States");
        code2name.put("UZ", "Uzbekistan");
        code2name.put("VN", "Viet Nam");
        code2name.put("YE", "Yemen");
        code2name.put("orcidworkid", "orcid workid");
        code2name.put("fileCSV", "fileCSV");
        code2name.put("files_by_rpc", "files_by_rpc");
        code2name.put("files_from_mdstore", "files_from_mdstore");
        code2name.put("MP", "NORTHERN MARIANA ISLANDS");
        code2name.put("datarepository::unknown", "Data Repository");
        code2name.put("entityregistry", "Entity Registry");
        code2name.put("infospace", "Information Space");
        code2name.put("pubsrepository::institutional", "Institutional Publication Repository");
        code2name.put("sysimport:mining:cris", "sysimport:mining:cris");
        code2name.put("sysimport:mining:datasetarchive", "sysimport:mining:datasetarchive");
        code2name.put("sysimport:mining:entityregistry", "sysimport:mining:entityregistry");
        code2name.put("pubsrepository::journal", "Journal Platform");
        code2name.put("NP", "Nepal");
        code2name.put("AN", "Netherlands Antilles");
        code2name.put("NC", "New Caledonia");
        code2name.put("FO", "Faroe Islands");
        code2name.put("MU", "Mauritius");
        code2name.put("MX", "Mexico");
        code2name.put("sysimport:mining:infospace", "sysimport:mining:infospace");
        code2name.put("KN", "SAINT KITTS AND NEVIS");
        code2name.put("LC", "SAINT LUCIA");
        code2name.put("MF", "SAINT MARTIN (FRENCH PART)");
        code2name.put("CH", "Switzerland");
        code2name.put("SY", "Syrian Arab Republic");
        code2name.put("TL", "TIMOR-LESTE");
        code2name.put("TK", "TOKELAU");
        code2name.put("PM", "SAINT PIERRE AND MIQUELON");
        code2name.put("TO", "TONGA");
        code2name.put("TC", "TURKS AND CAICOS ISLANDS");
        code2name.put("TV", "TUVALU");
        code2name.put("TW", "Taiwan");
        code2name.put("TJ", "Tajikistan");
        code2name.put("ina", "Auxiliary Language Association)");
        code2name.put("kas", "Kashmiri");
        code2name.put("kau", "Kanuri");
        code2name.put("kaw", "Kawi");
        code2name.put("aggregator::pubsrepository::unknown", "Aggregator of Publication Repositories");
        code2name.put("crissystem", "CRIS System");
        code2name.put("MD", "Moldova (Republic of)");
        code2name.put("ME", "Montenegro");
        code2name.put("VC", "SAINT VINCENT AND THE GRENADINES");
        code2name.put("WS", "SAMOA");
        code2name.put("ST", "SAO TOME AND PRINCIPE");
        code2name.put("SL", "SIERRA LEONE");
        code2name.put("MC", "Support for training and career development of researchers (Marie Curie)");
        code2name.put("TZ", "Tanzania (United Republic of)");
        code2name.put("TH", "Thailand");
        code2name.put("TG", "Togo");
        code2name.put("MA", "Morocco");
        code2name.put("MZ", "Mozambique");
        code2name.put("MM", "Myanmar");
        code2name.put("SR", "Suriname");
        code2name.put("SZ", "Swaziland");
        code2name.put("startDate", "startDate");
        code2name.put("NF", "NORFOLK ISLAND");
        code2name.put("sysimport:mining:aggregator", "sysimport:mining:aggregator");
        code2name.put("SE", "Sweden");
        code2name.put("submitted", "submitted");
        code2name.put("valid", "valid");
        code2name.put("cad", "Caddo");
        code2name.put("GH", "Ghana");
        code2name.put("GI", "Gibraltar");
        code2name.put("EL", "Greece");
        code2name.put("PY", "PARAGUAY");
        code2name.put("PN", "PITCAIRN");
        code2name.put("cai", "Central American Indian");
        code2name.put("cus", "Cushitic");
        code2name.put("PR", "PUERTO RICO");
        code2name.put("PS", "Palestinian-administered areas");
        code2name.put("lim", "Limburgan; Limburger; Limburgish");
        code2name.put("PA", "Panama");
        code2name.put("PG", "Papua New Guinea");
        code2name.put("GS", "SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS");
        code2name.put("SS", "SOUTH SUDAN");
        code2name.put("SJ", "SVALBARD AND JAN MAYEN");
        code2name.put("SM", "San Marino");
        code2name.put("SK", "Slovakia");
        code2name.put("SI", "Slovenia");
        code2name.put("SO", "Somalia");
        code2name.put("ZA", "South Africa");
        code2name.put("PK", "Pakistan");
        code2name.put("ES", "Spain");
        code2name.put("LK", "Sri Lanka");
        code2name.put("uig", "Uighur; Uyghur");
        code2name.put("sysimport:mining:repository", "sysimport:mining:repository");
        code2name.put("ERC", "Support for frontier research (ERC)");
        code2name.put("6MONTHS", "6 Months Embargo");
        code2name.put("CLOSED", "Closed Access");
        code2name.put("bur/mya", "Burmese");
        code2name.put("0001", "Article");
        code2name.put("chn", "Chinook jargon");
        code2name.put("0002", "Book");
        code2name.put("SA", "Saudi Arabia");
        code2name.put("SN", "Senegal");
        code2name.put("cho", "Choctaw");
        code2name.put("chr", "Cherokee");
        code2name.put("chu", "Church Slavic; Slavonic; Church Slavonic; Old Bulgarian; Old Church Slavonic");
        code2name.put("chv", "Chuvash");
        code2name.put("cym/wel", "Welsh");
        code2name.put("dak", "Dakota");
        code2name.put("del", "Delaware");
        code2name.put("din", "Dinka");
        code2name.put("nno", "Norwegian Nynorsk; Nynorsk, Norwegian");
        code2name.put("pon", "Ponape");
        code2name.put("por", "Portuguese");
        code2name.put("pra", "Prakrit");
        code2name.put("pro", "Provencal");
        code2name.put("0004", "Conference object");
        code2name.put("0005", "Contribution for newspaper or weekly magazine");
        code2name.put("0006", "Doctoral thesis");
        code2name.put("GN", "Guinea");
        code2name.put("0007", "Master thesis");
        code2name.put("NZ", "New Zealand");
        code2name.put("NI", "Nicaragua");
        code2name.put("NE", "Niger");
        code2name.put("PE", "Peru");
        code2name.put("PH", "Philippines");
        code2name.put("SD", "Sudan");
        code2name.put("PL", "Poland");
        code2name.put("RS", "Serbia");
        code2name.put("san", "Sanskrit");
        code2name.put("GE", "Georgia");
        code2name.put("hrv", "Croatian");
        code2name.put("SX", "SINT MAARTEN (DUTCH PART)");
        code2name.put("TT", "Trinidad and Tobago");
        code2name.put("NG", "Nigeria");
        code2name.put("NO", "Norway");
        code2name.put("OM", "Oman");
        code2name.put("SB", "SOLOMON ISLANDS");
        code2name.put("TN", "Tunisia");
        code2name.put("updated", "updated");
        code2name.put("SC", "Seychelles");
        code2name.put("SG", "Singapore");
    }
}

