<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dri="http://www.driver-repository.eu/namespace/dri"
	xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf"
	xmlns:dnet="eu.dnetlib.data.transform.xml.DNetMdStoreDataCiteToHbaseXsltFunctions"
	xmlns:exslt="http://exslt.org/common" extension-element-prefixes="exslt"
	exclude-result-prefixes="xsl dc dr dri oaa oaf dnet exslt">

	<xsl:output omit-xml-declaration="yes" indent="yes" />
	<xsl:template match="/*">
		<xsl:variable name="dataInfo" select="/*[local-name() = 'record']/*[local-name() = 'about']/*[local-name() = 'datainfo']"/>
		<xsl:variable name="dateofcollection" select="//dri:dateOfCollection" />
		<xsl:variable name="metadata"
			select="exslt:node-set(//*[local-name()='metadata']/*)" />
		<xsl:variable name="namespaceprefix">
			<xsl:choose>
				<!-- TODO check namespaceprefix length is 12 -->
				<xsl:when test="string-length(//oaf:datasourceprefix) &gt; 0">
					<xsl:value-of select="//oaf:datasourceprefix" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="unknown_____" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:choose>
			<xsl:when
				test="count($metadata) = 0 or normalize-space(//oaf:skipRecord)= 'true'">
				<ROWS />
			</xsl:when>
			<xsl:otherwise>

				<xsl:variable name="resultId"
					select="dnet:oafSimpleId('result', //dri:objIdentifier)" />

				<xsl:if test="string-length($resultId) &gt; 0">
					<xsl:variable name="originalid"
						select="concat('',  //*[local-name() = 'resource']/*[local-name()='identifier'])" />
					<xsl:variable name="creators" select="//*[local-name() = 'creator']" />
					<xsl:variable name="titles" select="//*[local-name() = 'title']" />
					<xsl:variable name="subjects" select="//*[local-name() = 'subject']" />
					<xsl:variable name="publisher" select="//*[local-name() = 'publisher']" />
					<xsl:variable name="descriptions" select="//*[local-name() = 'description']" />
					<xsl:variable name="dates" select="//*[local-name() = 'date']" />
					<xsl:variable name="dateaccepted" select="//oaf:dateAccepted" />
					<xsl:variable name="resourceType"
						select="//*[local-name() = 'resourceType']" />
					<xsl:variable name="formats" select="//*[local-name() = 'format']" />
					<xsl:variable name="sizes" select="//*[local-name() = 'size']" />
					<xsl:variable name="rights" select="//oaf:accessrights" />
					<xsl:variable name="version" select="//*[local-name() = 'version']" />
					<xsl:variable name="language" select="//oaf:language" />
					<xsl:variable name="cobjcategory" select="//dr:CobjCategory" />

					<xsl:variable name="instanceURI">
						<xsl:choose>
							<xsl:when
								test="string-length( //*[local-name() = 'resource']/*[local-name()='identifier' and ./@identifierType='DOI']) &gt; 0">
								<xsl:value-of
									select="concat('http://dx.doi.org','/', //*[local-name() = 'resource']/*[local-name()='identifier' and ./@identifierType='DOI']/text())" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of
									select="concat('', //*[local-name() = 'resource']/*[local-name()='identifier' and ./@identifierType='URL'])" />
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>

					<xsl:variable name="hostedbyid"
						select="dnet:oafSplitId('datasource', //oaf:hostedBy/@id)" />
					<xsl:variable name="hostedbyname" select="concat('', //oaf:hostedBy/@name)" />
					<xsl:variable name="collectedfromid"
						select="dnet:oafSplitId('datasource', //oaf:collectedFrom/@id)" />
					<xsl:variable name="collectedfromname"
						select="concat('', //oaf:collectedFrom/@name)" />
					<xsl:variable name="dateOfCollection"
						select="concat('', //dri:dateOfCollection)" />

					<xsl:variable name="result"
						select="dnet:oafResult_FromDatacite($resultId, $dataInfo, $metadata, $titles, 
                        $subjects, $publisher, $descriptions, $dates, $dateaccepted, $resourceType, 
                        $formats, $sizes, $language, $cobjcategory, $rights, $version, $hostedbyid, $hostedbyname,
                        $collectedfromid, $collectedfromname, $originalid, $instanceURI, $dateOfCollection)" />

					<ROWS>
						<ROW key="{$resultId}" columnFamily="result">
							<QUALIFIER name="body" type="base64">
								<xsl:value-of select="$result" />
							</QUALIFIER>
						</ROW>
						<xsl:for-each select="//*[local-name() = 'creator']">
							<xsl:variable name="personIdTemp">
								<xsl:choose>
									<xsl:when
										test="string-length(./*[local-name() = 'nameIdentifier']) &gt; 0">
										<xsl:value-of
											select="translate(normalize-space(./*[local-name() = 'nameIdentifier']),' .,','___')" />
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of
											select="translate(normalize-space(./*[local-name() = 'creatorName']),' .,','___')" />
									</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							<xsl:variable name="personId"
								select="dnet:oafId('person', $namespaceprefix, normalize-space($personIdTemp))" />

							<xsl:variable name="originalPersonId"
								select="./*[local-name() = 'nameIdentifier']" />
							<xsl:variable name="position" select="position()" />
							<xsl:if test="string-length($personId) &gt; 0">
								<xsl:variable name="person"
									select="dnet:oafPerson_FromDatacite($personId, $dataInfo, $collectedfromid, $collectedfromname,$originalPersonId, $dateOfCollection ,normalize-space(./*[local-name() = 'creatorName']))" />

								<xsl:variable name="personresult"
									select="dnet:oafPersonResult_Authorship_FromDatacite($personId, $resultId, $position, 'isAuthorOf', $dataInfo)" />
								<xsl:variable name="resultperson"
									select="dnet:oafPersonResult_Authorship_FromDatacite($resultId, $personId, $position, 'hasAuthor', $dataInfo)" />
								<ROW key="{$personId}" columnFamily="person">
									<QUALIFIER name="body" type="base64">
										<xsl:value-of select="$person" />
									</QUALIFIER>
								</ROW>
								<ROW key="{$personId}" columnFamily="personResult_authorship_isAuthorOf">
									<QUALIFIER name="{$resultId}" type="base64">
										<xsl:value-of select="$personresult" />
									</QUALIFIER>
								</ROW>
								<ROW key="{$resultId}" columnFamily="personResult_authorship_hasAuthor">
									<QUALIFIER name="{$personId}" type="base64">
										<xsl:value-of select="$resultperson" />
									</QUALIFIER>
								</ROW>
							</xsl:if>
						</xsl:for-each>

						<xsl:for-each select="//*[local-name()='projectid']">

							<xsl:variable name="projectId"
								select="dnet:oafSplitId('project', normalize-space(.))" />

							<xsl:variable name="resultproject"
								select="dnet:oafResultProject_Outcome_FromDatacite($resultId, $projectId, 'isProducedBy', $dataInfo)" />
							<xsl:variable name="projectresult"
								select="dnet:oafResultProject_Outcome_FromDatacite($projectId, $resultId, 'produces', $dataInfo)" />

							<xsl:if test="string-length($projectId) &gt; 0">
								<ROW key="{$resultId}" columnFamily="resultProject_outcome_isProducedBy">
									<QUALIFIER name="{$projectId}" type="base64">
										<xsl:value-of select="$resultproject" />
									</QUALIFIER>
								</ROW>
								<ROW key="{$projectId}" columnFamily="resultProject_outcome_produces">
									<QUALIFIER name="{$resultId}" type="base64">
										<xsl:value-of select="$projectresult" />
									</QUALIFIER>
								</ROW>
							</xsl:if>
						</xsl:for-each>

						<xsl:for-each select="//*[local-name()='relatedPublication']">

							<!-- relatedDataset ids must be in the openaire format  -->
							<xsl:variable name="publicationId" select="dnet:oafSimpleId('result', normalize-space(./@id))"/>

							<xsl:if test="string-length($publicationId) &gt; 0">

								<xsl:variable name="resultDataset" select="dnet:oafResultResult_PublicationDataset_FromDatacite($resultId, $publicationId, 'isRelatedTo', $dataInfo)"/>
								<xsl:variable name="datasetResult" select="dnet:oafResultResult_PublicationDataset_FromDatacite($publicationId, $resultId, 'isRelatedTo', $dataInfo)"/>

								<ROW key="{$resultId}" columnFamily="resultResult_publicationDataset_isRelatedTo">
									<QUALIFIER name="{$publicationId}" type="base64"><xsl:value-of select="$resultDataset"/></QUALIFIER>
								</ROW>
								<ROW key="{$publicationId}" columnFamily="resultResult_publicationDataset_isRelatedTo">
									<QUALIFIER name="{$resultId}" type="base64"><xsl:value-of select="$datasetResult"/></QUALIFIER>
								</ROW>
							</xsl:if>
						</xsl:for-each>
					</ROWS>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>