<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dri="http://www.driver-repository.eu/namespace/dri"
	xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf"
	xmlns:dnet="eu.dnetlib.actionmanager.actions.infopackage.DMFInfoPackageToHbaseXsltFunctions"
	xmlns:exslt="http://exslt.org/common" xmlns:action="http://namespace.openaire.eu/action" 
	extension-element-prefixes="exslt"
	exclude-result-prefixes="xsl dc dr dri oaa oaf dnet exslt">

	<xsl:output omit-xml-declaration="yes" indent="yes" />

	<xsl:param name="trust" select="string('0.9')" />
	<xsl:param name="provenance" select="string('UNKNOWN')" />
	<xsl:param name="namespaceprefix" select="string('unknown_____')" />

	<xsl:template match="/*">

		<xsl:choose>
			<xsl:when test="count(//RELATION) = 0">
				<ACTIONS />
			</xsl:when>
			<xsl:otherwise>
				<ACTIONS>
					<xsl:for-each select="//RELATION">
						<xsl:choose>
							<xsl:when test="./@type = 'resultProject'">
								<xsl:variable name="resultId" select="./@source" />
								<xsl:variable name="projectId">
									<xsl:choose>
										<xsl:when test="starts-with(@target, '40|')">
											<xsl:value-of select="./@target" />
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="dnet:oafSplitId('project', normalize-space(@target))"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								
								<ACTION targetKey="{$resultId}" targetColumnFamily="resultProject_outcome_isProducedBy" targetColumn="{$projectId}">
									<xsl:value-of select="dnet:oafResultProjectFromInfoPackage($resultId, $projectId, 'isProducedBy', $provenance, $trust)" />
								</ACTION>
								<ACTION targetKey="{$projectId}" targetColumnFamily="resultProject_outcome_produces" targetColumn="{$resultId}">
									<xsl:value-of select="dnet:oafResultProjectFromInfoPackage($projectId, $resultId, 'produces', $provenance, $trust)" />
								</ACTION>
							</xsl:when>
							
							<!-- TODO: check this block, it caused problems:
									Cannot convert argument/return type in call to method 'eu.dnetlib.actionmanager.actions.infopackage.DMFInfoPackageToHbaseXsltFunctions.oafPersonResultFromInfoPackage(node-set, node-set, result-tree, reference, reference)'
									FATAL ERROR:  'Could not compile stylesheet'
							
							<xsl:when test="./@type = 'personResult'">
								<xsl:variable name="personId" select="./@source" />
								<xsl:variable name="resultId" select="./@target" />
								
								<xsl:variable name="pos">
									<xsl:choose>
										<xsl:when test="@position"><xsl:value-of select="@position"/></xsl:when>
										<xsl:otherwise>1000</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>

								<ACTION targetKey="{$personId}" targetColumnFamily="personResult" targetColumn="{$resultId}">
									<xsl:value-of select="dnet:oafPersonResultFromInfoPackage($personId, $resultId, $pos, $provenance, $trust)" />
								</ACTION>
								<ACTION targetKey="{$resultId}" targetColumnFamily="personResult" targetColumn="{$personId}">
									<xsl:value-of select="dnet:oafPersonResultFromInfoPackage($resultId, $personId, $pos, $provenance, $trust)" />
								</ACTION>
							</xsl:when>
							-->
						</xsl:choose>
					</xsl:for-each>
				</ACTIONS>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
